/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPSessions;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.util.IIdleNotify;
import com.wowza.wms.vhost.VHostSessionHolder;
import com.wowza.wms.vhost.VHostSessionIdleBase;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoSession;

public class VHostSessionIdleRTSP
extends VHostSessionIdleBase
implements IIdleNotify {
    public long lastIdleTime = -1L;
    public long sessionIdleTimeout = -1L;

    public VHostSessionIdleRTSP(VHostSessionHolder vHostSessionHolder) {
        super(vHostSessionHolder);
    }

    public void onIdle(long l) {
        try {
            if (this.sessionHolder.vhost != null) {
                int n;
                RTPContext rTPContext;
                RTPSessions rTPSessions;
                RTPSession rTPSession;
                String string;
                RtmpSessionInfo rtmpSessionInfo;
                while (this.sessionIdleTimeout < 0L && (rtmpSessionInfo = (RtmpSessionInfo)this.sessionHolder.session.getAttribute("wmsSessionInfo")) != null && (string = rtmpSessionInfo.getRTSPSessionId()) != null && (rTPSession = (rTPSessions = (rTPContext = this.sessionHolder.vhost.getRTPContext()).getSessions()).getSession(string)) != null && (n = rTPSession.getIdleFrequency()) >= 0) {
                    this.sessionIdleTimeout = n;
                }
                long l2 = this.sessionHolder.vhost.getRTPIdleFrequency();
                if (this.sessionIdleTimeout > 0L) {
                    l2 = this.sessionIdleTimeout;
                }
                long l3 = Math.max(this.sessionHolder.session.getLastIoTime(), this.sessionHolder.session.getLastIdleTime(IdleStatus.BOTH_IDLE));
                if (l2 > 0L && l3 != 0L && l - l3 >= l2) {
                    this.sessionHolder.session.increaseIdleCount(IdleStatus.BOTH_IDLE);
                    this.sessionHolder.session.getFilterChain().fireSessionIdle((IoSession)this.sessionHolder.session, IdleStatus.BOTH_IDLE);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostSessionIdleRTSP.class).error("VHostSessionIdleRTSP.onIdle: " + exception.toString());
        }
    }
}

