/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler;

import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import org.apache.commons.modeler.BaseAttributeFilter;
import org.apache.commons.modeler.BaseNotificationBroadcaster;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.modules.ModelerSource;

public class BaseModelMBean
implements ModelMBean,
MBeanRegistration {
    protected BaseNotificationBroadcaster attributeBroadcaster = null;
    protected Registry registry = null;
    protected BaseNotificationBroadcaster generalBroadcaster = null;
    protected ObjectName oname = null;
    protected ModelMBeanInfo info = null;
    protected Object resource = null;
    protected String resourceType = null;
    protected ModelerSource source = null;
    protected HashMap attributes = new HashMap();
    static final Object[] NO_ARGS_PARAM = new Object[0];
    static final Class[] NO_ARGS_PARAM_SIG = new Class[0];
    private Hashtable getAttMap = new Hashtable();
    private Hashtable setAttMap = new Hashtable();
    private Hashtable invokeAttMap = new Hashtable();

    public BaseModelMBean() throws MBeanException, RuntimeOperationsException {
        this.setModelMBeanInfo(this.createDefaultModelMBeanInfo());
    }

    public BaseModelMBean(ModelMBeanInfo modelMBeanInfo) throws MBeanException, RuntimeOperationsException {
        this.setModelMBeanInfo(modelMBeanInfo);
    }

    public BaseModelMBean(String string) throws MBeanException, RuntimeOperationsException {
        try {
            this.setModeledType(string);
        }
        catch (Throwable throwable) {
            WMSLoggerFactory.getLogger(BaseModelMBean.class).error((Object)"Error creating mbean ", throwable);
        }
    }

    public BaseModelMBean(String string, ModelerSource modelerSource) throws MBeanException, RuntimeOperationsException {
        try {
            this.setModeledType(string);
        }
        catch (Throwable throwable) {
            WMSLoggerFactory.getLogger(BaseModelMBean.class).error((Object)"Error creating mbean ", throwable);
        }
        this.source = modelerSource;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object object;
        Serializable serializable;
        Object object2;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name is null"), "Attribute name is null");
        }
        if (this.resource instanceof DynamicMBean && !(this.resource instanceof BaseModelMBean)) {
            return ((DynamicMBean)this.resource).getAttribute(string);
        }
        Method method = (Method)this.getAttMap.get(string);
        if (method == null) {
            object2 = this.info.getAttribute(string);
            if (object2 == null) {
                throw new AttributeNotFoundException(" Cannot find attribute " + string);
            }
            serializable = ((ModelMBeanAttributeInfo)object2).getDescriptor();
            if (serializable == null) {
                throw new AttributeNotFoundException("Cannot find attribute " + string + " descriptor");
            }
            object = (String)serializable.getFieldValue("getMethod");
            if (object == null) {
                throw new AttributeNotFoundException("Cannot find attribute " + string + " get method name");
            }
            Object object3 = null;
            NoSuchMethodException noSuchMethodException = null;
            try {
                object3 = this;
                method = object3.getClass().getMethod((String)object, NO_ARGS_PARAM_SIG);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                noSuchMethodException = noSuchMethodException2;
            }
            if (method == null && this.resource != null) {
                try {
                    object3 = this.resource;
                    method = object3.getClass().getMethod((String)object, NO_ARGS_PARAM_SIG);
                    noSuchMethodException = null;
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    noSuchMethodException = noSuchMethodException3;
                }
            }
            if (noSuchMethodException != null) {
                throw new ReflectionException(noSuchMethodException, "Cannot find getter method " + (String)object);
            }
            this.getAttMap.put(string, method);
        }
        object2 = null;
        try {
            serializable = method.getDeclaringClass();
            object2 = ((Class)serializable).isAssignableFrom(this.getClass()) ? method.invoke((Object)this, NO_ARGS_PARAM) : method.invoke(this.resource, NO_ARGS_PARAM);
        }
        catch (InvocationTargetException invocationTargetException) {
            object = invocationTargetException.getTargetException();
            if (object == null) {
                object = invocationTargetException;
            }
            if (object instanceof RuntimeException) {
                throw new RuntimeOperationsException((RuntimeException)object, "Exception invoking method " + string);
            }
            if (object instanceof Error) {
                throw new RuntimeErrorException((Error)object, "Error invoking method " + string);
            }
            throw new MBeanException(invocationTargetException, "Exception invoking method " + string);
        }
        catch (Exception exception) {
            throw new MBeanException(exception, "Exception invoking method " + string);
        }
        return object2;
    }

    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute names list is null"), "Attribute names list is null");
        }
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                attributeList.add(new Attribute(stringArray[i], this.getAttribute(stringArray[i])));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return attributeList;
    }

    public MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            return null;
        }
        return (MBeanInfo)this.info.clone();
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        Object object;
        Object object2;
        MethodKey methodKey;
        Method method;
        if (this.resource instanceof DynamicMBean && !(this.resource instanceof BaseModelMBean)) {
            return ((DynamicMBean)this.resource).invoke(string, objectArray, stringArray);
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Method name is null"), "Method name is null");
        }
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(BaseModelMBean.class);
        if (wMSLogger.isDebugEnabled()) {
            wMSLogger.debug("Invoke " + string);
        }
        if ((method = (Method)this.invokeAttMap.get(methodKey = new MethodKey(string, stringArray))) == null) {
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            if (objectArray.length != stringArray.length) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Inconsistent arguments and signature"), "Inconsistent arguments and signature");
            }
            object2 = this.info.getOperation(string);
            if (object2 == null) {
                throw new MBeanException(new ServiceNotFoundException("Cannot find operation " + string), "Cannot find operation " + string);
            }
            Class[] classArray = new Class[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                classArray[i] = this.getAttributeClass(stringArray[i]);
            }
            object = null;
            NoSuchMethodException noSuchMethodException = null;
            try {
                object = this;
                method = object.getClass().getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                noSuchMethodException = noSuchMethodException2;
            }
            try {
                if (method == null && this.resource != null) {
                    object = this.resource;
                    method = object.getClass().getMethod(string, classArray);
                }
            }
            catch (NoSuchMethodException noSuchMethodException3) {
                noSuchMethodException = noSuchMethodException3;
            }
            if (method == null) {
                throw new ReflectionException(noSuchMethodException, "Cannot find method " + string + " with this signature");
            }
            this.invokeAttMap.put(methodKey, method);
        }
        object2 = null;
        try {
            object2 = method.getDeclaringClass().isAssignableFrom(this.getClass()) ? method.invoke((Object)this, objectArray) : method.invoke(this.resource, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            object = invocationTargetException.getTargetException();
            wMSLogger.error((Object)("Exception invoking method " + string), (Throwable)object);
            if (object == null) {
                object = invocationTargetException;
            }
            if (object instanceof RuntimeException) {
                throw new RuntimeOperationsException((RuntimeException)object, "Exception invoking method " + string);
            }
            if (object instanceof Error) {
                throw new RuntimeErrorException((Error)object, "Error invoking method " + string);
            }
            throw new MBeanException((Exception)object, "Exception invoking method " + string);
        }
        catch (Exception exception) {
            wMSLogger.error((Object)("Exception invoking method " + string), (Throwable)exception);
            throw new MBeanException(exception, "Exception invoking method " + string);
        }
        return object2;
    }

    private Class getAttributeClass(String string) throws ReflectionException {
        if (string.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (string.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (string.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (string.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        if (string.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (string.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (string.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        if (string.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "Cannot find Class for " + string);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Class[] classArray;
        Object object;
        Method method;
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(BaseModelMBean.class);
        if (wMSLogger.isDebugEnabled()) {
            wMSLogger.debug("Setting attribute " + this + " " + attribute);
        }
        if (this.resource instanceof DynamicMBean && !(this.resource instanceof BaseModelMBean)) {
            try {
                ((DynamicMBean)this.resource).setAttribute(attribute);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new MBeanException(invalidAttributeValueException);
            }
            return;
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute is null"), "Attribute is null");
        }
        String string = attribute.getName();
        Object object2 = attribute.getValue();
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name is null"), "Attribute name is null");
        }
        ModelMBeanAttributeInfo modelMBeanAttributeInfo = this.info.getAttribute(string);
        if (modelMBeanAttributeInfo == null) {
            throw new AttributeNotFoundException("Cannot find attribute " + string);
        }
        Descriptor descriptor = modelMBeanAttributeInfo.getDescriptor();
        if (descriptor == null) {
            throw new AttributeNotFoundException("Cannot find attribute " + string + " descriptor");
        }
        Object object3 = null;
        if (this.getAttMap.get(string) != null) {
            object3 = this.getAttribute(string);
        }
        if ((method = (Method)this.setAttMap.get(string)) == null) {
            object = (String)descriptor.getFieldValue("setMethod");
            if (object == null) {
                throw new AttributeNotFoundException("Cannot find attribute " + string + " set method name");
            }
            String string2 = modelMBeanAttributeInfo.getType();
            classArray = new Class[]{this.getAttributeClass(string2)};
            Object object4 = null;
            NoSuchMethodException noSuchMethodException = null;
            try {
                object4 = this;
                method = object4.getClass().getMethod((String)object, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                noSuchMethodException = noSuchMethodException2;
            }
            if (method == null && this.resource != null) {
                try {
                    object4 = this.resource;
                    method = object4.getClass().getMethod((String)object, classArray);
                    noSuchMethodException = null;
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    if (wMSLogger.isDebugEnabled()) {
                        wMSLogger.debug("Method not found in resource " + this.resource);
                    }
                    noSuchMethodException = noSuchMethodException3;
                }
            }
            if (noSuchMethodException != null) {
                throw new ReflectionException(noSuchMethodException, "Cannot find setter method " + (String)object + " " + this.resource);
            }
            this.setAttMap.put(string, method);
        }
        object = null;
        try {
            object = method.getDeclaringClass().isAssignableFrom(this.getClass()) ? method.invoke((Object)this, object2) : method.invoke(this.resource, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            classArray = invocationTargetException.getTargetException();
            if (classArray == null) {
                classArray = invocationTargetException;
            }
            if (classArray instanceof RuntimeException) {
                throw new RuntimeOperationsException((RuntimeException)classArray, "Exception invoking method " + string);
            }
            if (classArray instanceof Error) {
                throw new RuntimeErrorException((Error)classArray, "Error invoking method " + string);
            }
            throw new MBeanException(invocationTargetException, "Exception invoking method " + string);
        }
        catch (Exception exception) {
            wMSLogger.error((Object)("Exception invoking method " + string), (Throwable)exception);
            throw new MBeanException(exception, "Exception invoking method " + string);
        }
        try {
            this.sendAttributeChangeNotification(new Attribute(string, object3), attribute);
        }
        catch (Exception exception) {
            wMSLogger.error((Object)("Error sending notification " + string), (Throwable)exception);
        }
        this.attributes.put(string, object2);
        if (this.source != null) {
            this.source.updateField(this.oname, string, object2);
        }
    }

    public String toString() {
        if (this.resource == null) {
            return "BaseModelMbean[" + this.resourceType + "]";
        }
        return this.resource.toString();
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        if (attributeList == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes list is null"), "Attributes list is null");
        }
        AttributeList attributeList2 = new AttributeList();
        String[] stringArray = new String[attributeList.size()];
        int n = 0;
        for (Attribute attribute : attributeList) {
            stringArray[n++] = attribute.getName();
            try {
                this.setAttribute(attribute);
            }
            catch (Exception exception) {}
        }
        return this.getAttributes(stringArray);
    }

    public Object getManagedResource() throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException, RuntimeOperationsException {
        if (this.resource == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Managed resource is null"), "Managed resource is null");
        }
        return this.resource;
    }

    public void setManagedResource(Object object, String string) throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException, RuntimeOperationsException {
        if (object == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Managed resource is null"), "Managed resource is null");
        }
        if (!"objectreference".equalsIgnoreCase(string)) {
            throw new InvalidTargetObjectTypeException(string);
        }
        this.resource = object;
        this.resourceType = object.getClass().getName();
        try {
            Method method = object.getClass().getMethod("setModelMBean", ModelMBean.class);
            if (method != null) {
                method.invoke(object, this);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable throwable) {
            WMSLoggerFactory.getLogger(BaseModelMBean.class).error((Object)"Can't set model mbean ", throwable);
        }
    }

    public void setModelMBeanInfo(ModelMBeanInfo modelMBeanInfo) throws MBeanException, RuntimeOperationsException {
        if (modelMBeanInfo == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo is null"), "ModelMBeanInfo is null");
        }
        if (!this.isModelMBeanInfoValid(modelMBeanInfo)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo is invalid"), "ModelMBeanInfo is invalid");
        }
        this.info = (ModelMBeanInfo)modelMBeanInfo.clone();
    }

    public void addAttributeChangeNotificationListener(NotificationListener notificationListener, String string, Object object) throws IllegalArgumentException {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new BaseNotificationBroadcaster();
        }
        BaseAttributeFilter baseAttributeFilter = new BaseAttributeFilter(string);
        this.attributeBroadcaster.addNotificationListener(notificationListener, baseAttributeFilter, object);
    }

    public void removeAttributeChangeNotificationListener(NotificationListener notificationListener, String string) throws ListenerNotFoundException {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new BaseNotificationBroadcaster();
        }
        this.attributeBroadcaster.removeNotificationListener(notificationListener);
    }

    public void removeAttributeChangeNotificationListener(NotificationListener notificationListener, String string, Object object) throws ListenerNotFoundException {
        this.removeAttributeChangeNotificationListener(notificationListener, string);
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification attributeChangeNotification) throws MBeanException, RuntimeOperationsException {
        if (attributeChangeNotification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification is null"), "Notification is null");
        }
        if (this.attributeBroadcaster == null) {
            return;
        }
        this.attributeBroadcaster.sendNotification(attributeChangeNotification);
    }

    public void sendAttributeChangeNotification(Attribute attribute, Attribute attribute2) throws MBeanException, RuntimeOperationsException {
        String string = null;
        if (attribute2.getValue() != null) {
            string = attribute2.getValue().getClass().getName();
        } else if (attribute.getValue() != null) {
            string = attribute.getValue().getClass().getName();
        } else {
            return;
        }
        AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification(this, 1L, System.currentTimeMillis(), "Attribute value has changed", attribute.getName(), string, attribute.getValue(), attribute2.getValue());
        this.sendAttributeChangeNotification(attributeChangeNotification);
    }

    public void sendNotification(Notification notification) throws MBeanException, RuntimeOperationsException {
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification is null"), "Notification is null");
        }
        if (this.generalBroadcaster == null) {
            return;
        }
        this.generalBroadcaster.sendNotification(notification);
    }

    public void sendNotification(String string) throws MBeanException, RuntimeOperationsException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Message is null"), "Message is null");
        }
        Notification notification = new Notification("jmx.modelmbean.generic", (Object)this, 1L, string);
        this.sendNotification(notification);
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (this.generalBroadcaster == null) {
            this.generalBroadcaster = new BaseNotificationBroadcaster();
        }
        this.generalBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new BaseNotificationBroadcaster();
        }
        this.attributeBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = this.info.getNotifications();
        if (mBeanNotificationInfoArray == null) {
            mBeanNotificationInfoArray = new MBeanNotificationInfo[]{};
        }
        MBeanNotificationInfo[] mBeanNotificationInfoArray2 = new MBeanNotificationInfo[mBeanNotificationInfoArray.length + 2];
        DescriptorSupport descriptorSupport = null;
        descriptorSupport = new DescriptorSupport("name=GENERIC", "descriptorType=notification", "log=T", "severity=5", "displayName=jmx.modelmbean.generic");
        mBeanNotificationInfoArray2[0] = new ModelMBeanNotificationInfo(new String[]{"jmx.modelmbean.generic"}, "GENERIC", "Text message notification from the managed resource", descriptorSupport);
        descriptorSupport = new DescriptorSupport("name=ATTRIBUTE_CHANGE", "descriptorType=notification", "log=T", "severity=5", "displayName=jmx.attribute.change");
        mBeanNotificationInfoArray2[1] = new ModelMBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "ATTRIBUTE_CHANGE", "Observed MBean attribute value has changed", descriptorSupport);
        System.arraycopy(mBeanNotificationInfoArray, 0, mBeanNotificationInfoArray2, 2, mBeanNotificationInfoArray.length);
        return mBeanNotificationInfoArray2;
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (this.generalBroadcaster == null) {
            this.generalBroadcaster = new BaseNotificationBroadcaster();
        }
        this.generalBroadcaster.removeNotificationListener(notificationListener);
    }

    public void removeNotificationListener(NotificationListener notificationListener, Object object) throws ListenerNotFoundException {
        this.removeNotificationListener(notificationListener);
    }

    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.removeNotificationListener(notificationListener);
    }

    public void load() throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        throw new MBeanException(new IllegalStateException("Persistence is not supported"), "Persistence is not supported");
    }

    public void store() throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        throw new MBeanException(new IllegalStateException("Persistence is not supported"), "Persistence is not supported");
    }

    public void setModeledType(String string) {
        this.initModelInfo(string);
        this.createResource();
    }

    protected void initModelInfo(String string) {
        try {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(BaseModelMBean.class);
            if (wMSLogger.isDebugEnabled()) {
                wMSLogger.debug("setModeledType " + string);
            }
            wMSLogger.debug("Set model Info " + string);
            if (string == null) {
                return;
            }
            this.resourceType = string;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (Throwable throwable) {
                wMSLogger.debug("Error creating class " + throwable);
            }
            ManagedBean managedBean = this.getRegistry().findManagedBean(clazz, string);
            if (managedBean == null) {
                return;
            }
            this.setModelMBeanInfo(managedBean.createMBeanInfo());
        }
        catch (Throwable throwable) {
            WMSLoggerFactory.getLogger(BaseModelMBean.class).error((Object)("TCL: " + Thread.currentThread().getContextClassLoader()), throwable);
        }
    }

    protected void createResource() {
        try {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(this.resourceType);
                this.resource = clazz.newInstance();
            }
            catch (Throwable throwable) {
                WMSLoggerFactory.getLogger(BaseModelMBean.class).error("Error creating class " + throwable);
            }
        }
        catch (Throwable throwable) {
            WMSLoggerFactory.getLogger(BaseModelMBean.class).error((Object)("TCL: " + Thread.currentThread().getContextClassLoader()), throwable);
        }
    }

    public String getModelerType() {
        return this.resourceType;
    }

    public String getClassName() {
        return this.getModelerType();
    }

    public ObjectName getJmxName() {
        return this.oname;
    }

    public String getObjectName() {
        if (this.oname != null) {
            return this.oname.toString();
        }
        return null;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public Registry getRegistry() {
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        return this.registry;
    }

    protected ModelMBeanInfo createDefaultModelMBeanInfo() {
        return new ModelMBeanInfoSupport(this.getClass().getName(), "Default ModelMBean", null, null, null, null);
    }

    protected boolean isModelMBeanInfoValid(ModelMBeanInfo modelMBeanInfo) {
        return true;
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.oname = objectName;
        if (this.resource instanceof MBeanRegistration) {
            this.oname = ((MBeanRegistration)this.resource).preRegister(mBeanServer, objectName);
        }
        return this.oname;
    }

    public void postRegister(Boolean bl) {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).postRegister(bl);
        }
    }

    public void preDeregister() throws Exception {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).preDeregister();
        }
    }

    public void postDeregister() {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).postDeregister();
        }
    }

    static class MethodKey {
        private String name;
        private String[] signature;

        MethodKey(String string, String[] stringArray) {
            this.name = string;
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this.signature = stringArray;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodKey)) {
                return false;
            }
            MethodKey methodKey = (MethodKey)object;
            if (!this.name.equals(methodKey.name)) {
                return false;
            }
            if (this.signature.length != methodKey.signature.length) {
                return false;
            }
            for (int i = 0; i < this.signature.length; ++i) {
                if (this.signature[i].equals(methodKey.signature[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

