/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.publish;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.publish.IPublishingProvider;
import com.wowza.wms.stream.publish.Publisher;
import com.wowza.wms.stream.publish.PublishingProviderBase;
import java.util.ArrayList;
import java.util.List;

public class PublishingProviderLive
extends PublishingProviderBase
implements IPublishingProvider {
    private long timeoffset = 0L;
    private String streamName = null;
    private boolean isFirstPacket = true;
    private long lastSeq = -1L;
    private long firstLiveTimecode = -1L;
    private long firstRealTimecode = -1L;
    private boolean waitForKeyFrame = true;
    private boolean isDebugLog = false;
    private boolean isFirstVideo = true;
    private boolean isFirstAudio = true;
    private long duration = 0L;
    private boolean moreInFile = true;
    private long streamStartTime = -1L;
    private boolean doSendOnMetaData = true;

    public PublishingProviderLive(Publisher publisher, long l, String string) {
        this.timeoffset = l;
        this.streamName = string;
        IApplicationInstance iApplicationInstance = publisher.getAppInstance();
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        IMediaStream iMediaStream = mediaStreamMap.getStream(this.streamName);
        if (iMediaStream == null) {
            return;
        }
        List list = iMediaStream.getPlayPackets();
        if (list.size() == 0) {
            return;
        }
        AMFPacket aMFPacket = (AMFPacket)list.get(list.size() - 1);
        this.lastSeq = aMFPacket.getSeq();
        this.firstLiveTimecode = aMFPacket.getAbsTimecode();
        this.isDebugLog = WMSLoggerFactory.getLogger(PublishingProviderLive.class).isDebugEnabled();
    }

    public void close() {
    }

    public boolean play(Publisher publisher) {
        IApplicationInstance iApplicationInstance = publisher.getAppInstance();
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        long l = System.currentTimeMillis();
        if (this.streamStartTime < 0L) {
            this.streamStartTime = l;
        }
        if (this.duration > 0L && l - this.streamStartTime >= this.duration) {
            this.moreInFile = false;
        } else {
            List list;
            IMediaStream iMediaStream = mediaStreamMap.getStream(this.streamName);
            if (iMediaStream != null && (list = iMediaStream.getPlayPackets()).size() > 0) {
                AMFPacket aMFPacket;
                if (this.firstRealTimecode < 0L) {
                    this.firstRealTimecode = l;
                }
                if (this.isFirstPacket) {
                    AMFPacket aMFPacket2;
                    aMFPacket = (AMFPacket)list.get(list.size() - 1);
                    if (this.lastSeq == -1L) {
                        this.lastSeq = aMFPacket.getSeq();
                        this.firstLiveTimecode = aMFPacket.getAbsTimecode();
                    }
                    if ((aMFPacket2 = iMediaStream.getLastKeyFrame()) != null) {
                        this.writePacket(iMediaStream, publisher, null, this.firstLiveTimecode);
                        this.writePacket(iMediaStream, publisher, aMFPacket2, this.firstLiveTimecode);
                    }
                    this.isFirstPacket = false;
                }
                if ((aMFPacket = (AMFPacket)list.get(list.size() - 1)).getSeq() != this.lastSeq) {
                    WMSLoggerFactory.getLogger(PublishingProviderLive.class).debug("start: " + list.size() + ":" + aMFPacket.getSeq() + ":" + this.lastSeq);
                    int n = (int)((long)list.size() - (aMFPacket.getSeq() - this.lastSeq));
                    if (n < 0) {
                        this.waitForKeyFrame = true;
                        n = 0;
                    }
                    for (int i = n; i < list.size(); ++i) {
                        AMFPacket aMFPacket3 = (AMFPacket)list.get(i);
                        if (this.waitForKeyFrame && aMFPacket3.getType() == 9) {
                            if (!FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket3)) continue;
                            this.waitForKeyFrame = false;
                        }
                        this.writePacket(iMediaStream, publisher, aMFPacket3, -1L);
                        this.lastSeq = aMFPacket3.getSeq();
                    }
                }
            }
        }
        return this.moreInFile;
    }

    private void writePacket(IMediaStream iMediaStream, Publisher publisher, AMFPacket aMFPacket, long l) {
        Object object;
        long l2 = 0L;
        long l3 = (l < 0L ? aMFPacket.getAbsTimecode() : l) - this.firstLiveTimecode;
        if (l3 < 0L) {
            return;
        }
        l2 = l3 + this.timeoffset;
        if (this.doSendOnMetaData) {
            if (this.sendOnMetadata) {
                try {
                    object = iMediaStream.getMetaDataProvider();
                    if (object != null) {
                        ArrayList arrayList = new ArrayList();
                        object.onStreamStart(arrayList, l);
                        for (AMFPacket aMFPacket2 : arrayList) {
                            byte[] byArray;
                            if (aMFPacket2 == null || aMFPacket2.getSize() <= 0 || (byArray = aMFPacket2.getData()) == null) continue;
                            if (this.isDebugLog) {
                                WMSLoggerFactory.getLogger(PublishingProviderLive.class).info("live[onMetadata]: dat:" + l2);
                            }
                            publisher.addDataData(byArray, byArray.length, l2);
                        }
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(PublishingProviderLive.class).error("PublishingProviderLive.play[metadata]: " + exception.toString());
                    exception.printStackTrace();
                }
            }
            this.doSendOnMetaData = false;
        }
        if (aMFPacket == null) {
            if (this.isDebugLog) {
                WMSLoggerFactory.getLogger(PublishingProviderLive.class).debug("live: aud:" + l2 + ":zero");
            }
            object = new byte[0];
            publisher.addAudioData((byte[])object, 0, l2);
        } else {
            switch (aMFPacket.getType()) {
                case 8: {
                    if (this.isDebugLog) {
                        WMSLoggerFactory.getLogger(PublishingProviderLive.class).debug("live: aud:" + l2 + ":" + aMFPacket.getSeq());
                    }
                    if (this.isFirstAudio) {
                        object = iMediaStream.getAudioCodecConfigPacket(aMFPacket.getAbsTimecode());
                        if (object != null) {
                            publisher.addAudioData(object.getData(), object.getSize(), l2);
                        }
                        this.isFirstAudio = false;
                    }
                    publisher.addAudioData(aMFPacket.getData(), aMFPacket.getSize(), l2);
                    break;
                }
                case 9: {
                    if (this.isDebugLog) {
                        WMSLoggerFactory.getLogger(PublishingProviderLive.class).debug("live: vi" + (FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket) ? "k" : "p") + ":" + l2 + ":" + aMFPacket.getSeq());
                    }
                    if (this.isFirstVideo) {
                        object = iMediaStream.getVideoCodecConfigPacket(aMFPacket.getAbsTimecode());
                        if (object != null) {
                            publisher.addVideoData(object.getData(), object.getSize(), l2);
                        }
                        this.isFirstVideo = false;
                    }
                    publisher.addVideoData(aMFPacket.getData(), aMFPacket.getSize(), l2);
                    break;
                }
                case 15: 
                case 18: {
                    if (this.isDebugLog) {
                        WMSLoggerFactory.getLogger(PublishingProviderLive.class).debug("live: dat:" + l2 + ":" + aMFPacket.getSeq());
                    }
                    publisher.addDataData(aMFPacket.getData(), aMFPacket.getSize(), l2);
                }
            }
        }
    }

    public boolean seek(long l) {
        return false;
    }

    public boolean seek(long l, int n) {
        return false;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public void setRealTimeStartTime(long l) {
        this.firstRealTimecode = l;
    }
}

