/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.RandomAccessFile;
import org.farng.mp3.id3.AbstractID3v2FrameBody;

public class FrameBodyASPI
extends AbstractID3v2FrameBody {
    private short[] fraction = null;
    private int bitsPerPoint = 0;
    private int dataLength = 0;
    private int dataStart = 0;
    private int indexPoints = 0;

    public FrameBodyASPI() {
    }

    public FrameBodyASPI(FrameBodyASPI frameBodyASPI) {
        super(frameBodyASPI);
        this.fraction = (short[])frameBodyASPI.fraction.clone();
        this.bitsPerPoint = frameBodyASPI.bitsPerPoint;
        this.dataLength = frameBodyASPI.dataLength;
        this.dataStart = frameBodyASPI.dataStart;
        this.indexPoints = frameBodyASPI.indexPoints;
    }

    public FrameBodyASPI(int n, int n2, int n3, int n4, short[] sArray) {
        this.dataStart = n;
        this.dataLength = n2;
        this.indexPoints = n3;
        this.bitsPerPoint = n4;
        this.fraction = new short[sArray.length];
        System.arraycopy(sArray, 0, this.fraction, 0, sArray.length);
    }

    public FrameBodyASPI(RandomAccessFile randomAccessFile) throws IOException, InvalidTagException {
        this.read(randomAccessFile);
    }

    public String getIdentifier() {
        return "ASPI";
    }

    public int getSize() {
        return 11 + this.fraction.length << 1;
    }

    public void equals() {
        throw new UnsupportedOperationException("Method equals() not yet implemented.");
    }

    protected void setupObjectList() {
    }

    public void read(RandomAccessFile randomAccessFile) throws IOException, InvalidTagException {
        int n = this.readHeader(randomAccessFile);
        if (n == 0) {
            throw new InvalidTagException("Empty Frame");
        }
        this.dataStart = randomAccessFile.readInt();
        this.dataLength = randomAccessFile.readInt();
        this.indexPoints = randomAccessFile.readShort();
        this.bitsPerPoint = randomAccessFile.readByte();
        this.fraction = new short[this.indexPoints];
        for (int i = 0; i < this.indexPoints; ++i) {
            if (this.bitsPerPoint == 8) {
                this.fraction[i] = randomAccessFile.readByte();
                continue;
            }
            if (this.bitsPerPoint == 16) {
                this.fraction[i] = randomAccessFile.readShort();
                continue;
            }
            throw new InvalidTagException("ASPI bits per point wasn't 8 or 16");
        }
    }

    public String toString() {
        return this.getIdentifier() + ' ' + this.dataStart + ' ' + this.dataLength + ' ' + this.indexPoints + ' ' + this.bitsPerPoint + ' ' + this.fraction.toString();
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        this.writeHeader(randomAccessFile, this.getSize());
        randomAccessFile.writeInt(this.dataStart);
        randomAccessFile.writeInt(this.dataLength);
        randomAccessFile.writeShort(this.indexPoints);
        randomAccessFile.writeByte(16);
        for (int i = 0; i < this.indexPoints; ++i) {
            randomAccessFile.writeShort(this.fraction[i]);
        }
    }
}

