/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.util.Iterator;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.RandomAccessFile;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.FrameBodySYLT;
import org.farng.mp3.id3.FrameBodyTALB;
import org.farng.mp3.id3.FrameBodyTCOM;
import org.farng.mp3.id3.FrameBodyTIT2;
import org.farng.mp3.id3.FrameBodyTPE1;
import org.farng.mp3.id3.FrameBodyUSLT;
import org.farng.mp3.id3.ID3v2_2Frame;
import org.farng.mp3.id3.ID3v2_3Frame;
import org.farng.mp3.lyrics3.FieldBodyAUT;
import org.farng.mp3.lyrics3.FieldBodyEAL;
import org.farng.mp3.lyrics3.FieldBodyEAR;
import org.farng.mp3.lyrics3.FieldBodyETT;
import org.farng.mp3.lyrics3.FieldBodyINF;
import org.farng.mp3.lyrics3.FieldBodyLYR;
import org.farng.mp3.lyrics3.Lyrics3v2Field;
import org.farng.mp3.object.ObjectLyrics3Line;

public class ID3v2_4Frame
extends ID3v2_3Frame {
    protected boolean dataLengthIndicator = false;
    protected boolean unsynchronization = false;

    public ID3v2_4Frame() {
    }

    public ID3v2_4Frame(ID3v2_4Frame iD3v2_4Frame) {
        super(iD3v2_4Frame);
        this.dataLengthIndicator = iD3v2_4Frame.dataLengthIndicator;
        this.unsynchronization = iD3v2_4Frame.unsynchronization;
    }

    public ID3v2_4Frame(AbstractID3v2FrameBody abstractID3v2FrameBody) {
        super(abstractID3v2FrameBody);
    }

    public ID3v2_4Frame(AbstractID3v2Frame abstractID3v2Frame) {
        ID3v2_3Frame iD3v2_3Frame;
        if (abstractID3v2Frame instanceof ID3v2_4Frame) {
            iD3v2_3Frame = (ID3v2_4Frame)abstractID3v2Frame;
            this.unsynchronization = iD3v2_3Frame.unsynchronization;
            this.dataLengthIndicator = iD3v2_3Frame.dataLengthIndicator;
        }
        if (abstractID3v2Frame instanceof ID3v2_3Frame) {
            iD3v2_3Frame = (ID3v2_3Frame)abstractID3v2Frame;
            this.tagAlterPreservation = iD3v2_3Frame.tagAlterPreservation;
            this.fileAlterPreservation = iD3v2_3Frame.fileAlterPreservation;
            this.readOnly = iD3v2_3Frame.readOnly;
            this.groupingIdentity = iD3v2_3Frame.groupingIdentity;
            this.compression = iD3v2_3Frame.compression;
            this.encryption = iD3v2_3Frame.encryption;
        }
        if (abstractID3v2Frame instanceof ID3v2_2Frame) {
            // empty if block
        }
        if (abstractID3v2Frame.getBody() != null && TagUtility.isID3v2_4FrameIdentifier(abstractID3v2Frame.getIdentifier())) {
            this.setBody((AbstractID3v2FrameBody)TagUtility.copyObject(abstractID3v2Frame.getBody()));
        }
    }

    public ID3v2_4Frame(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, AbstractID3v2FrameBody abstractID3v2FrameBody) {
        super(abstractID3v2FrameBody);
        this.readOnly = bl;
        this.groupingIdentity = bl2;
        this.compression = bl3;
        this.encryption = bl4;
        this.unsynchronization = bl5;
        this.dataLengthIndicator = bl6;
    }

    public ID3v2_4Frame(Lyrics3v2Field lyrics3v2Field) throws InvalidTagException {
        String string = lyrics3v2Field.getIdentifier();
        if (string.equals("IND")) {
            throw new InvalidTagException("Cannot create ID3v2.40 frame from Lyrics3 indications field.");
        }
        if (string.equals("LYR")) {
            FieldBodyLYR fieldBodyLYR = (FieldBodyLYR)lyrics3v2Field.getBody();
            Iterator iterator = fieldBodyLYR.iterator();
            boolean bl = fieldBodyLYR.hasTimeStamp();
            FrameBodySYLT frameBodySYLT = new FrameBodySYLT(0, "ENG", 2, 1, "");
            FrameBodyUSLT frameBodyUSLT = new FrameBodyUSLT(0, "ENG", "", "");
            while (iterator.hasNext()) {
                ObjectLyrics3Line objectLyrics3Line = (ObjectLyrics3Line)iterator.next();
                if (bl) {
                    frameBodySYLT.addLyric(objectLyrics3Line);
                    continue;
                }
                frameBodyUSLT.addLyric(objectLyrics3Line);
            }
            if (bl) {
                this.setBody(frameBodySYLT);
            } else {
                this.setBody(frameBodyUSLT);
            }
        } else if (string.equals("INF")) {
            String string2 = ((FieldBodyINF)lyrics3v2Field.getBody()).getAdditionalInformation();
            this.setBody(new FrameBodyCOMM(0, "ENG", "", string2));
        } else if (string.equals("AUT")) {
            String string3 = ((FieldBodyAUT)lyrics3v2Field.getBody()).getAuthor();
            this.setBody(new FrameBodyTCOM(0, string3));
        } else if (string.equals("EAL")) {
            String string4 = ((FieldBodyEAL)lyrics3v2Field.getBody()).getAlbum();
            this.setBody(new FrameBodyTALB(0, string4));
        } else if (string.equals("EAR")) {
            String string5 = ((FieldBodyEAR)lyrics3v2Field.getBody()).getArtist();
            this.setBody(new FrameBodyTPE1(0, string5));
        } else if (string.equals("ETT")) {
            String string6 = ((FieldBodyETT)lyrics3v2Field.getBody()).getTitle();
            this.setBody(new FrameBodyTIT2(0, string6));
        } else {
            if (string.equals("IMG")) {
                throw new InvalidTagException("Cannot create ID3v2.40 frame from Lyrics3 image field.");
            }
            throw new InvalidTagException("Cannot caret ID3v2.40 frame from " + string + " Lyrics3 field");
        }
    }

    public ID3v2_4Frame(RandomAccessFile randomAccessFile) throws IOException, InvalidTagException {
        this.read(randomAccessFile);
    }

    public int getSize() {
        return this.getBody().getSize() + 4 + 2 + 4;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ID3v2_4Frame)) {
            return false;
        }
        ID3v2_4Frame iD3v2_4Frame = (ID3v2_4Frame)object;
        if (this.unsynchronization != iD3v2_4Frame.unsynchronization) {
            return false;
        }
        if (this.dataLengthIndicator != iD3v2_4Frame.dataLengthIndicator) {
            return false;
        }
        return super.equals(object);
    }

    public void read(RandomAccessFile randomAccessFile) throws IOException, InvalidTagException {
        long l;
        byte by;
        byte[] byArray = new byte[4];
        do {
            l = randomAccessFile.getFilePointer();
            by = randomAccessFile.readByte();
            AbstractID3v2.incrementPaddingCounter();
        } while (by == 0);
        randomAccessFile.seek(l);
        AbstractID3v2.decrementPaddingCounter();
        randomAccessFile.read(byArray, 0, 4);
        String string = new String(byArray, 0, 4);
        if (!ID3v2_4Frame.isValidID3v2FrameIdentifier(string)) {
            randomAccessFile.seek(randomAccessFile.getFilePointer() - 3L);
            throw new InvalidTagException(string + " is not a valid ID3v2.40 frame");
        }
        l = randomAccessFile.getFilePointer();
        randomAccessFile.skipBytes(4);
        randomAccessFile.read(byArray, 0, 2);
        this.tagAlterPreservation = (byArray[0] & 0x40) != 0;
        this.fileAlterPreservation = (byArray[0] & 0x20) != 0;
        this.readOnly = (byArray[0] & 0x10) != 0;
        this.groupingIdentity = (byArray[1] & 0x40) != 0;
        this.compression = (byArray[1] & 0x10) != 0;
        this.encryption = (byArray[1] & 8) != 0;
        this.unsynchronization = (byArray[1] & 4) != 0;
        this.dataLengthIndicator = (byArray[1] & 2) != 0;
        randomAccessFile.seek(l);
        this.setBody(ID3v2_4Frame.readBody(string, randomAccessFile));
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[4];
        String string = TagUtility.truncate(this.getIdentifier(), 4);
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        randomAccessFile.write(byArray, 0, string.length());
        long l = randomAccessFile.getFilePointer();
        randomAccessFile.skipBytes(4);
        this.setAlterPreservation();
        byArray[0] = 0;
        byArray[1] = 0;
        if (this.tagAlterPreservation) {
            byArray[0] = (byte)(byArray[0] | 0x40);
        }
        if (this.fileAlterPreservation) {
            byArray[0] = (byte)(byArray[0] | 0x20);
        }
        if (this.readOnly) {
            byArray[0] = (byte)(byArray[0] | 0x10);
        }
        if (this.groupingIdentity) {
            byArray[1] = (byte)(byArray[1] | 0x40);
        }
        if (this.compression) {
            byArray[1] = (byte)(byArray[1] | 0x10);
        }
        if (this.encryption) {
            byArray[1] = (byte)(byArray[1] | 8);
        }
        if (this.unsynchronization) {
            byArray[1] = (byte)(byArray[1] | 4);
        }
        if (this.dataLengthIndicator) {
            byArray[1] = (byte)(byArray[1] | 2);
        }
        randomAccessFile.write(byArray, 0, 2);
        randomAccessFile.seek(l);
        this.getBody().write(randomAccessFile);
    }
}

