/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.lyrics3;

import java.io.IOException;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.RandomAccessFile;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.ID3v1;
import org.farng.mp3.lyrics3.AbstractLyrics3;
import org.farng.mp3.lyrics3.FieldBodyLYR;
import org.farng.mp3.lyrics3.Lyrics3v2;

public class Lyrics3v1
extends AbstractLyrics3 {
    private String lyric = "";

    public Lyrics3v1() {
    }

    public Lyrics3v1(Lyrics3v1 lyrics3v1) {
        super(lyrics3v1);
        this.lyric = new String(lyrics3v1.lyric);
    }

    public Lyrics3v1(AbstractMP3Tag abstractMP3Tag) {
        if (abstractMP3Tag != null) {
            if (abstractMP3Tag instanceof Lyrics3v1) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            Lyrics3v2 lyrics3v2 = abstractMP3Tag instanceof Lyrics3v2 ? (Lyrics3v2)abstractMP3Tag : new Lyrics3v2(abstractMP3Tag);
            FieldBodyLYR fieldBodyLYR = (FieldBodyLYR)lyrics3v2.getField("LYR").getBody();
            this.lyric = new String(fieldBodyLYR.getLyric().trim());
        }
    }

    public Lyrics3v1(RandomAccessFile randomAccessFile) throws TagNotFoundException, IOException {
        this.read(randomAccessFile);
    }

    public String getIdentifier() {
        return "Lyrics3v1.00";
    }

    public void setLyric(String string) {
        this.lyric = TagUtility.truncate(string, 5100);
    }

    public String getLyric() {
        return this.lyric;
    }

    public int getSize() {
        return "LYRICSBEGIN".length() + this.lyric.length() + "LYRICSEND".length();
    }

    public boolean isSubsetOf(Object object) {
        if (!(object instanceof Lyrics3v1)) {
            return false;
        }
        return ((Lyrics3v1)object).lyric.indexOf(this.lyric) >= 0;
    }

    public void append(AbstractMP3Tag abstractMP3Tag) {
        Lyrics3v1 lyrics3v1 = this;
        if (abstractMP3Tag != null) {
            Lyrics3v1 lyrics3v12 = abstractMP3Tag instanceof Lyrics3v1 ? (Lyrics3v1)abstractMP3Tag : new Lyrics3v1();
            this.lyric = lyrics3v1.lyric + "\n" + lyrics3v12.lyric;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Lyrics3v1)) {
            return false;
        }
        Lyrics3v1 lyrics3v1 = (Lyrics3v1)object;
        if (!this.lyric.equals(lyrics3v1.lyric)) {
            return false;
        }
        return super.equals(object);
    }

    public Iterator iterator() {
        throw new UnsupportedOperationException("Method iterator() not yet implemented.");
    }

    public void overwrite(AbstractMP3Tag abstractMP3Tag) {
        Lyrics3v1 lyrics3v1 = this;
        if (abstractMP3Tag != null) {
            Lyrics3v1 lyrics3v12 = abstractMP3Tag instanceof Lyrics3v1 ? (Lyrics3v1)abstractMP3Tag : new Lyrics3v1();
            this.lyric = TagOptionSingleton.getInstance().isLyrics3Save() ? lyrics3v12.lyric : lyrics3v1.lyric;
        }
    }

    public void read(RandomAccessFile randomAccessFile) throws TagNotFoundException, IOException {
        byte[] byArray = new byte[5120];
        if (!this.seek(randomAccessFile)) {
            throw new TagNotFoundException("ID3v1 tag not found");
        }
        randomAccessFile.read(byArray);
        String string = new String(byArray);
        this.lyric = string.substring(0, string.indexOf("LYRICSEND"));
    }

    public boolean seek(RandomAccessFile randomAccessFile) throws IOException {
        long l;
        byte[] byArray = new byte[5120];
        randomAccessFile.seek(randomAccessFile.length() - 128L - 9L);
        randomAccessFile.read(byArray, 0, 9);
        String string = new String(byArray, 0, 9);
        if (string.equals("LYRICSEND")) {
            l = randomAccessFile.getFilePointer();
        } else {
            randomAccessFile.seek(randomAccessFile.length() - 9L);
            randomAccessFile.read(byArray, 0, 9);
            string = new String(byArray, 0, 9);
            if (string.equals("LYRICSEND")) {
                l = randomAccessFile.getFilePointer();
            } else {
                return false;
            }
        }
        randomAccessFile.seek(l -= 5120L);
        randomAccessFile.read(byArray);
        String string2 = new String(byArray);
        int n = string2.indexOf("LYRICSBEGIN");
        if (n == -1) {
            return false;
        }
        randomAccessFile.seek(l + (long)n + 11L);
        return true;
    }

    public String toString() {
        String string = this.getIdentifier() + " " + this.getSize() + "\n";
        return string + this.lyric;
    }

    public void write(AbstractMP3Tag abstractMP3Tag) {
        if (abstractMP3Tag != null) {
            Lyrics3v1 lyrics3v1 = abstractMP3Tag instanceof Lyrics3v1 ? (Lyrics3v1)abstractMP3Tag : new Lyrics3v1();
            this.lyric = lyrics3v1.lyric;
        }
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        ID3v1 iD3v1 = new ID3v1().getID3tag(randomAccessFile);
        this.delete(randomAccessFile);
        randomAccessFile.seek(randomAccessFile.length());
        byte[] byArray = new byte[this.lyric.length() + 11 + 9];
        String string = "LYRICSBEGIN";
        for (n = 0; n < string.length(); ++n) {
            byArray[n] = (byte)string.charAt(n);
        }
        int n2 = string.length();
        string = TagUtility.truncate(this.lyric, 5100);
        for (n = 0; n < string.length(); ++n) {
            byArray[n + n2] = (byte)string.charAt(n);
        }
        n2 += string.length();
        string = "LYRICSEND";
        for (n = 0; n < string.length(); ++n) {
            byArray[n + n2] = (byte)string.charAt(n);
        }
        randomAccessFile.write(byArray, 0, n2 += string.length());
        if (iD3v1 != null) {
            iD3v1.write(randomAccessFile);
        }
    }

    public String getSongTitle() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getLeadArtist() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getAlbumTitle() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getYearReleased() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getSongComment() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getSongGenre() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getTrackNumberOnAlbum() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getSongLyric() {
        return this.getLyric().trim();
    }

    public String getAuthorComposer() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setSongTitle(String string) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setLeadArtist(String string) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setAlbumTitle(String string) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setYearReleased(String string) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setSongComment(String string) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setSongGenre(String string) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setTrackNumberOnAlbum(String string) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setSongLyric(String string) {
        this.setLyric(string.trim());
    }

    public void setAuthorComposer(String string) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }
}

