/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264.hint;

import com.wowza.util.DebugUtils;
import com.wowza.wms.mediareader.h264.atom.QTMediaCursor;
import java.io.RandomAccessFile;

public class QTHintDataEntry {
    public byte dataSource = 0;
    public int dataSize = 0;
    public byte[] data = new byte[14];
    public byte trackRefIndex = 0;
    public int length = 0;
    public int sampleNumber = 0;
    public int offset = 0;
    public int bytesPerCompressionBlock = 0;
    public int samplesPerCompressionBlock = 0;
    public int sampleDescriptionIndex = 0;
    public int reserved = 0;

    public int getPacketSize() {
        switch (this.dataSource) {
            case 1: {
                return this.dataSize;
            }
            case 2: {
                return this.length;
            }
            case 3: {
                return this.length;
            }
        }
        return 0;
    }

    public int getDataSize() {
        switch (this.dataSource) {
            case 2: {
                return this.length;
            }
            case 3: {
                return this.length;
            }
        }
        return 0;
    }

    public int getPacketOffset() {
        switch (this.dataSource) {
            case 2: {
                return this.offset;
            }
            case 3: {
                return this.offset;
            }
        }
        return 0;
    }

    public int fillPacket(byte[] byArray, byte[] byArray2, int n, RandomAccessFile randomAccessFile, QTMediaCursor qTMediaCursor) throws Exception {
        int n2 = 0;
        switch (this.dataSource) {
            case 0: {
                break;
            }
            case 1: {
                System.arraycopy(this.data, 0, byArray, n, this.dataSize);
                n2 += this.dataSize;
                break;
            }
            case 2: {
                try {
                    if (this.trackRefIndex < 0) {
                        System.arraycopy(byArray2, this.offset, byArray, n, this.length);
                    } else {
                        boolean bl = qTMediaCursor.moveToSample(this.sampleNumber);
                        randomAccessFile.seek(qTMediaCursor.getFileLoc() + (long)this.offset);
                        int n3 = (int)qTMediaCursor.getSize();
                        if (!bl) {
                            throw new Exception("Error: QTHintDataEntry.fillPacket: invalid move");
                        }
                        if (this.length > n3) {
                            throw new Exception("Error: QTHintDataEntry.fillPacket: size problem: " + this.length + ":" + n3);
                        }
                        randomAccessFile.read(byArray, n, this.length);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Error: QTHintDataEntry.fillPacket: File read error: " + exception.toString());
                }
                n2 += this.length;
                break;
            }
            case 3: {
                throw new Exception("Error: QTHintDataEntry.fillPacket: sample description mode not implemented");
            }
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    dataSource: " + this.dataSource + "\n");
        switch (this.dataSource) {
            case 0: {
                break;
            }
            case 1: {
                stringBuffer.append("    dataSize: " + this.dataSize + "\n");
                stringBuffer.append("    data: " + DebugUtils.formatBytesShort((byte[])this.data) + "\n");
                break;
            }
            case 2: {
                stringBuffer.append("    trackRefIndex: " + this.trackRefIndex + "\n");
                stringBuffer.append("    length: " + this.length + "\n");
                stringBuffer.append("    sampleNumber: " + this.sampleNumber + "\n");
                stringBuffer.append("    offset: " + this.offset + "\n");
                stringBuffer.append("    bytesPerCompressionBlock: " + this.bytesPerCompressionBlock + "\n");
                stringBuffer.append("    samplesPerCompressionBlock: " + this.samplesPerCompressionBlock + "\n");
                break;
            }
            case 3: {
                stringBuffer.append("    trackRefIndex: " + this.trackRefIndex + "\n");
                stringBuffer.append("    length: " + this.length + "\n");
                stringBuffer.append("    sampleDescriptionIndex: " + this.sampleDescriptionIndex + "\n");
                stringBuffer.append("    offset: " + this.offset + "\n");
                stringBuffer.append("    reserved: " + this.reserved + "\n");
            }
        }
        return stringBuffer.toString();
    }
}

