/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.streamnamealias;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.streamnamealias.StreamNameAliasFiles;
import com.wowza.wms.plugin.streamnamealias.StreamNameAliasMatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StreamNameAliasFile {
    private long lastModDate = -1L;
    private long lastSize = -1L;
    private File file = null;
    private List<StreamAlias> aliasVals = new ArrayList<StreamAlias>();
    private Map<String, StreamAlias> aliasMap = new HashMap<String, StreamAlias>();
    private boolean aliasMapAllNonWild = true;
    private boolean aliasMapLastMatchAll = false;
    private long lastReloadChecktime = -1L;

    public StreamNameAliasFile(File file) {
        this.file = file;
        this.load();
    }

    private void load() {
        WMSLoggerFactory.getLogger(StreamNameAliasFile.class).debug("StreamNameAliasFile.load: " + this.file.getAbsolutePath());
        this.aliasVals.clear();
        this.aliasMap.clear();
        this.aliasMapAllNonWild = true;
        this.aliasMapLastMatchAll = false;
        String delimter = StreamNameAliasFiles.getNameDelimeter();
        BufferedReader inf = null;
        try {
            String line;
            inf = new BufferedReader(new FileReader(this.file));
            int wildCount = 0;
            while ((line = inf.readLine()) != null) {
                boolean isWild;
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                String pattern = null;
                String alias = null;
                int pos = line.indexOf(delimter);
                if (pos >= 0) {
                    pattern = line.substring(0, pos).trim();
                    alias = line.substring(pos + 1).trim();
                }
                if (pattern == null || alias == null) continue;
                StreamAlias streamAlias = new StreamAlias(pattern, alias);
                this.aliasVals.add(streamAlias);
                boolean bl = isWild = pattern.indexOf("*") >= 0;
                if (!isWild) {
                    this.aliasMap.put(pattern, streamAlias);
                    continue;
                }
                ++wildCount;
            }
            if (this.aliasVals.size() > 0) {
                StreamAlias streamAlias = this.aliasVals.get(this.aliasVals.size() - 1);
                if (streamAlias.pattern.equals("*")) {
                    this.aliasMapLastMatchAll = true;
                    --wildCount;
                }
            }
            if (wildCount > 0) {
                this.aliasMap.clear();
                this.aliasMapAllNonWild = false;
            }
            WMSLoggerFactory.getLogger(StreamNameAliasFile.class).info("StreamNameAliasFile.load[" + this.file.getAbsolutePath() + "]: size:" + this.aliasMap.size() + ":" + this.aliasVals.size() + " hash:" + this.aliasMapAllNonWild + " matchAll:" + this.aliasMapLastMatchAll);
        }
        catch (Exception e) {
            WMSLoggerFactory.getLogger(StreamNameAliasFile.class).error("StreamNameAliasFile.load: " + e.toString());
        }
        try {
            if (inf != null) {
                inf.close();
            }
            inf = null;
        }
        catch (Exception e) {
            WMSLoggerFactory.getLogger(StreamNameAliasFile.class).error("StreamNameAliasFile.load[close]: " + e.toString());
        }
        this.lastModDate = this.file.lastModified();
        this.lastSize = this.file.length();
    }

    private void checkReload() {
        if (this.needReload()) {
            this.load();
        }
    }

    public boolean needReload() {
        long currTime = System.currentTimeMillis();
        if (this.lastReloadChecktime < 0L || currTime - this.lastReloadChecktime > 2000L) {
            this.lastReloadChecktime = currTime;
            return this.lastModDate != this.file.lastModified() || this.lastSize != this.file.length();
        }
        return false;
    }

    private StreamNameAliasMatch patternMatch(String streamName, StreamAlias streamAlias) {
        StreamNameAliasMatch ret = null;
        String pattern = streamAlias.pattern;
        if (pattern.equals("*")) {
            ret = new StreamNameAliasMatch();
            ret.pattern = streamAlias.pattern;
            ret.alias = streamAlias.alias;
            ret.wildcardMatches = new ArrayList<String>();
            ret.wildcardMatches.add(streamName);
        } else {
            String regPattern = pattern;
            regPattern = regPattern.replace(".", "\\.");
            regPattern = regPattern.replace("*", "(.*)");
            Pattern p = Pattern.compile(regPattern = "^" + regPattern + "$");
            Matcher m = p.matcher(streamName);
            if (m.find()) {
                boolean isMatch;
                boolean bl = isMatch = m.start() == 0 && m.end() == streamName.length();
                if (isMatch) {
                    ret = new StreamNameAliasMatch();
                    ret.pattern = streamAlias.pattern;
                    ret.alias = streamAlias.alias;
                    if (m.groupCount() > 0) {
                        ret.wildcardMatches = new ArrayList<String>();
                        int i = 0;
                        while (i < m.groupCount()) {
                            ret.wildcardMatches.add(m.group(i + 1));
                            ++i;
                        }
                    }
                }
            }
        }
        return ret;
    }

    public synchronized StreamNameAliasMatch findMap(String streamName) {
        StreamNameAliasMatch ret;
        block4: {
            block2: {
                block3: {
                    this.checkReload();
                    ret = null;
                    if (!this.aliasMapAllNonWild) break block2;
                    StreamAlias streamAlias = this.aliasMap.get(streamName.trim());
                    if (streamAlias == null) break block3;
                    ret = new StreamNameAliasMatch();
                    ret.pattern = streamAlias.pattern;
                    ret.alias = streamAlias.alias;
                    break block4;
                }
                if (!this.aliasMapLastMatchAll) break block4;
                ret = this.patternMatch(streamName, this.aliasVals.get(this.aliasVals.size() - 1));
                break block4;
            }
            for (StreamAlias streamAlias : this.aliasVals) {
                String pattern = streamAlias.pattern;
                if (pattern.indexOf("*") >= 0) {
                    ret = this.patternMatch(streamName, streamAlias);
                    if (ret == null) continue;
                    break;
                }
                if (!pattern.equals(streamName)) continue;
                ret = new StreamNameAliasMatch();
                ret.pattern = streamAlias.pattern;
                ret.alias = streamAlias.alias;
                break;
            }
        }
        return ret;
    }

    class StreamAlias {
        String pattern = null;
        String alias = null;

        public StreamAlias(String pattern, String alias) {
            this.pattern = pattern;
            this.alias = alias;
        }

        public String toString() {
            return "{pattern: \"" + this.pattern + "\" alias: \"" + this.alias + "\"}";
        }
    }
}

