<?php
ini_set("date.timezone","America/Sao_Paulo");
session_set_cookie_params(0);
session_start();

header("Content-Type: text/html;  charset=ISO-8859-1",true);
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Origin, Content-Type, Accept, Authorization, X-Request-With');
header('Access-Control-Allow-Credentials: true');

// Incluso de classes
require_once("inc/conecta.php");
require_once("inc/funcoes.php");
require_once("inc/classe.ssh.php");
require_once("inc/classe.ftp.php");

$dados_config = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM configuracoes"));

if($_SESSION["code_user_logged"] && $_SESSION["type_logged_user"] == "cliente") {

$dados_revenda = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo = '".$_SESSION["code_user_logged"]."'"));

$revenda_code = code_decode($dados_revenda["codigo"],"E");

// Valida se servio est ativo ou bloqueado
if($dados_revenda["status"] != 1) {
$_SESSION["status_login"] = '<div class="alert alert-danger" role="alert">Servio bloqueado! Contate nosso atendimento.</div>';

unset($_SESSION["type_logged_user"]);
unset($_SESSION["code_user_logged"]);
header("Location: /admin/login");
exit;
}
}

//////////////////////////////////////////////////////////////////
//////////////////////// SQL atualizacoes ////////////////////////
//////////////////////////////////////////////////////////////////

if($_SESSION["code_user_logged"]) {

if (file_exists("atualizar.php")) {
require_once("atualizar.php");
@unlink("atualizar.php");
}

}

//////////////////////////////////////////////////////////////////
////// Verificar se dominio tem SSL e redireciona para https /////
//////////////////////////////////////////////////////////////////

function verifica_SSL($domain){$get=@stream_context_create(array("ssl"=>array("capture_peer_cert"=>TRUE)));$read=@stream_socket_client("ssl://".$domain.":443",$errno,$errstr,30,STREAM_CLIENT_CONNECT,$get);$cert=@stream_context_get_params($read);$certinfo=@openssl_x509_parse($cert['options']['ssl']['peer_certificate']);if(is_null($certinfo)||empty($certinfo)){return false;}else{return true;}}

if($_SERVER["SERVER_PORT"] == "80") {
	if(verifica_SSL($_SERVER['HTTP_HOST'])) {
		header("Location: https://" . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"]);
		exit();
	}
}

//////////////////////////////////////////////////////////////////
//////////////////////// Idioma do Painel ////////////////////////
//////////////////////////////////////////////////////////////////

if($_SESSION["code_user_logged"] && $_SESSION["type_logged_user"] == "cliente") {

if(file_exists("inc/lang-".$dados_revenda["idioma_painel"].".php")) {
require_once("inc/lang-".$dados_revenda["idioma_painel"].".php");
} else {
require_once("inc/lang-pt-br.php");
}

if($dados_revenda["idioma_painel"] == "pt-br") {
$lang_sortable = "Portuguese-Brasil";
} elseif($dados_revenda["idioma_painel"] == "en-us") {
$lang_sortable = "English";
} else {
$lang_sortable = "Spanish";
}

}

if($_SESSION["code_user_logged"] && $_SESSION["type_logged_user"] == "operador") {

if(file_exists("inc/lang-admin-".$dados_config["idioma_painel"].".php")) {
require_once("inc/lang-admin-".$dados_config["idioma_painel"].".php");
} else {
require_once("inc/lang-admin-pt-br.php");
}

$lang_sortable = "Portuguese-Brasil";

}

// Verifica se painel esta com manuteno ativada e ento exibe a pgina de manuteno
if($dados_config["manutencao"] == "sim" && $_SESSION["type_logged_user"] == "cliente") {

require("manutencao.php");

exit();

}

//////////////////////////////////////////////////////////////////
//////////////////////////// Navegao ///////////////////////////
//////////////////////////////////////////////////////////////////

$pagina = query_string('1');

if($pagina == "sair") {

$pagina = "login";

unset($_SESSION["type_logged_user"]);
unset($_SESSION["code_user_logged"]);
}

if ($pagina == "") {
header("Location: /admin/login");
} elseif (!file_exists($pagina.".php")) {

if($_SESSION["type_logged_user"] == "cliente") {
require("revenda-manutencao.php");
} elseif($_SESSION["type_logged_user"] == "operador") {
require("admin-manutencao.php");
} else {
require("manutencao.php");
}

} else {
require("".$pagina.".php");
}
?>
