<?php
require_once("inc/protecao-revenda.php");

// Estatísticas de uso do plano
$total_streamings_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."' AND status = '1'"));
$total_streamings_bloqueados = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."' AND status != '1'"));

$total_subrevendas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));
$total_subrevendas_subrevendas = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(subrevendas) as total FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));
$total_streamings = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."'"));
$ouvintes = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(ouvintes) as total FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."'"));
$ouvintes_subrevendas = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(ouvintes) as total FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));
$espaco_subrevendas = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(espaco) as total FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));
$espaco_streamings = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(espaco) as total FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."'"));

$porcentagem_uso_subrevendas = ($dados_revenda["subrevendas"] == 0 || $dados_revenda["subrevendas"] > 999998) ? "0" : ($total_subrevendas+$total_subrevendas_subrevendas["total"])*100/$dados_revenda["subrevendas"];
$porcentagem_uso_streamings = ($dados_revenda["streamings"] == 0 || $dados_revenda["streamings"] > 999998) ? "0" : $total_streamings*100/$dados_revenda["streamings"];
$porcentagem_uso_ouvintes = ($dados_revenda["ouvintes"] == 0 || $dados_revenda["ouvintes"] > 999998) ? "0" : ($ouvintes["total"]+$ouvintes_subrevendas["total"])*100/$dados_revenda["ouvintes"];
$porcentagem_uso_espaco_ftp = ($dados_revenda["espaco"] == 0 || $dados_revenda["espaco"] > 999998) ? "0" : ($espaco_subrevendas["total"]+$espaco_streamings["total"])*100/$dados_revenda["espaco"];

$limite_subrevendas = ($dados_revenda["subrevendas"] == 999999) ? '<small>'.lang_info_ilimitado.'</small>' : $dados_revenda["subrevendas"];
$limite_streamings = ($dados_revenda["streamings"] == 999999) ? '<small>'.lang_info_ilimitado.'</small>' : $dados_revenda["streamings"];
$limite_ouvintes = ($dados_revenda["ouvintes"] == 999999) ? '<small>'.lang_info_ilimitado.'</small>' : $dados_revenda["ouvintes"];
$limite_espaco_ftp = tamanho($dados_revenda["espaco"]);

$uso_limite_subrevendas = $total_subrevendas+$total_subrevendas_subrevendas["total"];
$uso_limite_streamings = $total_streamings;
$uso_limite_ouvintes = $ouvintes["total"]+$ouvintes_subrevendas["total"];
$uso_limite_espaco_ftp = tamanho(($espaco_subrevendas["total"]+$espaco_streamings["total"]));

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Revenda <?php echo $dados_revenda["id"]; ?></title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">
  <link rel="stylesheet" href="/inc/theme.css">
  <link rel="shortcut icon" href="/img/favicon.ico">
  <script type="text/javascript" src="/admin/inc/ajax-revenda.js"></script>
  <script type="text/javascript" src="/admin/inc/javascript.js"></script>
</head>

<body>
  <div class="container-scroller">
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <?php if($dados_revenda["url_logo"]) { ?>
        <a class="navbar-brand brand-logo" href="/admin/revenda-configuracoes"><img id="logo" src="<?php echo $dados_revenda["url_logo"]; ?>" title="Painel" height="60" border="0"></a>
        <?php } else { ?>
        <a class="navbar-brand brand-logo" href="/admin/revenda-configuracoes"><span>Painel Revenda</span></a>
        <?php } ?>
        <a class="navbar-brand brand-logo-mini" href="/admin/revenda-configuracoes"><img src="/img/icones/img-icone-logo.png" title="Painel" width="32" height="32" border="0"></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <li class="nav-item nav-search d-none d-lg-block">
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text" id="search">
                  <i class="mdi mdi-magnify"></i>
                </span>
              </div>
              <input type="text" class="form-control" id="busca_chave" placeholder="Busca" aria-label="search" aria-describedby="search">
            </div>
          </li>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item dropdown">
            <a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown" aria-expanded="false">
              <i class="mdi mdi-bell f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?>"></i>
              <?php if($total_avisos_exibir > 0) { ?><span class="count bg-success"><?php echo $total_avisos_exibir; ?></span><?php } ?>           
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
              <a class="dropdown-item">
                <p class="mb-0 font-weight-normal float-left"><?php echo lang_info_pagina_informacoes_revenda_tab_avisos; ?></p>
              </a>
              <div class="dropdown-divider"></div>
              <?php carregar_avisos_revenda($conexao); ?>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>

    <!-- modal -->
      <div class="modal fade" id="avisos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" id="avisos-conteudo"><img src="/img/ajax-loader.gif" align="center" /></div>
            </div>
        </div>
      </div>
                
      <div class="modal fade" id="playlists-autodj" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">AutoDJ</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body text-center" id="playlists-autodj-conteudo" style="text-align: center;"><img src="/img/ajax-loader.gif" /></div>
            </div>
          </div>
      </div>
                
      <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
      
    <div class="container-fluid page-body-wrapper">      
    <?php require_once("menu-revenda.php"); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-12">
              <div class="row">
                <?php if($dados_revenda["subrevendas"] > 0) { ?>
                <div class="col-sm-6 col-md-3">
                  <div class="card">
                    <div class="card-body">
                      <h4 class="card-title"><?php echo lang_info_pagina_informacoes_revenda_tab_plano_subrevendas; ?></h4>                      
                      <div class="d-flex justify-content-between">
                        <p class="text-muted"><i class="fa fa-users f-32"></i></p>
                        <p class="text-muted" id="total_ouvintes"><?php echo $uso_limite_subrevendas; ?> / <?php echo $limite_subrevendas; ?></p>
                      </div>
                      <div class="progress progress-md">
                        <div class="progress-bar bg-success" role="progressbar" aria-valuenow="<?php echo $porcentagem_uso_subrevendas; ?>" aria-valuemin="0" aria-valuemax="100" id="porcentagem_uso_subrevendas" style="width: <?php echo $porcentagem_uso_subrevendas; ?>%;"></div>
                      </div>
                    </div>
                  </div>
                </div>
                <?php } ?>
                <div class="<?php if($dados_revenda["subrevendas"] > 0) { echo "col-sm-6 col-md-3"; } else { echo "col-sm-6 col-md-4"; } ?>">
                  <div class="card">
                    <div class="card-body">
                      <h4 class="card-title"><?php echo lang_info_pagina_informacoes_revenda_tab_plano_streamings; ?></h4>                      
                      <div class="d-flex justify-content-between">
                        <p class="text-muted"><i class="fa fa-headphones f-32"></i></p>
                        <p class="text-muted" id="total_ouvintes"><?php echo $uso_limite_streamings; ?> / <?php echo $limite_streamings; ?></p>
                      </div>
                      <div class="progress progress-md">
                        <div class="progress-bar bg-success" role="progressbar" aria-valuenow="<?php echo $porcentagem_uso_streamings; ?>" aria-valuemin="0" aria-valuemax="100" id="porcentagem_uso_streamings" style="width: <?php echo $porcentagem_uso_streamings; ?>%;"></div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="<?php if($dados_revenda["subrevendas"] > 0) { echo "col-sm-6 col-md-3"; } else { echo "col-sm-6 col-md-4"; } ?>">
                  <div class="card">
                    <div class="card-body">
                      <h4 class="card-title"><?php echo lang_info_pagina_informacoes_revenda_tab_plano_ouvintes; ?></h4>                      
                      <div class="d-flex justify-content-between">
                        <p class="text-muted"><i class="fa fa-user f-32"></i></p>
                        <p class="text-muted"><?php echo $uso_limite_ouvintes; ?> / <?php echo $limite_ouvintes; ?></p>
                      </div>
                      <div class="progress progress-md">
                        <div class="progress-bar bg-danger" role="progressbar" aria-valuenow="<?php echo $porcentagem_uso_ouvintes; ?>" aria-valuemin="0" aria-valuemax="100" id="porcentagem_uso_ouvintes" style="width: <?php echo $porcentagem_uso_ouvintes; ?>%;"></div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="<?php if($dados_revenda["subrevendas"] > 0) { echo "col-sm-6 col-md-3"; } else { echo "col-sm-6 col-md-4"; } ?>">
                  <div class="card">
                    <div class="card-body">
                      <h4 class="card-title"><?php echo lang_info_pagina_informacoes_revenda_tab_plano_ftp; ?></h4>
                      <div class="d-flex justify-content-between">
                        <p class="text-muted"><i class="fa fa-hdd-o f-32"></i></p>
                        <p class="text-muted"><?php echo $uso_limite_espaco_ftp; ?> / <?php echo $limite_espaco_ftp; ?></p>
                      </div>
                      <div class="progress progress-md">
                        <div class="progress-bar bg-danger" role="progressbar" aria-valuenow="<?php echo $porcentagem_uso_espaco_ftp; ?>" aria-valuemin="0" aria-valuemax="100" id="porcentagem_uso_espaco_ftp" style="width: <?php echo $porcentagem_uso_espaco_ftp; ?>%;"></div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>          

            <?php if($dados_revenda["subrevendas"] > 0) { ?>
            <div class="col-lg-6">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_acao_pagina_revenda_titulo_ultimas_subrevendas; ?></header>
                  </div>
                <div class="card-body">
                    <table class="table dataTable no-footer table-hover">
                                                <thead>
                                                    <tr role="row">
                                                        <th><?php echo lang_acao_pagina_revenda_titulo_ultimas_subrevendas_id; ?></th>
                                                        <th><?php echo lang_acao_pagina_revenda_titulo_ultimas_subrevendas_email; ?></th>
                                                        <th><?php echo lang_acao_pagina_revenda_titulo_ultimas_subrevendas_plano; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$total_subrevendas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));

if($total_subrevendas > 0) {

$sql_subrevenda = mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."' ORDER by codigo DESC LIMIT 5");
while ($dados_subrevenda = mysqli_fetch_array($sql_subrevenda)) {

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;".$dados_subrevenda["id"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_subrevenda["email"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_subrevenda["streamings"]." streamings | ".$dados_subrevenda["ouvintes"]." ".lang_info_pagina_busca_avancada_resultado_ouvintes." | ".$dados_subrevenda["bitrate"]." Kbps | ".tamanho($dados_subrevenda["espaco"])."</td>
</tr>";
}

} else {

echo "<tr>
    <td height='23' colspan='3' align='center' class='texto_padrao'>".lang_info_sem_registros."</td>
  </tr>";

}

?>
                                                </tbody>
                                            </table>
                </div>
              </div>
            </div>
            <?php } ?>
            <div class="<?php if($dados_revenda["subrevendas"] > 0) { echo "col-lg-6"; } else { echo "col-lg-12"; } ?>">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_acao_pagina_revenda_titulo_ultimos_streamings; ?></header>
                  </div>
                <div class="card-body">
                    <table class="table dataTable no-footer table-hover">
                                                <thead>
                                                    <tr role="row">
                                                        <th><?php echo lang_acao_pagina_revenda_titulo_ultimos_streamings_porta; ?></th>
                                                        <th><?php echo lang_acao_pagina_revenda_titulo_ultimos_streamings_servidor; ?></th>
                                                        <th><?php echo lang_acao_pagina_revenda_titulo_ultimos_streamings_plano; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$total_streamings = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."'"));

if($total_streamings > 0) {

$sql_stm = mysqli_query($conexao,"SELECT * FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."' ORDER by codigo DESC LIMIT 5");
while ($dados_stm = mysqli_fetch_array($sql_stm)) {

$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

$servidor = ($dados_revenda["dominio_padrao"]) ? strtolower($dados_servidor["nome"]).".".$dados_revenda["dominio_padrao"] : strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"];

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;".$dados_stm["porta"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$servidor."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_stm["ouvintes"]." ".lang_info_subrevenda_streamings_ouvintes." | ".$dados_stm["bitrate"]." Kbps | ".tamanho($dados_stm["espaco"])."</td>
</tr>";
}

} else {

echo "<tr>
    <td height='23' colspan='3' align='center' class='texto_padrao'>".lang_info_sem_registros."</td>
  </tr>";

}

?>
                                                </tbody>
                                            </table>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>      

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  $('#busca_chave').keypress(function (e) {
    if (e.which == 13) {
       window.location = "/admin/revenda-streamings/resultado/porta/"+document.getElementById("busca_chave").value;
    }
  }); 
  </script>
</body>
</html>