<?php
// Proteo contra acesso direto
if(empty($_SERVER['HTTP_REFERER'])) {
die("0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!");
}

require_once("../admin/inc/conecta.php");
require_once("wideimage/WideImage.php");

// Funces
// Funo para formatar o nome da radio retirando acentos e caracteres especiais
function formatar_nome_radio($nome) {

$characteres = array(
    'S'=>'S', 's'=>'s', ''=>'Dj','Z'=>'Z', 'z'=>'z', ''=>'A', ''=>'A', ''=>'A', ''=>'A', ''=>'A',
    ''=>'A', ''=>'A', ''=>'C', ''=>'E', ''=>'E', ''=>'E', ''=>'E', ''=>'I', ''=>'I', ''=>'I',
    ''=>'I', ''=>'N', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'U', ''=>'U',
    ''=>'U', ''=>'U', ''=>'Y', ''=>'B', ''=>'Ss',''=>'a', ''=>'a', ''=>'a', ''=>'a', ''=>'a',
    ''=>'a', ''=>'a', ''=>'c', ''=>'e', ''=>'e', ''=>'e', ''=>'e', ''=>'i', ''=>'i', ''=>'i',
    ''=>'i', ''=>'o', ''=>'n', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'u',
    ''=>'u', ''=>'u', ''=>'y', ''=>'y', ''=>'b', ''=>'y', 'f'=>'f', ''=> '', ''=> '', '&'=> 'e',
	''=> '', ''=> '', '$'=> '', '%'=> '', ''=> '', ''=> '', ''=> '', ''=> '', ''=> '', 'ã'=> '',
	'('=> '', ')'=> '', "'"=> '', '@'=> '', '='=> '', ':'=> '', '!'=> '', '?'=> '', '...'=> '', ''=> '',
	'/'=> '', ''=> '', '+'=> '', '*'=> '', '['=> '', ']'=> ''
);

return strtr($nome, $characteres);

}

// Funo para formatar o nome do app para o google play retirando acentos e caracteres especiais
function nome_app_play($texto) {

$characteres = array(
    'S'=>'S', 's'=>'s', ''=>'Dj','Z'=>'Z', 'z'=>'z', ''=>'A', ''=>'A', ''=>'A', ''=>'A', ''=>'A',
    ''=>'A', ''=>'A', ''=>'C', ''=>'E', ''=>'E', ''=>'E', ''=>'E', ''=>'I', ''=>'I', ''=>'I',
    ''=>'I', ''=>'N', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'U', ''=>'U',
    ''=>'U', ''=>'U', ''=>'Y', ''=>'B', ''=>'Ss',''=>'a', ''=>'a', ''=>'a', ''=>'a', ''=>'a',
    ''=>'a', ''=>'a', ''=>'c', ''=>'e', ''=>'e', ''=>'e', ''=>'e', ''=>'i', ''=>'i', ''=>'i',
    ''=>'i', ''=>'o', ''=>'n', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'u',
    ''=>'u', ''=>'u', ''=>'y', ''=>'y', ''=>'b', ''=>'y', 'f'=>'f', ''=> '', ''=> '', '&'=> 'e',
	''=> '', ''=> '', '$'=> '', '%'=> '', ''=> '', ''=> '', ''=> '', ''=> '', ''=> '', 'ã'=> '',
	'('=> '', ')'=> '', "'"=> '', '@'=> '', '='=> '', ':'=> '', '!'=> '', '?'=> '', '...'=> '', ' '=> '',
	'-'=> '', '^'=> '', '~'=> '', '.'=> '', '|'=> '', ','=> '', '<'=> '', '>'=> '', '{'=> '', '}'=> '',
	''=> '', '/'=> '', ''=> '', '+'=> '', '*'=> '', '['=> '', ']'=> ''
);

return strtolower(strtr($texto, $characteres));

}

// Funo para formatar o nome do apk do app retirando acentos e caracteres especiais
function nome_app_apk($texto) {

$characteres = array(
    'S'=>'S', 's'=>'s', ''=>'Dj','Z'=>'Z', 'z'=>'z', ''=>'A', ''=>'A', ''=>'A', ''=>'A', ''=>'A',
    ''=>'A', ''=>'A', ''=>'C', ''=>'E', ''=>'E', ''=>'E', ''=>'E', ''=>'I', ''=>'I', ''=>'I',
    ''=>'I', ''=>'N', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'U', ''=>'U',
    ''=>'U', ''=>'U', ''=>'Y', ''=>'B', ''=>'Ss',''=>'a', ''=>'a', ''=>'a', ''=>'a', ''=>'a',
    ''=>'a', ''=>'a', ''=>'c', ''=>'e', ''=>'e', ''=>'e', ''=>'e', ''=>'i', ''=>'i', ''=>'i',
    ''=>'i', ''=>'o', ''=>'n', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'u',
    ''=>'u', ''=>'u', ''=>'y', ''=>'y', ''=>'b', ''=>'y', 'f'=>'f', ''=> '', ''=> '', '&'=> 'e',
	''=> '', ''=> '', '$'=> '', '%'=> '', ''=> '', ''=> '', ''=> '', ''=> '', ''=> '', 'ã'=> '',
	'('=> '', ')'=> '', "'"=> '', '@'=> '', '='=> '', ':'=> '', '!'=> '', '?'=> '', '...'=> '', ' '=> '',
	'-'=> '', '^'=> '', '~'=> '', '.'=> '', '|'=> '', ','=> '', '<'=> '', '>'=> '', '{'=> '', '}'=> '',
	' '=> '', ''=> '', '/'=> '', ''=> '', '+'=> '', '*'=> '', '['=> '', ']'=> ''
);

return strtr($texto, $characteres);

}

// Funo para copiar o source para o novo app
function copiar_source($DirFont, $DirDest) {
    
    mkdir($DirDest);
    if ($dd = opendir($DirFont)) {
        while (false !== ($Arq = readdir($dd))) {
            if($Arq != "." && $Arq != ".."){
                $PathIn = "$DirFont/$Arq";
                $PathOut = "$DirDest/$Arq";
                if(is_dir($PathIn)){
                    copiar_source($PathIn, $PathOut);
					chmod($PathOut,0777);
                }elseif(is_file($PathIn)){
                    copy($PathIn, $PathOut);
					chmod($PathOut,0777);
                }
            }
        }
        closedir($dd);
	}

}

// Funo para criar arquivos de configurao do app
function criar_arquivo_config($arquivo,$conteudo) {

$fd = fopen ($arquivo, "w");
fputs($fd, $conteudo);
fclose($fd);

}

// Funo para carregar todos os arquivos e pastas de um diretorio
function browse($dir) {
global $filenames;
    if ($handle = opendir($dir)) {
        while (false !== ($file = readdir($handle))) {
            if ($file != "." && $file != ".." && is_file($dir.'/'.$file)) {
                $filenames[] = $dir.'/'.$file;
            }
            else if ($file != "." && $file != ".." && is_dir($dir.'/'.$file)) {
                browse($dir.'/'.$file);
            }
        }
        closedir($handle);
    }
    return $filenames;
}

// Funo para substituir uma string dentro de um arquivo de texto
function replace($arquivo,$string_atual,$string_nova) {

//$str = implode("\n",file($arquivo));
//$fp = fopen($arquivo,'w');
//$str = str_replace($string_atual,$string_nova,$str);

//fwrite($fp,$str,strlen($str));

$str = file_get_contents($arquivo);
$str = str_replace($string_atual,$string_nova,$str);
file_put_contents($arquivo,$str);

}

// Funo para remover o source do novo app
function remover_source_app($Dir){
    
    if ($dd = @opendir($Dir)) {
        while (false !== ($Arq = @readdir($dd))) {
            if($Arq != "." && $Arq != ".."){
                $Path = "$Dir/$Arq";
                if(is_dir($Path)){
                    remover_source_app($Path);
                }elseif(is_file($Path)){
                    @unlink($Path);
                }
            }
        }
        @closedir($dd);
    }
    @rmdir($Dir);
}

// Funo para mudar a permisso de todos os arquivos e pasta no source do app
function mudar_permissao($Dir){

    if ($dd = opendir($Dir)) {
        while (false !== ($Arq = readdir($dd))) {
            if($Arq != "." && $Arq != ".."){
                $Path = "$Dir/$Arq";
                @chmod($Path,0777);
            }
        }
        closedir($dd);
    }

}

// Valida extenso
if($_FILES["logo"]["type"] != "image/png") {
die ("<script> alert(\"Logo deve ser PNG\\n\\nLogo must be PNG\");
 			 window.location = 'javascript:history.back(-1)'; </script>");
}

if($_FILES["icone"]["type"] != "image/png") {
die ("<script> alert(\"Icone deve ser PNG\\n\\nIcon must be PNG\");
 			 window.location = 'javascript:history.back(-1)'; </script>");
}

if($_FILES["fundo"]["type"] != "image/jpeg") {
die ("<script> alert(\"Fundo deve ser JPG\\n\\nBackground must be JPG\");
 			 window.location = 'javascript:history.back(-1)'; </script>");
}

if(strlen($_POST["radio_nome"]) > 30) {
die ("<script> alert(\"Nome da radio deve ter maximo 30 caracteres.\\n\\nRadio name max 30 character.\");
 			 window.location = 'javascript:history.back(-1)'; </script>");
}

if(empty($_POST["radio_nome"])) {
die ("<script> alert(\"Nome da radio esta vazio.\\n\\nRadio name is empty.\");
 			 window.location = 'javascript:history.back(-1)'; </script>");
}

if(empty($_POST["radio_site"])) {
die ("<script> alert(\"Site da radio esta vazio.\\n\\nRadio site is empty.\");
 			 window.location = 'javascript:history.back(-1)'; </script>");
}

if(!filter_var($_POST["radio_facebook"], FILTER_VALIDATE_URL) && !empty($_POST["radio_facebook"])) {
die ("<script> alert(\"Facebook da radio esta invalido.\\n\\nInvalid facebook.\");
 			 window.location = 'javascript:history.back(-1)'; </script>");
}

if(!filter_var($_POST["radio_twitter"], FILTER_VALIDATE_URL) && !empty($_POST["radio_twitter"])) {
die ("<script> alert(\"Twitter da radio esta invalido.\\n\\nTwitter facebook.\");
 			 window.location = 'javascript:history.back(-1)'; </script>");
}

// Verifica se o primeiro caracter  numrico
if(preg_match('/^\d/',$_POST["radio_nome"])) {
die ("<script> alert(\"Nome da radio no pode iniciar com numeros.\\n\\nRadio name cant stat with number.\");
 			 window.location = 'javascript:history.back(-1)'; </script>");
}

// Dados Radio
$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where porta = '".$_POST["porta"]."'"));

$radio_nome = $_POST["radio_nome"];
$radio_email = $_POST["radio_email"];
$radio_site = $_POST["radio_site"];
$chat_url = $_POST["chat_url"];
$radio_facebook = ($_POST["radio_facebook"]) ? $_POST["radio_facebook"] : $_POST["radio_site"];
$radio_twitter = ($_POST["radio_twitter"]) ? $_POST["radio_twitter"] : $_POST["radio_site"];

$radio_whatsapp = str_replace("+","",$_POST["radio_whatsapp"]);
$radio_whatsapp = str_replace(" ","",$radio_whatsapp);
$radio_whatsapp = str_replace("-","",$radio_whatsapp);

// Dados Streaming
$servidor = $_POST["servidor"];
$porta = $_POST["porta"];
$ponto = ($_POST["ponto"]) ? $_POST["ponto"] : 1;

$source = "source";

$hash = nome_app_play($radio_nome)."_".md5($radio_nome);
$package = "com.shoutcast.stm.".nome_app_play($radio_nome)."";
$package_path = str_replace(".","/",$package);

//Bug fix - Remove pasta do app caso exista
remover_source_app("/home/painel/public_html/app/apps/".$hash."/");

if(!file_exists("apps/".$hash.".zip")) {
@unlink("apps/".$hash.".zip");
}

$patch_dir_apps = "apps";
$patch_app = "apps/".$hash."";
$patch_tmp = "apps/tmp";

@copy($_FILES["logo"]["tmp_name"],"".$patch_tmp."/logo_".$hash.".png");
@copy($_FILES["icone"]["tmp_name"],"".$patch_tmp."/icone_".$hash.".png");
@copy($_FILES["fundo"]["tmp_name"],"".$patch_tmp."/fundo_".$hash.".jpg");

// Valida a dimenso(largura x altura) das imagens
list($logo_width, $logo_height, $logo_type, $logo_attr) = getimagesize("".$patch_tmp."/logo_".$hash.".png");
list($icone_width, $icone_height, $icone_type, $icone_attr) = getimagesize("".$patch_tmp."/icone_".$hash.".png");
list($fundo_width, $fundo_height, $fundo_type, $fundo_attr) = getimagesize("".$patch_tmp."/fundo_".$hash.".jpg");

if($logo_width != 300 || $logo_height != 300) {
die ("<script> alert(\"Ooops!\\n\\nA logomarca esta com dimenso invlida!\\n\\nEnvie uma logomarca com 300 pixels de largura e 300 pixels de altura.\");
 			 window.location = 'javascript:history.back(-1)'; </script>");
}

if($icone_width != 144 || $icone_height != 144) {
die ("<script> alert(\"Ooops!\\n\\nO cone esta com dimenso invlida!\\n\\nEnvie um cone com 144 pixels de largura e 144 pixels de altura.\");
 			 window.location = 'javascript:history.back(-1)'; </script>");
}

if($fundo_width != 640 || $fundo_height != 1136) {
die ("<script> alert(\"Ooops!\\n\\nO fundo esta com dimenso invlida!\\n\\nEnvie um fundo com 640 pixels de largura e 1136 pixels de altura.\");
 			 window.location = 'javascript:history.back(-1)'; </script>");
}

// Copia o source do app para o novo app
copiar_source("".$source."/", $patch_app);

// Muda nome do package do source para o nome do package da radio
@rename("".$patch_app."/app/src/main/java/com/shoutcast/stm/radio_nome","".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."");

@rename("".$patch_app."/app/src/androidTest/java/com/shoutcast/stm/radio_nome","".$patch_app."/app/src/androidTest/java/com/shoutcast/stm/".nome_app_play($radio_nome)."");

@rename("".$patch_app."/app/src/test/java/com/shoutcast/stm/radio_nome","".$patch_app."/app/src/test/java/com/shoutcast/stm/".nome_app_play($radio_nome)."");

// Copia o cone
$icone = WideImage::load("".$patch_tmp."/icone_".$hash.".png");
$icone = $icone->resize(72, 72);
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-hdpi/ic_launcher.png");
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-hdpi/ic_launcher_foreground.png");
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-hdpi/ic_launcher_round.png");

$icone = WideImage::load("".$patch_tmp."/icone_".$hash.".png");
$icone = $icone->resize(72, 72);
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-mdpi/ic_launcher.png");
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-mdpi/ic_launcher_foreground.png");
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-mdpi/ic_launcher_round.png");

$icone = WideImage::load("".$patch_tmp."/icone_".$hash.".png");
$icone = $icone->resize(96, 96);
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-xhdpi/ic_launcher.png");
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-xhdpi/ic_launcher_foreground.png");
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-xhdpi/ic_launcher_round.png");

$icone = WideImage::load("".$patch_tmp."/icone_".$hash.".png");
$icone = $icone->resize(144, 144);
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-xxhdpi/ic_launcher.png");
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-xxhdpi/ic_launcher_foreground.png");
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-xxhdpi/ic_launcher_round.png");

$icone = WideImage::load("".$patch_tmp."/icone_".$hash.".png");
$icone = $icone->resize(192, 192);
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-xxxhdpi/ic_launcher.png");
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-xxxhdpi/ic_launcher_foreground.png");
$icone->saveToFile("".$patch_app."/app/src/main/res/mipmap-xxxhdpi/ic_launcher_round.png");

// Copia a logo
$logo = WideImage::load("".$patch_tmp."/logo_".$hash.".png");
$logo = $logo->resize(300, 300);
$logo->saveToFile("".$patch_app."/app/src/main/res/drawable-hdpi/bg_album_art.png");

// Copia o fundo
$fundo = WideImage::load("".$patch_tmp."/fundo_".$hash.".jpg");
$fundo = $fundo->resize(640, 1136);
$fundo->saveToFile("".$patch_app."/app/src/main/res/drawable-hdpi/bg_radio.jpg");

$fundo = WideImage::load("".$patch_tmp."/fundo_".$hash.".jpg");
$fundo = $fundo->resize(640, 1136);
$fundo->saveToFile("".$patch_app."/app/src/main/res/drawable-hdpi/bg_splash.jpg");

// Cria icone para o Play
$play_icone = WideImage::load("".$patch_tmp."/logo_".$hash.".png");
$play_icone = $play_icone->resize(512, 512);
$play_icone->saveToFile("".$patch_app."/arquivos_google_play/img-play-logo.png");

// Cria a imagem de destaque para o Play com a logo da radio
$destaque = WideImage::load("".$patch_app."/arquivos_google_play/img-play-destaque.jpg");
$logo_destaque = WideImage::load("".$patch_tmp."/logo_".$hash.".png");
$play_destaque = $destaque->merge($logo_destaque, 'center', 'center', 100);
$play_destaque->saveToFile("".$patch_app."/arquivos_google_play/img-play-destaque.jpg");

// Cria o print do app para o Play com a logo da radio
$printapp_base = WideImage::load("".$patch_app."/arquivos_google_play/img-play-app.png");
$printapp_fundo = WideImage::load("".$patch_tmp."/fundo_".$hash.".jpg");
$printapp_logo = WideImage::load("".$patch_tmp."/logo_".$hash.".png");

$play_printapp = $printapp_fundo->merge($printapp_base, 'center', 'center', 100);
$play_printapp = $play_printapp->merge($printapp_logo, 'center', 'center', 100);
$play_printapp->saveToFile("".$patch_app."/arquivos_google_play/img-play-app.png");

// Escreve nome da radio no print do app
$printapp = WideImage::load("".$patch_app."/arquivos_google_play/img-play-app.png");
$printapp_canvas = $printapp->getCanvas();
$printapp_canvas->useFont("".$patch_app."/Roboto-Regular.ttf", 25, $printapp->allocateColor(255, 255, 255));
$printapp_canvas->writeText("left+60", "35", formatar_nome_radio($radio_nome));
$printapp->saveToFile("".$patch_app."/arquivos_google_play/img-play-app.png");

// Dados da Radio

replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/Config.java","radio_url_shoutcast","http://".$servidor.":".$porta."/stream/".$ponto."/");
replace("".$patch_app."/app/src/main/res/values/strings.xml","radio_nome",utf8_encode(str_replace("&","&amp;",$radio_nome)));
replace("".$patch_app."/app/src/main/res/values/strings.xml","radio_email",$radio_email);
replace("".$patch_app."/app/src/main/res/values/strings.xml","radio_whatsapp",$radio_whatsapp);
replace("".$patch_app."/app/src/main/res/values/strings.xml","radio_site",$radio_site);
replace("".$patch_app."/app/src/main/res/values/strings.xml","radio_facebook",$radio_facebook);
replace("".$patch_app."/app/src/main/res/values/strings.xml","radio_twitter",$radio_twitter);
replace("".$patch_app."/app/src/main/res/values/strings.xml","radio_package",$package);
replace("".$patch_app."/app/src/main/res/values/strings.xml","radio_chat",$chat_url);

// Personalizacao

//replace("".$patch_app."/app/src/main/res/values/colors.xml","COR_APP","#00796B");
//replace("".$patch_app."/app/src/main/res/values/colors.xml","COR_APP_BTN","#00695C");
//replace("".$patch_app."/app/src/main/res/layout/nav_drawer_header.xml","COR_APP","#00796B");

list($cor1, $cor2, $cor3) = explode("|",$_POST["tema"]);

replace("".$patch_app."/app/src/main/res/values/colors.xml","COR_APP_BTN",$cor2);
replace("".$patch_app."/app/src/main/res/values/colors.xml","COR_APP",$cor1);
replace("".$patch_app."/app/src/main/res/layout/nav_drawer_header.xml","COR_APP",$cor3);

// Muda o package

replace("".$patch_app."/app/src/test/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/ExampleUnitTest.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/fragments/FragmentRadioAdminPanel.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/fragments/FragmentTwitter.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/fragments/FragmentFacebook.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/fragments/FragmentSite.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/fragments/FragmentChat.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/fragments/FragmentRadio.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/fragments/FragmentRadio.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/fragments/FragmentRadio.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/fragments/FragmentRadio.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/utilities/Constant.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/utilities/Tools.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/utilities/PermissionsFragment.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/Config.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/MediaNotificationManager.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/RadioService.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/metadata/PeekInputStream.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/metadata/ShoutcastDataSourceFactory.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/metadata/Metadata.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/metadata/ShoutcastMetadataListener.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/metadata/MetadataListener.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/metadata/ShoutcastDataSource.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/metadata/IcyInputStream.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/metadata/OggInputStream.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/RadioManager.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/parser/M3UParser.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/parser/AlbumArtGetter.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/parser/ASXParser.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/parser/UrlParser.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/parser/PLSParser.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/services/PlaybackStatus.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/notification/MyFirebaseInstanceIdService.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/notification/MyFirebaseMessagingService.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/models/ItemPrivacy.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/models/ItemRadio.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/activities/ActivitySite.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/activities/ActivitySocial.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/activities/MyApplication.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/activities/MainActivity.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/activities/ActivitySplash.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/activities/ActivityAbout.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/activities/ActivityPrivacyPolicy.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/androidTest/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/ExampleInstrumentedTest.java","com.shoutcast.stm.radio_nome",$package);

replace("".$patch_app."/app/src/androidTest/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/ExampleInstrumentedTest.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/test/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/ExampleUnitTest.java","com.shoutcast.stm.radio_nome",$package);

replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/adapters/AdapterAbout.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/utilities/CollapseControllingFragment.java","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/utilities/Log.java","com.shoutcast.stm.radio_nome",$package);

replace("".$patch_app."/app/build.gradle","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/google-services.json","com.shoutcast.stm.radio_nome",$package);
replace("".$patch_app."/app/src/main/AndroidManifest.xml","com.shoutcast.stm.radio_nome",$package);

// Ativa/desativa chat
if($_POST["chat"] == "sim") {
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/activities/ActivitySocial.java","TOTAL_MENUS_SOCIAL","4");
} else {
replace("".$patch_app."/app/src/main/java/com/shoutcast/stm/".nome_app_play($radio_nome)."/activities/ActivitySocial.java","TOTAL_MENUS_SOCIAL","3");
}


if($_POST["versao"] == '1.0') {
$codigo_versao = 1;
} elseif($_POST["versao"] == '1.1') {
$codigo_versao = 2;
} elseif($_POST["versao"] == '1.2') {
$codigo_versao = 3;
} elseif($_POST["versao"] == '1.3') {
$codigo_versao = 4;
} elseif($_POST["versao"] == '1.4') {
$codigo_versao = 5;
} elseif($_POST["versao"] == '1.5') {
$codigo_versao = 6;
} elseif($_POST["versao"] == '1.6') {
$codigo_versao = 7;
} elseif($_POST["versao"] == '1.7') {
$codigo_versao = 8;
} elseif($_POST["versao"] == '1.8') {
$codigo_versao = 9;
} elseif($_POST["versao"] == '1.9') {
$codigo_versao = 10;
} elseif($_POST["versao"] == '1.10') {
$codigo_versao = 11;
} elseif($_POST["versao"] == '1.11') {
$codigo_versao = 12;
} elseif($_POST["versao"] == '1.12') {
$codigo_versao = 13;
} elseif($_POST["versao"] == '1.13') {
$codigo_versao = 14;
} elseif($_POST["versao"] == '1.14') {
$codigo_versao = 15;
} elseif($_POST["versao"] == '1.15') {
$codigo_versao = 16;
} elseif($_POST["versao"] == '1.16') {
$codigo_versao = 17;
} elseif($_POST["versao"] == '1.17') {
$codigo_versao = 18;
} elseif($_POST["versao"] == '1.18') {
$codigo_versao = 19;
} elseif($_POST["versao"] == '1.19') {
$codigo_versao = 20;
} elseif($_POST["versao"] == '1.20') {
$codigo_versao = 21;
} else {
$codigo_versao = 1;
}

replace("".$patch_app."/app/src/main/AndroidManifest.xml","codigo_versao",$codigo_versao);
replace("".$patch_app."/app/src/main/AndroidManifest.xml","numero_versao",$_POST["versao"]);
replace("".$patch_app."/app/build.gradle","codigo_versao",$codigo_versao);
replace("".$patch_app."/app/build.gradle","numero_versao",$_POST["versao"]);
replace("".$patch_app."/gradlew","HASH_GRADLEW_APP",$hash);

// Muda o idioma do app conforme o idioma do painel
if($_POST["idioma_painel"] == "pt-br") {

replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_SHARE","Compartilhar");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_SHARE","Gostaria de compartilhar meu app favorito com voc.");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_RATE","Avaliar App");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_SAIR","O que deseja fazer?");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_SAIR","Sair");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_MINIMIZAR","Minimizar");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_CANCELAR","Cancelar");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_MAIS","Mais");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_SOBRE","Sobre");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_POLITICA","Politica de Privacidade");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_OUTROS","Outros");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_TOCANDO","Tocando agora");

} elseif($_POST["idioma_painel"] == "en-us") {

replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_SHARE","Share");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_SHARE","I want to share my favorite app with you.");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_RATE","Rate App");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_SAIR","What do you want?");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_SAIR","Exit");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_MINIMIZAR","Minimize");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_CANCELAR","Back");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_MAIS","More");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_SOBRE","About");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_POLITICA","Privacy Policy");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_OUTROS","Others");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_TOCANDO","Playing now");

} else {

replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_SHARE","Compartir");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_SHARE","Me gustaria compartir mi app favorito con tu.");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_RATE","Avaliar App");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_SAIR","Elija?");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_SAIR","Salir");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_MINIMIZAR","Minimizar");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_CANCELAR","Volver");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_MAIS","Mas");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_SOBRE","Sobre");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_POLITICA","Politica de Privacidade");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_BTN_OUTROS","Otros");
replace("".$patch_app."/app/src/main/res/values/strings.xml","MSG_TOCANDO","Sonando ahora");

}

// Remove o source do app
@unlink("".$patch_tmp."/logo_".$hash.".png");
@unlink("".$patch_tmp."/icone_".$hash.".png");
@unlink("".$patch_tmp."/fundo_".$hash.".jpg");

// Compila o app
$nome_apk = nome_app_apk($_POST["radio_nome"]);

//Bug fix
remover_source_app("apps/".$hash."/app/src/main/java/com/shoutcast/stm/radio_nome");

// Compila o App
shell_exec("export JAVA_HOME=/usr;export PATH=\$JAVA_HOME/bin:\$PATH;cd /home/painel/public_html/app/apps/".$hash.";./gradlew bundleRelease;./gradlew assembleRelease");

// Assina o app com certificado
if($_POST["certificado"] == "padrao") {

shell_exec("export JAVA_HOME=/usr;export PATH=\$JAVA_HOME/bin:\$PATH;/opt/android-sdk-linux/build-tools/28.0.3/apksigner sign --ks-pass pass:EE4F5AD2D81078B62EBA6EA5E8 --ks /home/painel/public_html/app/apps/".$hash."/certificado.jks --out /home/painel/public_html/app/apps/".$hash."/arquivos_google_play/App-".$nome_apk.".apk /home/painel/public_html/app/apps/".$hash."/app/build/outputs/apk/release/app-release-unsigned.apk;jarsigner -verbose -sigalg SHA256withRSA -digestalg SHA-256 -keystore /home/painel/public_html/app/apps/".$hash."/certificado.jks -storepass EE4F5AD2D81078B62EBA6EA5E8 -keypass EE4F5AD2D81078B62EBA6EA5E8 /home/painel/public_html/app/apps/".$hash."/app/build/outputs/bundle/release/app.aab chave;cp -f /home/painel/public_html/app/apps/".$hash."/app/build/outputs/bundle/release/app.aab /home/painel/public_html/app/apps/".$hash."/arquivos_google_play/App-".$nome_apk.".aab");

}

if($_POST["certificado"] == "novo") {

//Cria o certificado
$nome_certificado = md5($nome_apk);

shell_exec("export JAVA_HOME=/usr;export PATH=\$JAVA_HOME/bin:\$PATH;keytool -genkey -alias streaming -keyalg RSA -keystore /home/painel/public_html/app/keys/".$nome_certificado.".jks -dname 'CN=Streaming, OU=Streaming, O=Streaming, L=Streaming, S=Brasil, C=BR' -storepass ".$nome_certificado." -keypass ".$nome_certificado." -validity 365000");

// Assina o app com certificado
shell_exec("export JAVA_HOME=/usr;export PATH=\$JAVA_HOME/bin:\$PATH;/opt/android-sdk-linux/build-tools/28.0.3/apksigner sign --ks-pass pass:".$nome_certificado." --ks /home/painel/public_html/app/keys/".$nome_certificado.".jks --out /home/painel/public_html/app/apps/".$hash."/arquivos_google_play/App-".$nome_apk.".apk /home/painel/public_html/app/apps/".$hash."/app/build/outputs/apk/release/app-release-unsigned.apk;jarsigner -verbose -sigalg SHA256withRSA -digestalg SHA-256 -keystore /home/painel/public_html/app/keys/".$nome_certificado.".jks -storepass ".$nome_certificado." -keypass ".$nome_certificado." /home/painel/public_html/app/apps/".$hash."/app/build/outputs/bundle/release/app.aab streaming;cp -f /home/painel/public_html/app/apps/".$hash."/app/build/outputs/bundle/release/app.aab /home/painel/public_html/app/apps/".$hash."/arquivos_google_play/App-".$nome_apk.".aab");

mysqli_query($conexao,"Update streamings set app_certificado = '".$nome_certificado."' where porta = '".$_POST["porta"]."'");

}

if($_POST["certificado"] == "personalizado") {

shell_exec("export JAVA_HOME=/usr;export PATH=\$JAVA_HOME/bin:\$PATH;/opt/android-sdk-linux/build-tools/28.0.3/apksigner sign --ks-pass pass:".$dados_stm["app_certificado"]." --ks /home/painel/public_html/app/keys/".$dados_stm["app_certificado"].".jks --out /home/painel/public_html/app/apps/".$hash."/arquivos_google_play/App-".$nome_apk.".apk /home/painel/public_html/app/apps/".$hash."/app/build/outputs/apk/release/app-release-unsigned.apk;jarsigner -verbose -sigalg SHA256withRSA -digestalg SHA-256 -keystore /home/painel/public_html/app/keys/".$dados_stm["app_certificado"].".jks -storepass ".$dados_stm["app_certificado"]." -keypass ".$dados_stm["app_certificado"]." /home/painel/public_html/app/apps/".$hash."/app/build/outputs/bundle/release/app.aab streaming;cp -f /home/painel/public_html/app/apps/".$hash."/app/build/outputs/bundle/release/app.aab /home/painel/public_html/app/apps/".$hash."/arquivos_google_play/App-".$nome_apk.".aab");

}

if(file_exists("apps/".$hash."/arquivos_google_play/App-".$nome_apk.".apk") && file_exists("apps/".$hash."/arquivos_google_play/App-".$nome_apk.".aab")) {

// Cria o zip com o conteudo para publicao no google play
$zip = new ZipArchive();
if ($zip->open("apps/".$hash.".zip", ZIPARCHIVE::CREATE)!==TRUE) {
    die("No foi possvel criar o arquivo ZIP: ".$hash.".zip");
}

$zip->addEmptyDir("".$nome_apk."");
$zip->addFile("apps/".$hash."/arquivos_google_play/App-".$nome_apk.".apk","".$nome_apk."/App-".$nome_apk.".apk");
$zip->addFile("apps/".$hash."/arquivos_google_play/App-".$nome_apk.".aab","".$nome_apk."/App-".$nome_apk.".aab");
$zip->addFile("apps/".$hash."/arquivos_google_play/img-play-logo.png","".$nome_apk."/img-play-logo.png");
$zip->addFile("apps/".$hash."/arquivos_google_play/img-play-destaque.jpg","".$nome_apk."/img-play-destaque.jpg");
$zip->addFile("apps/".$hash."/arquivos_google_play/img-play-app.png","".$nome_apk."/img-play-app.png");
$status=$zip->getStatusString();
$zip->close();

if(!file_exists("apps/".$hash.".zip")) {
shell_exec("cd apps/;/usr/bin/zip -1 ".$hash.".zip ".$hash.";/usr/bin/zip -1 ".$hash.".zip ".$hash."/arquivos_google_play/*");
}

// Remove source
if($hash != "") {
remover_source_app("apps/".$hash."");
}

header("Location: ".$_SERVER['HTTP_REFERER']."/".$package."|".$hash."");
exit();

} else {
header("Location: ".$_SERVER['HTTP_REFERER']."/erro|compilar");
exit();
}
?>