<?php
require_once("admin/inc/protecao-final.php");

@mysqli_query($conexao,"ALTER TABLE `playlists_agendamentos` ADD `finalizacao` CHAR(20) NOT NULL DEFAULT 'repetir';");
@mysqli_query($conexao,"ALTER TABLE `playlists_agendamentos` ADD `codigo_playlist_finalizacao` INT(10) NOT NULL DEFAULT '0';");
@mysqli_query($conexao,"ALTER TABLE `playlists_agendamentos` ADD `misturar_musicas` CHAR(3) NOT NULL DEFAULT 'nao';");
@mysqli_query($conexao,"ALTER TABLE `playlists_agendamentos` ADD `inicio` INT(1) NOT NULL DEFAULT '2';");

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND codigo_usuario = '".$dados_stm["porta"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;

if($_POST["cadastrar"]) {

$dados_playlist = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM playlists where codigo = '".$_POST["codigo_playlist"]."'"));

list($hora,$minuto) = explode(":",$_POST["hora"]);
list($ano,$mes,$dia) = explode("-",$_POST["data"]);
$data_execussao = $ano."-".$mes."-".$dia;

if(@count($_POST["dias"]) > 0){
    $dias = implode(",",$_POST["dias"]);
}

mysqli_query($conexao,"INSERT INTO playlists_agendamentos (codigo_stm,codigo_playlist,frequencia,data,hora,minuto,dias,inicio,finalizacao,codigo_playlist_finalizacao,misturar_musicas) VALUES ('".$dados_stm["codigo"]."','".$_POST["codigo_playlist"]."','".$_POST["frequencia"]."','".$data_execussao."','".sprintf("%02d",$hora)."','".sprintf("%02d",$minuto)."','".$dias.",','".$_POST["inicio"]."','".$_POST["finalizacao"]."','".$_POST["codigo_playlist_finalizacao"]."','".$_POST["misturar_musicas"]."')");

// Cria o sessão do status das ações executadas e redireciona.
$_SESSION["status_acao"] = '<div class="alert alert-success text-center" role="alert">'.$lang['lang_acao_gerenciador_agendamentos_resultado_ok'].'</div>';

header("Location: /gerenciar-agendamentos");
exit();
}

if($_POST["remover_logs"]) {
mysqli_query($conexao,"Delete From playlists_agendamentos_logs Where codigo_stm = '".$dados_stm["codigo"]."'");

// Cria o sessão do status das ações executadas e redireciona.
$_SESSION["status_acao"] = '<div class="alert alert-success text-center" role="alert">'.$lang['lang_acao_gerenciador_agendamentos_resultado_remover_logs'].'</div>';

header("Location: /gerenciar-agendamentos");
exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Streaming <?php echo $dados_stm["porta"]; ?></title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">
  <link rel="stylesheet" href="/inc/theme.css">
  <link rel="shortcut icon" href="/img/favicon.ico">
  <script type="text/javascript" src="/inc/ajax-streaming.js"></script>
  <script type="text/javascript" src="/inc/javascript.js"></script>
</head>

<body>
  <div class="container-scroller">
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <?php if($dados_revenda["url_logo"]) { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><img id="logo" src="<?php echo $dados_revenda["url_logo"]; ?>" title="Painel" height="60" border="0"></a>
        <?php } else { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><span>Painel Streaming</span></a>
        <?php } ?>
        <a class="navbar-brand brand-logo-mini" href="/dashboard"><img src="/img/icones/img-icone-logo.png" title="Painel" width="32" height="32" border="0"></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item nav-profile dropdown show">
            <a class="nav-link dropdown-toggle" href="#" data-toggle="dropdown" id="profileDropdown" aria-expanded="true">
              <i class="fa fa-power-off f-18 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_botao_titulo_ligar']; ?>/<?php echo $lang['lang_botao_titulo_desligar']; ?>"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown" aria-labelledby="profileDropdown">
              <a class="dropdown-item text-success" href="javascript:ligar_streaming('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> Streaming</a>
              <a class="dropdown-item text-danger" href="javascript:desligar_streaming('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_desligar']; ?> Streaming</a>
              <?php if($dados_stm["autodj"] == "sim") { ?>
              <div class="dropdown-divider"></div>              
              <a class="dropdown-item text-success" href="javascript:carregar_opcoes_ligar_autodj('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> AutoDJ</a>
              <a class="dropdown-item text-danger" href="javascript:desligar_autodj('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_desligar']; ?> AutoDJ</a>
              <?php } ?>
            </div>
          </li>
          <li class="nav-item dropdown">
            <a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown" aria-expanded="false">
              <i class="mdi mdi-bell f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?>"></i>
              <?php if($total_avisos_exibir > 0) { ?><span class="count bg-success"><?php echo $total_avisos_exibir; ?></span><?php } ?>           
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
              <a class="dropdown-item">
                <p class="mb-0 font-weight-normal float-left"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></p>
              </a>
              <div class="dropdown-divider"></div>
              <?php carregar_avisos_streaming($conexao,$dados_stm["porta"],$dados_servidor["codigo"]); ?>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
          <li>
            <button type="button" class="btn btn-info" id="status-streaming" onClick="status_streaming('<?php echo $porta_code; ?>');" style="margin: 10px;min-width: 150px; min-height: 40px"><i class="fa fa-refresh"></i></button>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>

    <!-- modal -->
      <div class="modal fade" id="avisos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" id="avisos-conteudo"><img src="/img/ajax-loader.gif" align="center" /></div>
            </div>
        </div>
      </div>
                
      <div class="modal fade" id="playlists-autodj" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">AutoDJ</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body text-center" id="playlists-autodj-conteudo" style="text-align: center;"><img src="/img/ajax-loader.gif" /></div>
            </div>
          </div>
      </div>
                
      <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
      
    <div class="container-fluid page-body-wrapper">      
    <?php require_once("menu.php"); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

           <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo $lang['lang_info_gerenciador_agendamentos_aba_agendamentos']; ?></header>
                  </div>
                <div class="card-body">
                    <table id="data_table1" class="table dataTable no-footer" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_gerenciador_agendamentos_playlist']; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_gerenciador_agendamentos_horario_agendado']; ?></th>
                                                        <th class="nosort sorting_disabled" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_gerenciador_agendamentos_executar_acao']; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql = mysqli_query($conexao,"SELECT * FROM playlists_agendamentos where codigo_stm = '".$dados_stm["codigo"]."' ORDER by data DESC");
while ($dados_agendamento = mysqli_fetch_array($sql)) {

$dados_playlist = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM playlists where codigo = '".$dados_agendamento["codigo_playlist"]."'"));

list($ano,$mes,$dia) = explode("-",$dados_agendamento["data"]);
$data = $dia."/".$mes."/".$ano;

if($dados_agendamento["frequencia"] == "1") {
$descricao = "".$lang['lang_info_gerenciador_agendamentos_info_frequencia1']." ".$data." ".$dados_agendamento["hora"].":".$dados_agendamento["minuto"]."";
} elseif($dados_agendamento["frequencia"] == "2") {
$descricao = "".$lang['lang_info_gerenciador_agendamentos_info_frequencia2']." ".$dados_agendamento["hora"].":".$dados_agendamento["minuto"]."";
} else {

$array_dias = explode(",",$dados_agendamento["dias"]);

foreach($array_dias as $dia) {

if($dia == "1") {
$dia_nome = "<font color='#003399'>".$lang['lang_label_segunda']."</font>";
} elseif($dia == "2") {
$dia_nome = "<font color='#FF0000'>".$lang['lang_label_terca']."</font>";
} elseif($dia == "3") {
$dia_nome = "<font color='#FF9900'>".$lang['lang_label_quarta']."</font>";
} elseif($dia == "4") {
$dia_nome = "<font color='#CC0066'>".$lang['lang_label_quinta']."</font>";
} elseif($dia == "5") {
$dia_nome = "<font color='#009900'>".$lang['lang_label_sexta']."</font>";
} elseif($dia == "6") {
$dia_nome = "<font color='#663300'>".$lang['lang_label_sabado']."</font>";
} elseif($dia == "7") {
$dia_nome = "<font color='#663399'>".$lang['lang_label_domingo']."</font>";
} else {
$dia_nome = "";
}

$lista_dias .= "".$dia_nome.", ";

}

$descricao = "".$lang['lang_info_gerenciador_agendamentos_info_frequencia3']." ".substr($lista_dias, 0, -2)." ".$dados_agendamento["hora"].":".$dados_agendamento["minuto"]."";
}

$agendamento_code = code_decode($dados_agendamento["codigo"],"E");

echo "<tr id='".$agendamento_code."'>
<td height='25' align='left' scope='col'>&nbsp;".$dados_playlist["nome"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$descricao."</td>
<td height='25' align='left' scope='col'><a href='javascript:remover_agendamento(\"".$agendamento_code."\");' data-toggle='tooltip' data-placement='bottom' title='".$lang['lang_info_gerenciador_agendamentos_acao_remover']."'><i class='fa fa-trash-o text-danger'></i></a></td>
</tr>";

unset($lista_dias);
unset($dia_nome);
}
?>
                                                </tbody>
                                            </table>
                </div>
              </div>
            </div>

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo $lang['lang_info_gerenciador_agendamentos_aba_cadastrar_agendamento']; ?></header>
                  </div>
                <div class="card-body">
                    <form method="post" action="/gerenciar-agendamentos" name="agendamentos">
                                                <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                                  <tr>
                                                    <td width="140" height="50" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_gerenciador_agendamentos_playlist']; ?></strong></td>
                                                    <td align="left">
                                                    <select name="codigo_playlist" id="codigo_playlist" class="form-control" style="width:100%;">
                                                    <?php
                                                    $query_playlists = mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo ASC");
                                                    while ($dados_playlist = mysqli_fetch_array($query_playlists)) {
                                                
                                                    $total_musicas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));
                                                    $duracao = mysqli_fetch_array(mysqli_query($conexao,"SELECT *,SUM(duracao_segundos) as total FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));

                                                    if($total_musicas > 0) {
                                                    echo '<option value="'.$dados_playlist["codigo"].'">'.$dados_playlist["nome"].' ('.gmdate("H:i:s", $duracao["total"]).')</option>';
                                                    } else {
                                                    echo '<option value="'.$dados_playlist["codigo"].'" disabled="disabled">'.$dados_playlist["nome"].' ('.$lang['lang_info_sem_musicas'].')</option>';
                                                    }
                                                    }
                                                    ?>
                                                    </select>
                                                </td>
                                                  </tr>
                                                  <tr>
                                                    <td height="50" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_gerenciador_agendamentos_frequencias']; ?></strong></td>
                                                    <td align="left">
                                                    <select name="frequencia" id="frequencia" class="form-control" style="width:100%;" onchange="valida_opcoes_frequencia(this.value);">
                                                      <option value="1" selected="selected"><?php echo $lang['lang_info_gerenciador_agendamentos_frequencia1']; ?></option>
                                                      <option value="2"><?php echo $lang['lang_info_gerenciador_agendamentos_frequencia2']; ?></option>
                                                      <option value="3"><?php echo $lang['lang_info_gerenciador_agendamentos_frequencia3']; ?></option>
                                                    </select>
                                                </td>
                                                  </tr>
                                                  <tr>
                                                    <td height="50" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_gerenciador_agendamentos_data_inicio']; ?></strong></td>
                                                    <td align="left"><input class="form-control" id="data" name="data" type="date" style="width:200px;"></td>
                                                  </tr>
                                                  <tr>
                                                    <td height="50" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_gerenciador_agendamentos_horario_inicio']; ?></td>
                                                    <td align="left"><input class="form-control" id="hora" name="hora" type="time" style="width:200px;"></td>
                                                  </tr>                                                  
                                                  <tr>
                                                    <td height="35" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_gerenciador_agendamentos_dias_especificos']; ?></strong></td>
                                                    <td align="left">
                                                    <input name="dias[]" type="checkbox" value="1" id="dias" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_segunda']; ?>&nbsp;
                                                    <input name="dias[]" type="checkbox" value="2" id="dias" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_terca']; ?>&nbsp;
                                                    <input name="dias[]" type="checkbox" value="3" id="dias" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_quarta']; ?>&nbsp;
                                                    <input name="dias[]" type="checkbox" value="4" id="dias" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_quinta']; ?>&nbsp;
                                                    <input name="dias[]" type="checkbox" value="5" id="dias" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_sexta']; ?>&nbsp;
                                                    <input name="dias[]" type="checkbox" value="6" id="dias" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_sabado']; ?>&nbsp;
                                                    <input name="dias[]" type="checkbox" value="7" id="dias" style="vertical-align:middle" />&nbsp;<?php echo $lang['lang_label_domingo']; ?></td>
                                                  </tr>
                                                  <tr>
                                                    <td height="35" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_gerenciador_agendamentos_inicio']; ?></strong></td>
                                                    <td align="left"><input type="radio" name="inicio" id="inicio" value="1" />&nbsp;<?php echo $lang['lang_info_gerenciador_agendamentos_inicio_imediato']; ?>&nbsp;&nbsp;
                                                      <input type="radio" name="inicio" id="inicio" value="2" checked="checked" />&nbsp;<?php echo $lang['lang_info_gerenciador_agendamentos_inicio_apos']; ?></td>
                                                  </tr>

      <tr>
        <td height="30" align="left" style="padding-left:5px;"><strong>Ordem M&uacute;sicas</strong></td>
        <td align="left" valign="middle" class="texto_padrao"><input type="radio" name="misturar_musicas" id="misturar_musicas" value="nao" checked="checked" />&nbsp;Seguir Ordem
          <input type="radio" name="misturar_musicas" id="misturar_musicas" value="sim" />&nbsp;Misturar</td>
      </tr>
      <tr>
        <td height="30" align="left" style="padding-left:5px;"><strong>Finaliza&ccedil;&atilde;o</strong></td>
        <td align="left" valign="middle" class="texto_padrao"><input type="radio" name="finalizacao" id="finalizacao" value="repetir" checked="checked" onclick="lista_playlist_finalizacao('nao')" />&nbsp;Repetir Músicas(loop)
          <input type="radio" name="finalizacao" id="finalizacao" value="iniciar_playlist" onclick="lista_playlist_finalizacao('sim')" />&nbsp;Iniciar Outra Playlist</td>
      </tr>
      <tr id="lista_playlist_finalizacao" style="display:none">
        <td width="160" height="30" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_gerenciador_agendamentos_playlist']; ?></strong></td>
        <td width="730" align="left">
        <select name="codigo_playlist_finalizacao" id="codigo_playlist_finalizacao" class="form-control" style="width:100%;">
        <?php
    $query_playlists = mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo ASC");
    while ($dados_playlist = mysqli_fetch_array($query_playlists)) {
  
    $total_musicas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));
    $duracao = mysqli_fetch_array(mysqli_query($conexao,"SELECT *,SUM(duracao_segundos) as total FROM playlists_musicas where codigo_playlist = '".$dados_playlist["codigo"]."'"));

    if($total_musicas > 0) {
    echo '<option value="'.$dados_playlist["codigo"].'">'.$dados_playlist["nome"].' ('.sprintf('%02d:%02d:%02d', ($duracao["total"]/3600),($duracao["total"]/60%60), $duracao["total"]%60).')</option>';
    } else {
    echo '<option value="'.$dados_playlist["codigo"].'" disabled="disabled">'.$dados_playlist["nome"].' ('.$lang['lang_info_sem_musicas'].')</option>';
    }
    }
        ?>
        </select>        </td>
      </tr>
                                                  <tr>
                                                    <td height="50" colspan="2" align="right"><input name="cadastrar" type="hidden" id="cadastrar" value="sim" /><button type="button" class="btn btn-info" onClick="document.agendamentos.submit();"><?php echo $lang['lang_botao_titulo_cadastrar']; ?></button></td>
                                                  </tr>
                                                </table>
                                            </form>
                </div>
              </div>
            </div>

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo $lang['lang_info_gerenciador_agendamentos_aba_logs']; ?> <a href='javascript:document.form_remover_logs.submit();' data-toggle='tooltip' data-placement='left' title='<?php echo $lang['lang_info_gerenciador_agendamentos_acao_remover']; ?> Logs'><i class='fa fa-trash-o text-danger'></i></a></header>
                    <form action="/gerenciar-agendamentos" method="post" name="form_remover_logs"><input name="remover_logs" type="hidden" value="sim" /></form>
                  </div>
                <div class="card-body">
                    <table id="data_table2" class="table dataTable no-footer" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_gerenciador_agendamentos_logs_data']; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo $lang['lang_info_gerenciador_agendamentos_logs_playlist']; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql = mysqli_query($conexao,"SELECT * FROM playlists_agendamentos_logs WHERE codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo DESC LIMIT 100");
while ($dados_log_agendamento = mysqli_fetch_array($sql)) {

echo "<tr>
<td height='25' align='left' scope='col'>&nbsp;".formatar_data($dados_stm["formato_data"], $dados_log_agendamento["data"], $dados_stm["timezone"])."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_log_agendamento["playlist"]."</td>
</tr>";

}
?>
                                                </tbody>
                                            </table>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>      

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  status_streaming('<?php echo $porta_code; ?>');
  setInterval("status_streaming('<?php echo $porta_code; ?>')",60000);
        $(document).ready(function() {

            var table = $('#data_table1').DataTable({
                responsive: true,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                "order": [],
                "aaSorting": []
            });
            $('#data_table1 tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });


            var table = $('#data_table2').DataTable({
                responsive: true,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                "order": [],
                "aaSorting": []
            });
            $('#data_table2 tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });
        });
        function lista_playlist_finalizacao(opcao) {

if(opcao == "sim") {
document.getElementById('lista_playlist_finalizacao').style.display = 'table-row';
} else {
document.getElementById('lista_playlist_finalizacao').style.display = 'none';
}

}
  </script>
</body>
</html>