////////////////////////////////////////////////////////
/////////// Funes Gerenciamento Playlist /////////////
////////////////////////////////////////////////////////

// Funo para criar uma nova playlist
function criar_playlist( porta ) {
  
  var playlist = document.getElementById("nome-nova-playlist").value;
	
  if(playlist != "" && playlist != null) {
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/criar_playlist/"+porta+"/"+playlist , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	resultado_partes = resultado.split("|");
	
	if(resultado_partes[0] == "ok") {
	
	document.getElementById("nova-playlist-conteudo").innerHTML = "<img src='/img/ajax-loader.gif' />";	
    window.location = '/gerenciar-playlists/'+resultado_partes[1];
	
	} else {
	
	document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-danger text-center" role="alert">'+resultado_partes[1]+'</div>';
	$('#nova-playlist').modal('hide');
	$("#local-status-acoes").delay(15000).fadeOut(300);
	
	}
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Funo para carregar as pastas
function carregar_pastas( porta ) {

  if(porta == "") {
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-danger text-center" role="alert">Error! Portugus: Dados faltando, tente novamente ou contate o suporte. English: Missing data try again or contact support. Espaol: Los datos que faltaban intntelo de nuevo o contacte con atencin.</div>';
  } else {
  
  // Limpa a lista de pastas j carregadas
  document.getElementById("lista-pastas").innerHTML = "";
  
  document.getElementById("status_lista_pastas").innerHTML = "<img src='http://"+get_host()+"/img/ajax-loader.gif' />";
  document.getElementById("status_lista_pastas").style.display = "block";
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/carregar_pastas/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	if(resultado) {
	
	array_pastas = resultado.split(";");
	
	for(var cont = 0; cont < array_pastas.length; cont++) {	
	 
	if(array_pastas[cont]) {
	
	dados_pasta = array_pastas[cont].split("|");
	
	var nova_pasta = document.createElement("li");
	
	nova_pasta.innerHTML = "<i class='fa fa-folder-open f-16 text-danger'></i>&nbsp;<a href='javascript:carregar_musicas_pasta(\""+porta+"\",\""+dados_pasta[0]+"\");'>"+dados_pasta[0]+"&nbsp;("+dados_pasta[1]+")</a>";
  
    document.getElementById("lista-pastas").appendChild(nova_pasta);
	
	document.getElementById("status_lista_pastas").style.display = "none";
	
	}
	
	}
	
	}
  
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Funo para carregar as msicas da pasta do FTP no gerenciamento de playlist
function carregar_musicas_pasta( porta,pasta ) {
	
  if(porta == "" || pasta == "") {
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-danger text-center" role="alert">Error! Portugus: Dados faltando, tente novamente ou contate o suporte. English: Missing data try again or contact support. Espaol: Los datos que faltaban intntelo de nuevo o contacte con atencin.</div>';
  } else {
  
  // Limpa a lista de msicas j carregadas
  document.getElementById("lista-musicas-pasta").innerHTML = "";  
  document.getElementById("status_lista_musicas").style.display = "block";  
  document.getElementById("msg_pasta").style.display = "none";
  
  if(document.getElementById("ordenar_musicas_pasta").checked) {
  var ordenar = "sim";
  }
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/carregar_musicas_pasta_playlists/"+porta+"/"+pasta+"/"+ordenar , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("status_lista_musicas").style.display = "none";
	
	if(resultado) {
	
	array_musicas = resultado.split(";");
	
	for(var cont = 0; cont < array_musicas.length; cont++) {	
	 
	if(array_musicas[cont]) {
	
	dados_musica = array_musicas[cont].split("|");
	
	var nova_musica = document.createElement("li");
	
	var nome = dados_musica[0];
	var duracao = dados_musica[1];
	var duracao_segundos = dados_musica[2];
	
	if(pasta == "/") {
	var path_musica = nome;
	} else {
	var path_musica = ""+pasta+"/"+nome+"";
	}
	
	if (/[^a-z0-9_\-\. ]/gi.test(nome)) {
  
	nova_musica.innerHTML = "<i class='fa fa-ban f-16 text-danger'></i>&nbsp;["+duracao+"] <span title='Contm acentos/Special Chars' style='color:#FF0000;'>"+nome+"</span>";
	
	nova_musica.style.backgroundColor = "#FFBFBF";
	nova_musica.style.cursor = "pointer";
	nova_musica.addEventListener("click", function(){ alert("Arquivo invlido com caracteres especiais.\n\nInvalid file with special chars.\n\nNombre de archivo no vlido con caracteres especiales."); });
	
	} else {
		
	nova_musica.innerHTML = "<input id='musicas_pasta' tipo='musica' duracao='"+duracao+"' duracao_segundos='"+duracao_segundos+"' type='checkbox' value='"+path_musica+"' style='display:none' checked /><i class='fa fa-file-audio-o f-16'></i>&nbsp;<a href='javascript:adicionar_musica_playlist(\""+path_musica+"\",\""+nome+"\",\""+duracao+"\",\""+duracao_segundos+"\");'>["+duracao+"] "+nome+"</a><span style='float:right;'><a href='javascript:play_musica(\""+porta+"\",\""+path_musica+"\",\"musica\");' title='Play "+nome+"'><img src='/img/icones/img-icone-play.png' width='16' height='16' border='0' align='absmiddle' /></a><a href='javascript:download_musica(\""+porta+"\",\""+path_musica+"\",\"musica\");' title='Download "+nome+"'><img src='/img/icones/img-icone-download-mp3.png' width='16' height='16' border='0' align='absmiddle' /></a><a href='javascript:adicionar_posicao(\""+path_musica+"\",\""+nome+"\",\""+duracao+"\",\""+duracao_segundos+"\",\"musica\");' title='Adicionar na Posi&ccedil;&atilde;o/Add on Position' style='padding-right:5px;'><img src='/img/icones/img-icone-inserir-posicao.png' width='16' height='16' alt='Adicionar na Posi&ccedil;&atilde;o/Add on Position' border='0' align='absmiddle' /></a><a href='javascript:adicionar_vinheta(\""+path_musica+"\",\""+nome+"\",\""+duracao+"\",\""+duracao_segundos+"\");' title='Intercalar/Interleave'><img src='/img/icones/img-icone-vinheta.png' width='16' height='16' alt='Intercalar/Interleave' border='0' align='absmiddle' /></a>";
	
	}
  
    document.getElementById("lista-musicas-pasta").appendChild(nova_musica);
	
	}
	
	}
	
	} else {

	document.getElementById("msg_pasta").innerHTML = "A pasta selecionada no possui msicas. Voc deve enviar as msicas usando FTP ou gerenciador de msicas.";
	document.getElementById("msg_pasta").style.display = "block";
	
	}
  
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Funo para carregar as msicas da playlist
function carregar_musicas_playlist( playlist ) {
	
  if(playlist == "") {
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-danger text-center" role="alert">Error! Portugus: Dados faltando, tente novamente ou contate o suporte. English: Missing data try again or contact support. Espaol: Los datos que faltaban intntelo de nuevo o contacte con atencin.</div>';
  } else {
  
  // Seleciona a playlist
  document.getElementById("playlist").value = playlist;
  
  // Limpa as msicas da ltima playlist selecionada
  limpar_lista_musicas('playlist');
  document.getElementById("status_lista_musicas_playlist").style.display = "block";  
  document.getElementById("msg_playlist").style.display = "none";

  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/carregar_musicas_playlist/"+playlist , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("status_lista_musicas_playlist").style.display = "none"; 
	
	if(resultado) { 
	
	array_musicas = resultado.split(";");
	
	for(var cont = 0; cont < array_musicas.length; cont++) {	
	 
	if(array_musicas[cont]) {
	
	dados_musica = array_musicas[cont].split("|");
	
	var path = dados_musica[0];
	var musica = dados_musica[1];
	var duracao = dados_musica[2];
	var duracao_segundos = dados_musica[3];
	var tipo = dados_musica[4];
	var porta = dados_musica[5];
	
	document.getElementById("msg_playlist").style.display = "none";
  
  	var lista_musicas = document.getElementById("lista-musicas-playlist");
  
  	var total_musicas = 0;
  
  	for (var i = 0; i < lista_musicas.childNodes.length; i++) {
        if (lista_musicas.childNodes[i].nodeName == "LI") {
          total_musicas++;
        }
 	}
  
  	var novo_id = (total_musicas+1);
  
  	var nova_musica = document.createElement("li");
  
  	nova_musica.setAttribute("id",novo_id);
  nova_musica.setAttribute("codigo",novo_id);
	
	if(tipo == "musica") {
	nova_musica.setAttribute("class","drag lista-musicas-playlist-musica");
	nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|musica' style='display:none' checked /><i class='fa fa-file-audio-o f-16'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", "  ")+"<span style='float:right;'><a href='javascript:play_musica(\""+porta+"\",\""+path+"\",\"musica\");' title='Play "+musica+"'><img src='/img/icones/img-icone-play.png' width='16' height='16' border='0' align='absmiddle' /></a><a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover/Remove' title='Remover' border='0' align='absmiddle' /></a></span>";
	nova_musica.style.backgroundColor = "#706d68";
	
	} else if(tipo == "vinheta") {
	nova_musica.setAttribute("class","drag lista-musicas-playlist-comercial");
	nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|vinheta' style='display:none' checked /><i class='fa fa-music f-16'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", "  ")+"<span style='float:right;'><a href='javascript:play_musica(\""+porta+"\",\""+path+"\",\"musica\");' title='Play "+musica+"'><img src='/img/icones/img-icone-play.png' width='16' height='16' border='0' align='absmiddle' /></a><a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover/Remove' border='0' align='absmiddle' /></a></span>";
	nova_musica.style.backgroundColor = "#0c0fe8";
	
	} else if(tipo == "comercial") {
	nova_musica.setAttribute("class","drag lista-musicas-playlist-comercial");
	nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|comercial' style='display:none' checked /><i class='fa fa-music f-16'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", "  ")+"<span style='float:right;'><a href='javascript:play_musica(\""+porta+"\",\""+path+"\",\"musica\");' title='Play "+musica+"'><img src='/img/icones/img-icone-play.png' width='16' height='16' border='0' align='absmiddle' /></a><a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover/Remove' border='0' align='absmiddle' /></a></span>";
	nova_musica.style.backgroundColor = "#ed3013";
	
	} else if(tipo == "intercalado") {
	nova_musica.setAttribute("class","drag lista-musicas-playlist-intercalado");
	nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|intercalado' style='display:none' checked /><i class='fa fa-retweet f-16'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", "  ")+"<span style='float:right;'><a href='javascript:play_musica(\""+porta+"\",\""+path+"\",\"musica\");' title='Play "+musica+"'><img src='/img/icones/img-icone-play.png' width='16' height='16' border='0' align='absmiddle' /></a><a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover/Remove' border='0' align='absmiddle' /></a></span>";
	nova_musica.style.backgroundColor = "#e3e3e3";
	
	} else if(tipo == "programete") {
	nova_musica.setAttribute("class","drag lista-musicas-playlist-programete");
	nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|programete' style='display:none' checked /><i class='fa fa-user-circle f-16'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", "  ")+"<span style='float:right;'><a href='javascript:play_musica(\""+porta+"\",\""+path+"\",\"programete\");' title='Play "+musica+"'><img src='/img/icones/img-icone-play.png' width='16' height='16' border='0' align='absmiddle' /></a><a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover/Remove' border='0' align='absmiddle' /></a></span>";
	nova_musica.style.backgroundColor = "#ff9f0f";
	
	} else if(tipo == "programa") {
	nova_musica.setAttribute("class","drag lista-musicas-playlist-programa");
	nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|programa' style='display:none' checked /><i class='fa fa-user-circle-o f-16'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", "  ")+"<span style='float:right;'><a href='javascript:play_musica(\""+porta+"\",\""+path+"\",\"programa\");' title='Play "+musica+"'><img src='/img/icones/img-icone-play.png' width='16' height='16' border='0' align='absmiddle' /></a><a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover/Remove' border='0' align='absmiddle' /></a></span>";
	nova_musica.style.backgroundColor = "#f7f00c";
	
  } else if (tipo == "acervo_mp3") {
	 nova_musica.setAttribute("class","drag lista-musicas-playlist-acervo");
  nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|acervo_mp3' style='display:none' checked /><i class='fa fa-star-o f-16 text-white'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", " &raquo; ")+"<a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover' border='0' align='absmiddle' /></a>";
	nova_musica.style.backgroundColor = "#b40af7";
	
	} else if(tipo == "temp" || tipo == "umd") {
	nova_musica.setAttribute("class","drag lista-musicas-playlist-acervo");
	nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|"+tipo+"' style='display:none' checked /><img src='/img/icones/img-icone-previsao-48x48.png' width='16' height='16' border='0' align='absmiddle' />&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+musica+"<span style='float:right;'><a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover/Remove' border='0' align='absmiddle' /></a></span>";
	nova_musica.style.backgroundColor = "#47f00e";
	
	} else if(tipo == "hc") {
	nova_musica.setAttribute("class","drag lista-musicas-playlist-hora-certa");
	nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|"+tipo+"' style='display:none' checked /><i class='fa fa-clock-o f-16 text-success'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+musica+"<span style='float:right;'><a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover/Remove' border='0' align='absmiddle' /></a></span>";
	nova_musica.style.backgroundColor = "#47f00e";
	
	} else {
	nova_musica.setAttribute("class","drag lista-musicas-playlist-hora-certa");
	nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|hc' style='display:none' checked /><i class='fa fa-clock-o f-16 text-success'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+musica+"<span style='float:right;'><a href='javascript:play_musica(\""+porta+"\",\""+path+"\",\"musica\");' title='Play "+musica+"'><img src='/img/icones/img-icone-play.png' width='16' height='16' border='0' align='absmiddle' /></a><a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover/Remove' border='0' align='absmiddle' /></a></span>";
	nova_musica.style.backgroundColor = "#47f00e";
	
	}  	
  
  	document.getElementById("lista-musicas-playlist").appendChild(nova_musica);
  
  	quantidade_musicas_playlist();
  
  	tempo_execucao_playlist( duracao_segundos, "adicionar" );
  
  	$("#lista-musicas-playlist").sortable({ 
		    	cancel: ".unsortable",
		    	change: function(event, ui) {
            numerar_musicas();
	        },
	        update: function(event, ui) {
	           numerar_musicas();
	        }
		});
  numerar_musicas();
	
	document.getElementById("msg_playlist_nova").style.display = "none";

	}
	
	}
	
	} else {
	
	document.getElementById("msg_playlist_nova").style.display = "block";
	
	}
	
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Funo para adicionar uma musica do FTP na playlist
function adicionar_musica_playlist( path,musica,duracao,duracao_segundos,tipo ) {
	
  if(path == "" && musica == "") {
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-danger text-center" role="alert">Error! Portugus: Dados faltando, tente novamente ou contate o suporte. English: Missing data try again or contact support. Espaol: Los datos que faltaban intntelo de nuevo o contacte con atencin.</div>';
  } else {
  
  var playlist = document.getElementById("playlist").value;
  
  document.getElementById("msg_playlist").style.display = "none";
  document.getElementById("msg_playlist_nova").style.display = "none";
  
  var lista_musicas = document.getElementById("lista-musicas-playlist");
  
  var total_musicas = 0;
  
  for (var i = 0; i < lista_musicas.childNodes.length; i++) {
        if (lista_musicas.childNodes[i].nodeName == "LI") {
          total_musicas++;
        }
  }
  
  var novo_id = (total_musicas+1);
  
  var nova_musica = document.createElement("li");
  
  nova_musica.setAttribute("id",novo_id);
  nova_musica.setAttribute("codigo",novo_id);
  
  if (tipo == "programete") {
	  nova_musica.setAttribute("class","drag lista-musicas-playlist-programete");
  nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|programete' style='display:none' checked /><i class='fa fa-user-circle f-16'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", "  ")+"<a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover' border='0' align='absmiddle' /></a>";
  
  } else if (tipo == "programa") {
	  nova_musica.setAttribute("class","drag lista-musicas-playlist-programa");
  nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|programa' style='display:none' checked /><i class='fa fa-user-circle-o f-16'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", "  ")+"<a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover' border='0' align='absmiddle' /></a>";
  
  } else if (tipo == "acervo_mp3") {
	  nova_musica.setAttribute("class","drag lista-musicas-playlist-acervo");
  nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|acervo_mp3' style='display:none' checked /><i class='fa fa-star-o f-16'></i><span class='lista-musicas-playlist-acervo'>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", " &raquo; ")+"<a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover' border='0' align='absmiddle' /></a>";
  
  } else {
  nova_musica.setAttribute("class","drag lista-musicas-playlist-musica");
  nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|musica' style='display:none' checked /><i class='fa fa-file-audio-o f-16'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", "  ")+"<a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover' border='0' align='absmiddle' /></a>";
  
  }
  
  document.getElementById("lista-musicas-playlist").appendChild(nova_musica);
  
  quantidade_musicas_playlist();
  
  tempo_execucao_playlist( duracao_segundos, "adicionar" );
  
  $("#lista-musicas-playlist").sortable({ 
		    	cancel: ".unsortable",
		    	change: function(event, ui) {
            numerar_musicas();
	        },
	        update: function(event, ui) {
	           numerar_musicas();
	        }
		});
  numerar_musicas();
  
  }  
  
}

// Funo para adicionar vinheta na playlist(intercalar uma msica)
function adicionar_vinheta( path,musica,duracao,duracao_segundos ) {
  
  var frequencia = parseInt(prompt("Informe a cada quantas msicas ser adicionada esta msica/vinheta:\nExemplo: 5"));
  
  var lista_musicas = document.getElementById("lista-musicas-playlist");
	
  var total_musicas = 0;
  
  for (var i = 0; i < lista_musicas.childNodes.length; i++) {
    if (lista_musicas.childNodes[i].nodeName == "LI") {
      total_musicas++;
    }
  }
	
  var listafilhos = lista_musicas.getElementsByTagName("li");
	
  for(i=frequencia, x=1; i<=listafilhos.length; i+=frequencia+1, x++) {
		
    if(novo_id) {
      var novo_id = (novo_id+1);
    } else {
      var novo_id = (total_musicas+1);
    }
		
    var nova_musica = document.createElement("li");
		
  	nova_musica.setAttribute("id",novo_id);
	nova_musica.setAttribute("class","drag lista-musicas-playlist-comercial");
	nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|vinheta' style='display:none' checked /><img src='/img/icones/img-icone-vinheta.png' border='0' align='absmiddle' /><span class='lista-musicas-playlist-vinheta'>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", "  ")+"</span><a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover' border='0' align='absmiddle' /></a>";
		
    if (i == listafilhos.length) {
      lista_musicas.appendChild(nova_musica);
    } else {
      lista_musicas.insertBefore(nova_musica, listafilhos[i]);
    }
	
	quantidade_musicas_playlist();
  
	tempo_execucao_playlist( duracao_segundos, "adicionar" );
	
	$("#lista-musicas-playlist").sortable({ 
		    	cancel: ".unsortable",
		    	change: function(event, ui) {
            numerar_musicas();
	        },
	        update: function(event, ui) {
	           numerar_musicas();
	        }
		});
  numerar_musicas();
	
  }
 
}
// Funo para adicionar musica na playlist numa posicao especifica
function adicionar_posicao( path,musica,duracao,duracao_segundos,tipo ) {
  
  var posicao = parseInt(prompt("Informe o nmero da msica no quadro abaixo para inserir esta nova msica aps ela:"));
  
  var lista_musicas = document.getElementById("lista-musicas-playlist");
	
  var total_musicas = 0;
  
  for (var i = 0; i < lista_musicas.childNodes.length; i++) {
    if (lista_musicas.childNodes[i].nodeName == "LI") {
      total_musicas++;
    }
  }
	
	var container = document.querySelector('#lista-musicas-playlist');
  var ref = container.querySelectorAll('li.drag[id="'+posicao+'"]');


    var novo_id = (total_musicas+1);

		
    var nova_musica = document.createElement("li");
		
  	nova_musica.setAttribute("id",novo_id);
  nova_musica.setAttribute("codigo",novo_id);
		nova_musica.setAttribute("class","drag");
		
	 if (tipo == "programete") {
	  nova_musica.setAttribute("class","drag lista-musicas-playlist-programete");
  nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|programete' style='display:none' checked /><i class='fa fa-user-circle f-16'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", "  ")+"<a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover' border='0' align='absmiddle' /></a>";
  
  } else if (tipo == "programa") {
	  nova_musica.setAttribute("class","drag lista-musicas-playlist-programa");
  nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|programa' style='display:none' checked /><i class='fa fa-user-circle-o f-16'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", "  ")+"<a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover' border='0' align='absmiddle' /></a>";
  
  } else if (tipo == "acervo_mp3") {
	  nova_musica.setAttribute("class","drag lista-musicas-playlist-acervo");
  nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|acervo_mp3' style='display:none' checked /><i class='fa fa-star-o f-16'></i><span class='lista-musicas-playlist-acervo'>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", " &raquo; ")+"<a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover' border='0' align='absmiddle' /></a>";
  
  } else {
  nova_musica.setAttribute("class","drag lista-musicas-playlist-musica");
  nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='"+path+"|"+musica+"|"+duracao+"|"+duracao_segundos+"|musica' style='display:none' checked /><i class='fa fa-file-audio-o f-16'></i>&nbsp;[<span class='numeracao' style='font-weight: bold;'></span>]["+duracao+"] "+path.replace("/", "  ")+"<a href='javascript:remover_musica(\""+novo_id+"\",\""+duracao_segundos+"\")' style='float:right;'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover' border='0' align='absmiddle' /></a>";
  
  }

	insertAfter(nova_musica, ref[0]);
	
	quantidade_musicas_playlist();
  
	tempo_execucao_playlist( duracao_segundos, "adicionar" );
	
	$("#lista-musicas-playlist").sortable({ 
		    	cancel: ".unsortable",
		    	change: function(event, ui) {
            numerar_musicas();
	        },
	        update: function(event, ui) {
	           numerar_musicas();
	        }
		});
  numerar_musicas();
	 
}
// Funo para adicionar todas as musicas do FTP na playlist
function adicionar_tudo() {
	
  var playlist = document.getElementById("playlist").value;
  
  document.getElementById("msg_playlist_nova").style.display = "none";

  var lista_musicas_pasta = document.forms["gerenciador"].elements["musicas_pasta"];
  
  for (var i = 0; i < lista_musicas_pasta.length; i++) {
  
  var path = lista_musicas_pasta[i].value;
  
  var musica = path.split("/");
  
  var duracao = lista_musicas_pasta[i].getAttribute('duracao');
  var duracao_segundos = lista_musicas_pasta[i].getAttribute('duracao_segundos');
  var tipo = lista_musicas_pasta[i].getAttribute('tipo');
  
  adicionar_musica_playlist( path,musica[1],duracao,duracao_segundos,tipo );
  
  }
  
}

// Funo para remover uma msica de uma playlist
function remover_musica( id, duracao ) {
  
  // Remove a msica da lista
  document.querySelectorAll("li[codigo='"+id+"']").forEach(function(e) {
    e.parentElement.removeChild(e);
	});
  
  // Atualiza a quantidade de musicas da playlist
  quantidade_musicas_playlist();
  

  // Remove o tempo da musica
  tempo_execucao_playlist( duracao, "remover" );

  numerar_musicas();

}

// Funo para remover uma playlist
function remover_playlist( playlist ) {
	
  if(window.confirm("Portugus: Deseja remover a playlist e todas as suas msicas?\n\nEnglish: Want to remove the playlist and all your songs?\n\nEspaol: Quieres eliminar la lista de reproduccin y todas sus canciones?")) {
  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/remover_playlist/"+playlist , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;	
	$('#' + $.escapeSelector(playlist)).remove();
	$("#local-status-acoes").delay(15000).fadeOut(300);
	
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Funo para limpar a lista de msicas
function limpar_lista_musicas( local ) {

  if(local == "ftp") {
  
  document.getElementById("lista-musicas-pasta").innerHTML = "";
  document.getElementById("msg_pasta").style.display = "block";
  
  } else {
  
  document.getElementById("lista-musicas-playlist").innerHTML = "";
  document.getElementById("msg_playlist").style.display = "block";
    
  quantidade_musicas_playlist();
  
  document.getElementById("tempo").value = 0;
	
  document.getElementById("tempo_playlist").innerHTML = "00:00:00";
  
  }
  
}

// Funo para contar a quantidade de msicas na playlist
function quantidade_musicas_playlist() {

  var total_musicas = $('ul#lista-musicas-playlist li').length;
  $('#quantidade_musicas_playlist').html(total_musicas);

}

// Funo para calcular o tempo de execuo da playlist
function tempo_execucao_playlist( duracao, operacao ) {
	
	var tempo_atual = document.getElementById("tempo").value;
	
	if(operacao == "adicionar") {
	var novo_tempo = Number(tempo_atual)+Number(duracao);
	} else {
	var novo_tempo = Number(tempo_atual)-Number(duracao);
	}
	
	document.getElementById("tempo").value = novo_tempo;
	
	document.getElementById("tempo_playlist").innerHTML = s2time(novo_tempo);

}

// Funo para iniciar transmisso de uma playlist pelo gerenciador de playlists
function iniciar_playlist( playlist ) {
	
  if(playlist == "") {
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-danger text-center" role="alert">Error! Portugus: Dados faltando, tente novamente ou contate o suporte. English: Missing data try again or contact support. Espaol: Los datos que faltaban intntelo de nuevo o contacte con atencin.</div>';
  } else {
  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/iniciar_playlist/"+playlist , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;
	$("#local-status-acoes").delay(15000).fadeOut(300);	
	
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Funo para remover a configurao do Hora Certa
function remover_hora_certa_playlist( playlist ) {
	
  if(playlist == "") {
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-danger text-center" role="alert">Error! Portugus: Dados faltando, tente novamente ou contate o suporte. English: Missing data try again or contact support. Espaol: Los datos que faltaban intntelo de nuevo o contacte con atencin.</div>';
  } else {
  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/remover_hora_certa_playlist/"+playlist , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;
	$("#local-status-acoes").delay(15000).fadeOut(300);	
	window.location.reload();
	
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Funo para remover a configurao de Vinhetas & Comerciais
function remover_vinhetas_comerciais_playlist( playlist ) {
	
  if(playlist == "") {
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-danger text-center" role="alert">Error! Portugus: Dados faltando, tente novamente ou contate o suporte. English: Missing data try again or contact support. Espaol: Los datos que faltaban intntelo de nuevo o contacte con atencin.</div>';
  } else {
  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/remover_vinhetas_comerciais_playlist/"+playlist , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;
	$("#local-status-acoes").delay(15000).fadeOut(300);	
	window.location.reload();	
	
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Funo para misturar as musicas da playlist
function shuffle(items)
{
    var cached = items.slice(0), temp, i = cached.length, rand;
    while(--i)
    {
        rand = Math.floor(i * Math.random());
        temp = cached[rand];
        cached[rand] = cached[i];
        cached[i] = temp;
    }
    return cached;
}
function misturar_musicas( local ) {

if(window.confirm("Tem certeza?\nAre you sure?\nEst seguro?")) {

var list = document.getElementById(local);

var nodes = list.children, i = 0;
    nodes = Array.prototype.slice.call(nodes);
    nodes = shuffle(nodes);
    while(i < nodes.length)
    {
        list.appendChild(nodes[i]);
        ++i;
    }
}

}

// Funo para salvar a playlist
function salvar_playlist() {
  
  var playlist = document.getElementById("playlist").value;
  
  if(playlist == "") {  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-danger text-center" role="alert">Error! Portugus: Dados faltando, tente novamente ou contate o suporte. English: Missing data try again or contact support. Espaol: Los datos que faltaban intntelo de nuevo o contacte con atencin.</div>';
  } else {
  
  document.getElementById("log-sistema-conteudo").innerHTML = '<img src="/img/ajax-loader.gif" />';
  $('#log-sistema').modal('show');
  
  document.gerenciador.submit();
  }

}

// Funo para duplicar(copiar) uma playlist
function duplicar_playlist( playlist ) {
  
  var playlist_nova = document.getElementById("nome-duplicar-playlist").value;
	
  if(playlist_nova != "" && playlist_nova != null) {
  
  document.getElementById("duplicar-playlist-conteudo").innerHTML = "<img src='/img/ajax-loader.gif' />";	
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/duplicar_playlist/"+playlist+"/"+playlist_nova+"" , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;
	$('#duplicar-playlist').modal('hide');
	$("#local-status-acoes").delay(15000).fadeOut(300);	
	window.location.reload();
	
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Funo para carregar player da musica(previa)
function play_musica( porta, musica, tipo ) {
	
  if(porta != "" && musica != null) {
  
  document.getElementById("log-sistema-conteudo").innerHTML = '<img src="/img/ajax-loader.gif" />';
  $('#log-sistema').modal('show');
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/play_musica/"+porta+"/"+tipo+"/"+musica , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;

	document.getElementById("log-sistema-conteudo").innerHTML = resultado;
	
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Funo para obter o host
function get_host() {

var url = location.href;
url = url.split("/");

return url[2];

}

// Funo Drag&Drop para organizar as msicas da playlist
var zxcMseX, zxcMseY;

function zxcMove(event, zxcobj){
    var tgt;
    if (!event) var event = window.event;
    if (event.target) tgt = event.target;
    else if (event.srcElement) tgt = event.srcElement;
    if (tgt.nodeType == 3) tgt = tgt.parentNode;
    if (tgt.tagName != 'A' && tgt.tagName != 'IMG')
    {
        var zxcels = zxcobj.parentNode.getElementsByTagName(zxcobj.tagName);

        zxcobj.ary = [];    
        for (var zxc0 = 0; zxc0 < zxcels.length; zxc0++)
        {
            zxcobj.ary.push(zxcels[zxc0]);
        }
    
        zxcMseDown(event, zxcobj);
    }
}

function zxcMseDown(event, obj)
{
    document.onmousemove = function(event)
    {
        zxcDrag(event);
    }
    document.onmouseup = function(event)
    {
        zxcMseUp(event);
    }
    document.onselectstart = function(event)
    {
        window.event.returnValue = false;
    }
    
    zxcObj = obj;
    zxcObj.style.zIndex = 1;
    
    zxcMse(event);
    zxcDragY = zxcMseY;
}

function zxcMseUp(event)
{
    zxcObj.style.zIndex = 0;
    
    document.onmousemove = null;
    document.onselectstart = null;
    
    zxcDragX = -1;
    zxcDragY = -1;
    
    zxcRePos();
}

function zxcDrag(event)
{
    zxcMse(event);
    zxcObj.style.top = ((zxcMseY - zxcDragY)) + 'px';
}

function zxcMse(event)
{
    if (!event)
        var event = window.event;

    if (document.all)
    {
        zxcMseX = event.clientX+zxcDocS()[0];
        zxcMseY = event.clientY+zxcDocS()[1];
    }
    else
    {
        zxcMseX = event.pageX;
        zxcMseY = event.pageY;
    }
}

function zxcDocS()
{
    var zxcsx, zxcsy;
    
    if (!document.body.scrollTop)
    {
        zxcsx = document.documentElement.scrollLeft;
        zxcsy = document.documentElement.scrollTop;
    }
    else
    {
        zxcsx = document.body.scrollLeft;
        zxcsy = document.body.scrollTop;
    }
    
    return [zxcsx,zxcsy];
}

function zxcRePos()
{
    if (zxcObj.parentNode)
    {
        var zxcpar = zxcObj.parentNode;
        var zxccloneary = [];
    
        for (var zxc0 = 0; zxc0 < zxcObj.ary.length; zxc0++)
        {
            zxccloneary.push([zxcObj.ary[zxc0].cloneNode(true), zxcObj.ary[zxc0].offsetTop]);
        }

        for (var zxc1 = 0; zxc1 < zxcObj.ary.length; zxc1++)
        {
            zxcpar.removeChild(zxcObj.ary[zxc1]);
        }
    
        zxccloneary = zxccloneary.sort(zxcSortPos);
    
        for (var zxc2 = 0; zxc2 < zxccloneary.length; zxc2++)
        {
            zxcpar.appendChild(zxccloneary[zxc2][0]);
            zxccloneary[zxc2][0].style.top = '0px';
        }
    
        setListeners();
    }
}

function zxcSortPos(zxca, zxcb)
{
    var zxcA = zxca[1];
    var zxcB = zxcb[1];
    
    if (zxcA < zxcB)
    {
        return -1;
    }
    
    if (zxcA > zxcB)
    {
        return 1;
    }
    
    return 0;
}

function setListeners()
{
    var item = document.getElementsByClassName("drag");
    
    for (var i = 0; i < item.length; i++)
    {
        if (item[i].addEventListener)
        {
            item[i].addEventListener ("mousedown", function (e) { zxcMove(e, this); }, false);
        }
        else if (item[i].attachEvent)
        {
            item[i].attachEvent ("onmousedown", function (e) { zxcMove(e, this); });
        }
    }
    numerar_musicas();
}

// Funes gerenciamento de progremetes

// Funo para carregar as pastas de programetes
function carregar_pastas_programetes( porta ) {
  
  // Limpa a lista de pastas j carregadas
  document.getElementById("lista-pastas").innerHTML = "";
  
  document.getElementById("status_lista_pastas").innerHTML = "<img src='http://"+get_host()+"/img/ajax-loader.gif' />";
  document.getElementById("status_lista_pastas").style.display = "block";
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/carregar_pastas_programetes/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	if(resultado) {
	
	array_pastas = resultado.split(";");
	
	for(var cont = 0; cont < array_pastas.length; cont++) {	
	 
	if(array_pastas[cont]) {
	
	dados_pasta = array_pastas[cont].split("|");
	
	var nova_pasta = document.createElement("li");
	
	nova_pasta.innerHTML = "<i class='fa fa-folder-open f-16 text-danger'></i>&nbsp;<a href='javascript:carregar_programetes_pasta(\""+porta+"\",\""+dados_pasta[0]+"\");'>"+dados_pasta[0]+"&nbsp;("+dados_pasta[1]+")</a>";
  
    document.getElementById("lista-pastas").appendChild(nova_pasta);
	
	document.getElementById("status_lista_pastas").style.display = "none";
	
	}
	
	}
	
	}
  
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para carregar os programetes da pasta de programetes
function carregar_programetes_pasta( porta,pasta ) {
	
  // Limpa a lista de msicas j carregadas
  document.getElementById("lista-musicas-pasta").innerHTML = "";  
  document.getElementById("status_lista_musicas").style.display = "block";  
  document.getElementById("msg_pasta").style.display = "none";
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/carregar_programetes_pasta/"+porta+"/"+pasta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("status_lista_musicas").style.display = "none";
	
	if(resultado) {
	
	array_musicas = resultado.split(";");
	
	for(var cont = 0; cont < array_musicas.length; cont++) {	
	 
	if(array_musicas[cont]) {
	
	dados_musica = array_musicas[cont].split("|");
	
	var nova_musica = document.createElement("li");
	
	var nome = dados_musica[0];
	var duracao = dados_musica[1];
	var duracao_segundos = dados_musica[2];

	var path_musica = ""+pasta+"/"+nome+"";
		
	nova_musica.innerHTML = "<input id='musicas_pasta' tipo='programete' duracao='"+duracao+"' duracao_segundos='"+duracao_segundos+"' type='checkbox' value='"+path_musica+"' style='display:none' checked /><img src='/img/icones/img-icone-programetes-48x48.png' width='16' height='16' border='0' align='absmiddle' />&nbsp;<a href='javascript:adicionar_musica_playlist(\""+path_musica+"\",\""+nome+"\",\""+duracao+"\",\""+duracao_segundos+"\",\"programete\");'>["+duracao+"] "+nome+"</a><span style='float:right;'><a href='javascript:download_musica(\""+porta+"\",\""+path_musica+"\",\"programete\");' title='Download "+nome+"'><img src='/img/icones/img-icone-download-mp3.png' width='16' height='16' border='0' align='absmiddle' /></a><a href='javascript:adicionar_posicao(\""+path_musica+"\",\""+nome+"\",\""+duracao+"\",\""+duracao_segundos+"\",\"programete\");' title='Adicionar na Posi&ccedil;&atilde;o/Add on Position' style='padding-right:5px;'><img src='/img/icones/img-icone-inserir-posicao.png' width='16' height='16' alt='Adicionar na Posi&ccedil;&atilde;o/Add on Position' border='0' align='absmiddle' /></a><a href='javascript:play_musica(\""+porta+"\",\""+path_musica+"\",\"programete\");' title='Play "+nome+"'><img src='/img/icones/img-icone-play.png' width='16' height='16' border='0' align='absmiddle' /></a><a href='javascript:adicionar_vinheta(\""+path_musica+"\",\""+nome+"\",\""+duracao+"\",\""+duracao_segundos+"\");' title='Intercalar/Interleave'><img src='/img/icones/img-icone-vinheta.png' width='16' height='16' alt='Intercalar/Interleave' border='0' align='absmiddle' /></a>";
  
    document.getElementById("lista-musicas-pasta").appendChild(nova_musica);
	
	}
	
	}
	
	} else {

	document.getElementById("msg_pasta").innerHTML = "A pasta selecionada no possui programetes.";
	document.getElementById("msg_pasta").style.display = "block";
	
	}
  
  }
  
  }
  http.send(null);
  delete http;
}

// Funes gerenciamento de programas

// Funo para carregar as pastas de programas
function carregar_pastas_programas( porta ) {
  
  // Limpa a lista de pastas j carregadas
  document.getElementById("lista-pastas").innerHTML = "";
  
  document.getElementById("status_lista_pastas").innerHTML = "<img src='http://"+get_host()+"/img/ajax-loader.gif' />";
  document.getElementById("status_lista_pastas").style.display = "block";
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/carregar_pastas_programas/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	if(resultado) {
	
	array_pastas = resultado.split(";");
	
	for(var cont = 0; cont < array_pastas.length; cont++) {	
	 
	if(array_pastas[cont]) {
	
	dados_pasta = array_pastas[cont].split("|");
	
	var nova_pasta = document.createElement("li");
	
	nova_pasta.innerHTML = "<i class='fa fa-folder-open f-16 text-danger'></i>&nbsp;<a href='javascript:carregar_programas_pasta(\""+porta+"\",\""+dados_pasta[0]+"\");'>"+dados_pasta[0]+"&nbsp;("+dados_pasta[1]+")</a>";
  
    document.getElementById("lista-pastas").appendChild(nova_pasta);
	
	document.getElementById("status_lista_pastas").style.display = "none";
	
	}
	
	}
	
	}
  
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para carregar os programas da pasta de programas
function carregar_programas_pasta( porta,pasta ) {
	
  // Limpa a lista de msicas j carregadas
  document.getElementById("lista-musicas-pasta").innerHTML = "";  
  document.getElementById("status_lista_musicas").style.display = "block";  
  document.getElementById("msg_pasta").style.display = "none";
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/carregar_programas_pasta/"+porta+"/"+pasta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("status_lista_musicas").style.display = "none";
	
	if(resultado) {
	
	array_musicas = resultado.split(";");
	
	for(var cont = 0; cont < array_musicas.length; cont++) {	
	 
	if(array_musicas[cont]) {
	
	dados_musica = array_musicas[cont].split("|");
	
	var nova_musica = document.createElement("li");
	
	var nome = dados_musica[0];
	var duracao = dados_musica[1];
	var duracao_segundos = dados_musica[2];

	var path_musica = ""+pasta+"/"+nome+"";
		
	nova_musica.innerHTML = "<input id='musicas_pasta' tipo='programa' duracao='"+duracao+"' duracao_segundos='"+duracao_segundos+"' type='checkbox' value='"+path_musica+"' style='display:none' checked /><img src='/img/icones/img-icone-programas-48x48.png' width='16' height='16' border='0' align='absmiddle' />&nbsp;<a href='javascript:adicionar_musica_playlist(\""+path_musica+"\",\""+nome+"\",\""+duracao+"\",\""+duracao_segundos+"\",\"programa\");'>["+duracao+"] "+nome+"</a><span style='float:right;'><a href='javascript:download_musica(\""+porta+"\",\""+path_musica+"\",\"programa\");' title='Download "+nome+"'><img src='/img/icones/img-icone-download-mp3.png' width='16' height='16' border='0' align='absmiddle' /></a><a href='javascript:adicionar_posicao(\""+path_musica+"\",\""+nome+"\",\""+duracao+"\",\""+duracao_segundos+"\",\"programa\");' title='Adicionar na Posi&ccedil;&atilde;o/Add on Position' style='padding-right:5px;'><img src='/img/icones/img-icone-inserir-posicao.png' width='16' height='16' alt='Adicionar na Posi&ccedil;&atilde;o/Add on Position' border='0' align='absmiddle' /></a><a href='javascript:play_musica(\""+porta+"\",\""+path_musica+"\",\"programa\");' title='Play "+nome+"'><img src='/img/icones/img-icone-play.png' width='16' height='16' border='0' align='absmiddle' /></a><a href='javascript:adicionar_vinheta(\""+path_musica+"\",\""+nome+"\",\""+duracao+"\",\""+duracao_segundos+"\");' title='Intercalar/Interleave'><img src='/img/icones/img-icone-vinheta.png' width='16' height='16' alt='Intercalar/Interleave' border='0' align='absmiddle' /></a>";
  
    document.getElementById("lista-musicas-pasta").appendChild(nova_musica);
	
	}
	
	}
	
	} else {

	document.getElementById("msg_pasta").innerHTML = "A pasta selecionada no possui programas.";
	document.getElementById("msg_pasta").style.display = "block";
	
	}
  
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para remover a configurao da previsao
function remover_previsao_playlist( playlist,tipo ) {
	
  if(playlist == "") {
  alert("Oops! Ocorreu um erro ao processar sua requisio!\n\nContate o suporte para maiores detalhes\n\nErro: Dados faltando.");
  } else {
  
  document.getElementById('log-sistema-conteudo').innerHTML = "<img src='http://"+get_host()+"/img/ajax-loader.gif' />";
  document.getElementById('log-sistema-fundo').style.display = "block";
  document.getElementById('log-sistema').style.display = "block";
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/remover_previsao_playlist/"+playlist+"/"+tipo , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("log-sistema-conteudo").innerHTML = resultado;	
	
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Funo para download de programetes ou programas
function download_musica( porta, musica, tipo ) {
	
  if(porta != "" && musica != null) {
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/download_musica/"+porta+"/"+tipo+"/"+musica , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
  var regex = /(http|https):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
  if(!regex .test(resultado)) {
	  
  document.getElementById("log-sistema-conteudo").innerHTML = resultado;
  
  } else {
	window.open(resultado,'conteudo');
  }
  
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Funções gerenciamento de acervo_mp3

// Função para carregar as pastas da acervo_mp3
function carregar_pastas_acervo_mp3( porta ) {
  
  // Limpa a lista de playlist já carregadas
  document.getElementById("lista-pastas").innerHTML = "";
  
  document.getElementById("status_lista_pastas").innerHTML = "<img src='https://"+get_host()+"/img/ajax-loader.gif' />";
  document.getElementById("status_lista_pastas").style.display = "block";
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/carregar_pastas_acervo_mp3/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	if(resultado) {
	
	array_pastas = resultado.split(";");
	
	for(var cont = 0; cont < array_pastas.length; cont++) {	
	 
	if(array_pastas[cont]) {
	
	dados_pasta = array_pastas[cont].split("|");
	
	var nova_pasta = document.createElement("li");
	
	nova_pasta.innerHTML = "<i class='fa fa-folder-open f-16 text-danger'></i>&nbsp;<a href='javascript:carregar_acervo_mp3_pasta(\""+porta+"\",\""+dados_pasta[0]+"\");'>"+dados_pasta[0]+"&nbsp;("+dados_pasta[1]+")</a>";
  
    document.getElementById("lista-pastas").appendChild(nova_pasta);
	
	document.getElementById("status_lista_pastas").style.display = "none";
	
	}
	
	}
	
	}
  
  }
  
  }
  http.send(null);
  delete http;
}

// Função para carregar os audios da pasta de acervo_mp3
function carregar_acervo_mp3_pasta( porta,pasta ) {
	
  // Limpa a lista de músicas já carregadas
  document.getElementById("lista-musicas-pasta").innerHTML = "";  
  document.getElementById("status_lista_musicas").style.display = "block";  
  document.getElementById("msg_pasta").style.display = "none";
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/carregar_acervo_mp3_pasta/"+porta+"/"+pasta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("status_lista_musicas").style.display = "none";
	
	if(resultado) {
	
	array_musicas = resultado.split(";");
	
	for(var cont = 0; cont < array_musicas.length; cont++) {	
	 
	if(array_musicas[cont]) {
	
	dados_musica = array_musicas[cont].split("|");
	
	var nova_musica = document.createElement("li");
	
	var nome = dados_musica[0];
	var duracao = dados_musica[1];
	var duracao_segundos = dados_musica[2];

	var path_musica = ""+pasta+"/"+nome+"";
		
	nova_musica.innerHTML = "<input id='musicas_pasta' tipo='acervo_mp3' duracao='"+duracao+"' duracao_segundos='"+duracao_segundos+"' type='checkbox' value='"+path_musica+"' style='display:none' checked /><img src='/img/icones/img-icone-estrela-48x48.png' width='16' height='16' border='0' align='absmiddle' />&nbsp;<a href='javascript:adicionar_musica_playlist(\""+path_musica+"\",\""+nome+"\",\""+duracao+"\",\""+duracao_segundos+"\",\"acervo_mp3\");'>["+duracao+"] "+nome+"</a><span style='float:right;'><a href='javascript:download_musica(\""+porta+"\",\""+path_musica+"\",\"acervo_mp3\");' title='Download "+nome+"'><img src='/img/icones/img-icone-download-mp3.png' width='16' height='16' border='0' style='padding-right:5px;' align='absmiddle' /></a><a href='javascript:adicionar_posicao(\""+path_musica+"\",\""+nome+"\",\""+duracao+"\",\""+duracao_segundos+"\",\"acervo_mp3\");' title='Adicionar na Posi&ccedil;&atilde;o/Add on Position' style='padding-right:5px;'><img src='/img/icones/img-icone-inserir-posicao.png' width='16' height='16' alt='Adicionar na Posi&ccedil;&atilde;o/Add on Position' border='0' align='absmiddle' /></a><a href='javascript:play_musica(\""+porta+"\",\""+path_musica+"\",\"acervo_mp3\");' title='Play "+nome+"'><img src='/img/icones/img-icone-relay.png' width='16' height='16' border='0' style='padding-right:5px;' align='absmiddle' /></a><a href='javascript:adicionar_vinheta(\""+path_musica+"\",\""+nome+"\",\""+duracao+"\",\""+duracao_segundos+"\");' title='Intercalar/Interleave' style='padding-right:5px;'><img src='/img/icones/img-icone-vinheta.png' width='16' height='16' alt='Intercalar/Interleave' border='0' align='absmiddle' /></a>";
  
    document.getElementById("lista-musicas-pasta").appendChild(nova_musica);
	
	
	}
	
	}
	
	} else {

	document.getElementById("msg_pasta").innerHTML = "A pasta selecionada não possui audios.";
	document.getElementById("msg_pasta").style.display = "block";
	
	}
  
  }
  
  }
  http.send(null);
  delete http;
}
// Funo para as msicas na playlist
function numerar_musicas() {
  
  var contagem = 1;

	var container = document.querySelector('#lista-musicas-playlist');
  var listItems = container.querySelectorAll('li.drag');

  for(var i = 0; i < listItems.length; i++) {

	  listItems[i].setAttribute("id",contagem);

	  var listItemspan = listItems[i].querySelector('span.numeracao');

	  listItemspan.innerHTML = contagem;
	  listItemspan.setAttribute("id",contagem);
	  contagem++;
	}


}
function insertAfter(el, referenceNode) {
    referenceNode.parentNode.insertBefore(el, referenceNode.nextSibling);
}


// Funo para adicionar hora certa na playlist
function adicionar_hora_certa(porta) {

	$('#form_hora_certa').modal('hide');

	var voz = $('#hora_certa_voz').val();
	var voz_formatada = voz[0].toUpperCase() + voz.slice(1);
	var tipo_posicao = $('input[name="hora_certa_tipo"]:checked').val();

  var lista_musicas = document.getElementById("lista-musicas-playlist");
	
  var total_musicas = 0;
  
  for (var i = 0; i < lista_musicas.childNodes.length; i++) {
    if (lista_musicas.childNodes[i].nodeName == "LI") {
      total_musicas++;
    }
  }

  var novo_id = (total_musicas+1);

  var nova_musica = document.createElement("li");
  
  nova_musica.setAttribute("id",novo_id);
  nova_musica.setAttribute("codigo",novo_id);
  nova_musica.setAttribute("class","drag lista-musicas-playlist-hora-certa");

	if(tipo_posicao == "final") {

	nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='/home/streaming/hora_certa/"+porta+"_"+voz+".mp3|Hora Certa Voz "+voz_formatada+"|00:00:05|5|hc' style='display:none' checked /><img src='/img/icones/img-icone-hora-certa.png' border='0' align='absmiddle' />[<span class='numeracao' style='font-weight: bold;;'></span>][00:00:05] Hora Certa Voz "+voz_formatada+"</span><span style='float:right;'><a href='javascript:remover_musica(\""+novo_id+"\",\"5\")'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover/Remove' border='0' align='absmiddle' /></a>";

	document.getElementById("lista-musicas-playlist").appendChild(nova_musica);

	} else {

	var posicao = $('#hora_certa_posicao').val();
	
	var container = document.querySelector('#lista-musicas-playlist');
  var ref = container.querySelectorAll('li.drag[id="'+posicao+'"]');
		
	nova_musica.innerHTML = "<input name='musicas_adicionadas[]' type='checkbox' value='/home/streaming/hora_certa/"+porta+"_"+voz+".mp3|Hora Certa Voz "+voz_formatada+"|00:00:05|5|hc' style='display:none' checked /><img src='/img/icones/img-icone-hora-certa.png' border='0' align='absmiddle' />[<span class='numeracao' style='font-weight: bold;;'></span>][00:00:05] Hora Certa Voz "+voz_formatada+"</span><span style='float:right;'><a href='javascript:remover_musica(\""+novo_id+"\",\"5\")'><img src='/img/icones/img-icone-fechar.png' width='16' height='16' alt='Remover' title='Remover/Remove' border='0'  align='absmiddle' /></a>";
  
  insertAfter(nova_musica, ref[0]);
  }

	quantidade_musicas_playlist();
  
	tempo_execucao_playlist( 5, "adicionar" );
	
	setListeners();
	 
}
// Rotina AJAX
function Ajax() {
var req;

try {
 req = new ActiveXObject("Microsoft.XMLHTTP");
} catch(e) {
 try {
	req = new ActiveXObject("Msxml2.XMLHTTP");
 } catch(ex) {
	try {
	 req = new XMLHttpRequest();
	} catch(exc) {
	 alert("Esse browser no tem recursos para uso do Ajax");
	 req = null;
	}
 }
}

return req;
}
