<?php
use WHMCS\Database\Capsule;

function subrevendastm_configoptions(){
    
    $configarray = array(
        'Streamings' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Numero maximo de contas. Ex.: 100)'
        ),
        'Ouvintes' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Numero maximo de ouvintes. Ex.: 100)'
        ),
        'Bitrate' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Verifique limite de seu plano)'
        ),
        'Espaco AutoDJ' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Espaco para FTP em megabytes)'
        ),
        'AAC+ RTMP' => array(
            'Type' => 'dropdown',
            'Options' => 'sim,nao',
            'Description' => '<br>(Verifique se esta ativado em seu plano)'
        ),
        'Idioma' => array(
            'Type' => 'dropdown',
            'Options' => 'pt-br,en-us,es',
            'Description' => '<br>(Idioma Painel - Portugues/English/Espanol)'
        ),
        'Subrevendas' => array(
            'Type' => 'text',
            'Size' => '10',
            'Description' => '<br>(Numero maximo de subrevendas. Ex.: 10)'
        )
    );
    
    return $configarray;
    
}

function subrevendastm_adminlink($params){
    $code = '<input type="button" value="Acessar Painel" onclick="window.location = \'http://' . $params['serverhostname'] . '/admin\';">';
    return $code;
}

function subrevendastm_createaccount($params){
    
    global $debug;
      
  $parametros = array(
    'table' => 'tblcustomfields',
    'value' => 'id',
    'condition' => array("fieldname" => "ID", "relid" => $params['packageid'])
  );
  
  $data = subrevendastm_select($parametros);

  if(empty($data)){
    $return = 'O campo adicional "ID" no existe.<br>Crie um campo adicional com o nome "Porta" em Products/Services';
    return $return;
  }
  
    $CustomFieldID = $data;

  $parametros = array(
    'table' => 'tblcustomfieldsvalues',
    'value' => 'value',
    'condition' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'])
  );
  
  $data = subrevendastm_select($parametros);

    if(empty($data)){
    $parametros = array(
      'table' => 'tblcustomfieldsvalues',
      'insert_array' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'], "value" => '')
    );
    subrevendastm_insert($parametros);
    }
  
    $ID = $data;

    if (!empty($ID)){
    $return = 'Esta revenda j esta criada.';
    return $return;
    }


  $subrevendastm_api['acao'] = 'cadastrar_subrevenda';
  $subrevendastm_api['streamings'] = $params['configoption1'];
  $subrevendastm_api['ouvintes'] = $params['configoption2'];
  $subrevendastm_api['bitrate'] = $params['configoption3'];
  $subrevendastm_api['espaco'] = $params['configoption4'];
  $subrevendastm_api['aacplus'] = $params['configoption5'];
  $subrevendastm_api['idioma'] = $params['configoption6'];
  $subrevendastm_api['email'] = $params['clientsdetails']['email'];
  $subrevendastm_api['senha'] = substr(md5("acegikmoqsuxywz".time()),0,12);
  $subrevendastm_api['subrevendas'] = $params['configoption7'];
  
    $response = subrevendastm_api ($params['serverhostname'],$params['serveraccesshash'],$subrevendastm_api);
  
    if ($response['command'] == 'success'){
    
    $ID = $response['returned'];

    $parametros = array(
      'table' => 'tblhosting',
      'condition' => array("id" => $params['accountid']),
      'update_data' => array("username" => $ID, "password" => encrypt ($subrevendastm_api['senha']))
    );
    subrevendastm_update($parametros);
      
    $parametros = array(
      'table' => 'tblcustomfields',
      'value' => 'id',
      'condition' => array("fieldname" => "ID", "relid" => $params['packageid'])
    );
    $data = subrevendastm_select($parametros);
    
    $dados_customfield = $data;

    
    $parametros = array(
      'table' => 'tblcustomfieldsvalues',
      'condition' => array("fieldid" => $dados_customfield, "relid" => $params['accountid']),
      'update_data' => array("value" => $ID)
    );
    subrevendastm_update($parametros);
    
    return 'success';

    }

    return $response['error'];
}

function subrevendastm_suspendaccount ($params){

    global $debug;

  $parametros = array(
    'table' => 'tblcustomfields',
    'value' => 'id',
    'condition' => array("fieldname" => "ID", "relid" => $params['packageid'])
  );
  
  $data = subrevendastm_select($parametros);
  
  $CustomFieldID = $data;

  $parametros = array(
    'table' => 'tblcustomfieldsvalues',
    'value' => 'value',
    'condition' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'])
  );
  
  $data = subrevendastm_select($parametros);
  
  $ID = $data;

  if (empty($ID)){
    $return = 'A revenda no esta cadastrado.';
    return $return;
    }

    $subrevendastm_api['acao'] = 'bloquear_subrevenda';
    $subrevendastm_api['id'] = $ID;

    $response = subrevendastm_api ($params['serverhostname'],$params['serveraccesshash'],$subrevendastm_api);

    if ($response['command'] == 'success'){

      return 'success';

    }

    return $response['error'];

}

function subrevendastm_unsuspendaccount ($params){

    global $debug;

  $parametros = array(
    'table' => 'tblcustomfields',
    'value' => 'id',
    'condition' => array("fieldname" => "ID", "relid" => $params['packageid'])
  );
  
  $data = subrevendastm_select($parametros);
  
  $CustomFieldID = $data;

  $parametros = array(
    'table' => 'tblcustomfieldsvalues',
    'value' => 'value',
    'condition' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'])
  );
  
  $data = subrevendastm_select($parametros);
  
  $ID = $data;

  if (empty($ID)){
    $return = 'A revenda no esta cadastrado.';
    return $return;
    }

    $subrevendastm_api['acao'] = 'desbloquear_subrevenda';
    $subrevendastm_api['id'] = $ID;

    $response = subrevendastm_api ($params['serverhostname'],$params['serveraccesshash'],$subrevendastm_api);

    if ($response['command'] == 'success'){
      return 'success';
    }
  
    return $response['error'];

  }

function subrevendastm_terminateaccount ($params){

    global $debug;

  $parametros = array(
    'table' => 'tblcustomfields',
    'value' => 'id',
    'condition' => array("fieldname" => "ID", "relid" => $params['packageid'])
  );
  
  $data = subrevendastm_select($parametros);
  
  $CustomFieldID = $data;

  $parametros = array(
    'table' => 'tblcustomfieldsvalues',
    'value' => 'value',
    'condition' => array("fieldid" => $CustomFieldID, "relid" => $params['accountid'])
  );
  
  $data = subrevendastm_select($parametros);
  
  $ID = $data;

  if (empty($ID)){
    $return = 'A revenda no esta cadastrado.';
    return $return;
    }

    $subrevendastm_api['acao'] = 'remover_subrevenda';
    $subrevendastm_api['id'] = $ID;
  
    $response = subrevendastm_api ($params['serverhostname'],$params['serveraccesshash'],$subrevendastm_api);

    if ($response['command'] == 'success'){
    
    $parametros = array(
      'table'=>'tblcustomfieldsvalues',
      'condition'=>array('fieldid'=>$CustomFieldID, 'relid'=>$params['accountid'])
    );
    subrevendastm_delete($parametros);
    
    $parametros = array(
      'table' => 'tblhosting',
      'condition' => array("id" => $params['accountid']),
      'update_data' => array("username" => '', "password" => '')
    );
    subrevendastm_update($parametros);
    
    return 'success';

    }
  
    return $response['error'];

}

function subrevendastm_api($serverhostname, $serveraccesshash, $subrevendastm_api){

    $requisicao = '';
    
    foreach ($subrevendastm_api as $option => $setting) {
        if (is_array($setting)) {
            $setting = serialize($setting);
        }
        $requisicao .= $setting . "/";
    }

    $url_requisicao = "https://" . $serverhostname . "/admin/api/" . $serveraccesshash . "/" . $requisicao . "";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url_requisicao);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Modulo Streaming WHMCS 3.0 (' . $_SERVER['HTTP_HOST'] . ')');
    $resultado = curl_exec($ch);
    curl_close($ch);
    

    if ($resultado === false) {
        return array(
            'command' => 'failed',
            'error' => 'No foi possvel se conectar ao painel de controle. Debug: ' . $url_requisicao . ''
        );
    } else if (empty($resultado)) {
        return array(
            'command' => 'failed',
            'error' => 'No foi possvel se conectar ao painel de controle. Debug: ' . $url_requisicao . ''
        );
    } else {
        list($status, $porta, $msg) = explode('|', $resultado);
        if ($status == '0') {
            return array(
                'command' => 'failed',
                'error' => '' . $msg . ''
            );
        }

        return array(
            'command' => 'success',
            'returned' => '' . $porta . ''
        );
    }
}

function subrevendastm_select($parametros){
  
  $table = $parametros['table'];
  $value = $parametros['value'];
  $condition = $parametros['condition'];
  
  try {
    if(!empty($condition) && !empty($value)){
      $data = Capsule::table($table)
            ->where($condition)
            ->value($value);
            return $data;
    }else if(!empty($condition)){
      $data = Capsule::table($table)
            ->where($condition)
            ->get();
            return $data;
    }else if(!empty($value)){
      $data = Capsule::table($table)
            ->value($value);
            return $data;
    }else if(empty($condition) && empty($value)){
      $data = Capsule::table($table)
            ->get();
          return $data;
    }else{
      return "Erro na sintaxe da consulta";
    } 
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
function subrevendastm_insert($parametros){
  
  $table = $parametros['table'];
  $insert_array = $parametros['insert_array'];
  
  try {
    Capsule::table($table)
      ->insert($insert_array);
    return true;
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
function subrevendastm_update($parametros){
  
  $table = $parametros['table'];
  $condition = $parametros['condition'];
  $update_data = $parametros['update_data'];
  
  try {
    Capsule::table($table)
       ->where($condition)
       ->update($update_data);
    return true;   
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
function subrevendastm_delete($parametros){
  
  $table = $parametros['table'];
  $condition = $parametros['condition'];
  
  try {
    Capsule::table($table)
      ->where($condition)
      ->delete();
      return true;
  } catch(\Illuminate\Database\QueryException $ex){
    return $ex->getMessage();
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
?>