<?php
require_once("inc/protecao-admin.php");

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Administra&ccedil;&atilde;o</title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">
  <link rel="stylesheet" href="/inc/theme.css">
  <link rel="shortcut icon" href="/img/favicon.ico">
  <script type="text/javascript" src="/admin/inc/ajax.js"></script>
  <script type="text/javascript" src="/admin/inc/javascript.js"></script>
</head>

<body>
  <div class="container-scroller">
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <a class="navbar-brand brand-logo" href="/admin/admin-configuracoes"><span>Administra&ccedil;&atilde;o</span></a>
        <a class="navbar-brand brand-logo-mini" href="/admin/admin-configuracoes"><img src="/img/icones/img-icone-logo.png" title="Painel" width="32" height="32" border="0"></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <li class="nav-item nav-search d-none d-lg-block">
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text" id="search">
                  <i class="mdi mdi-magnify"></i>
                </span>
              </div>
              <input type="text" class="form-control" id="busca_chave" placeholder="Busca" aria-label="search" aria-describedby="search">
            </div>
          </li>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item">
            <a class="nav-link" href="/admin/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>

    <!-- modal -->                
      <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
      
    <div class="container-fluid page-body-wrapper">      
    <?php require_once("menu-admin.php"); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_pagina_servidores_titulo; ?></header>
                                        <div class="card-header-right">
                                            <button type="button" class="btn btn-info" onClick="window.location = '/admin/admin-cadastrar-servidor';"><i class="fa fa-file-plus"></i><?php echo lang_botao_titulo_cadastrar; ?></button>
                                        </div>
                  </div>
                <div class="card-body">
                    <table id="data_table" class="table dataTable no-footer table-hover" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_servidores_nome; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_servidores_ip; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_servidores_dominio; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_servidores_porta_ssh; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_servidores_streamings; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_servidores_load; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_servidores_trafego_rede; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_servidores_trafego_mes; ?></th>
                                                        <th><?php echo lang_pagina_pp_acoes; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
if(query_string('2') == 'resultado') {

$cat = (preg_match("/^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3}$/", query_string('3'))) ? "ip" : "nome";

$query = "SELECT * FROM servidores WHERE ".$cat." like '%".query_string('3')."%'";

} else {
$query = "SELECT * FROM servidores";
}

$sql = mysqli_query($conexao,"".$query." ORDER by ordem ASC");
while ($dados_servidor = mysqli_fetch_array($sql)) {

if($dados_servidor["tipo"] == 'aacplus') {
$total_stm = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings where codigo_servidor_aacplus = '".$dados_servidor["codigo"]."'"));
} else {
$total_stm = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings where codigo_servidor = '".$dados_servidor["codigo"]."'"));
}

if($dados_servidor["status"] == "off") {
$cor_status = "class='table-light'";
}

$servidor_code = code_decode($dados_servidor["codigo"],"E");

if($dados_servidor["tipo"] == "streaming") {

echo "<tr id='".$servidor_code."' title='Código: ".$dados_servidor["codigo"]." | Nome: ".$dados_servidor["nome"]." | IP: ".$dados_servidor["ip"]."' ".$cor_status.">
<td height='25' align='left' scope='col'>&nbsp;".$dados_servidor["nome"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_servidor["ip"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_servidor["porta_ssh"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$total_stm." / ".$dados_servidor["limite_streamings"]."</td>
<td height='25' align='left' scope='col' style='background-color:".$cor_alerta_load.";'>&nbsp;".$dados_servidor["load"]."</td>
<td height='25' align='left' scope='col' style='background-color:".$cor_alerta_trafego_out.";'>&nbsp;".$dados_servidor["trafego_out"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_servidor["trafego"]."</td>
<td height='25' align='left' scope='col'><a href='/admin/admin-configurar-servidor/".$servidor_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_servidores_acoes_configuracoes."'><i class='fa fa-pencil f-16 text-blue'></i></a>&nbsp;
<a href='javascript:ligar_streamings_autodjs_servidor(\"".$servidor_code."\",\"streaming\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_servidores_acoes_ligar_streamings."'><i class='fa fa-play f-16 text-green'></i></a>&nbsp;
<a href='javascript:ligar_streamings_autodjs_servidor(\"".$servidor_code."\",\"autodj\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_servidores_acoes_ligar_autodjs."'><i class='fa fa-forward f-16 text-green'></i></a>&nbsp;
<a href='/admin/admin-streamings/resultado-servidor/".$servidor_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_servidores_acoes_listar_streamings."'><i class='fa fa-headphones f-16 text-blue'></i></a>&nbsp;
<a href='javascript:sincronizar_aacplus_servidor(\"".$servidor_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_servidores_acoes_sincronizar_aacplus."'><i class='fa fa-refresh f-16 text-pink'></i></a>&nbsp;
<a href='javascript:sincronizar_playlists_servidor(\"".$servidor_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_servidores_acoes_sincronizar_playlists."'><i class='fa fa-refresh f-16 text-purple'></i></a>&nbsp;
<a href='/admin/admin-servidor-mover-streamings/".$servidor_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_servidores_acoes_mover_streamings."'><i class='fa fa-retweet f-16 text-pink'></i></a>&nbsp;
<a href='javascript:ativar_desativar_manutencao(\"".$servidor_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_servidores_acoes_ativar_desativar_manutencao."'><i class='fa fa-exclamation-triangle f-16 text-red'></i></a>&nbsp;
<a href='/admin/admin-manutencao-servidor/".$servidor_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_servidores_acoes_modulo_manutencao."'><i class='fa fa-cog f-16 text-yellow'></i></a></td>
</tr>";

} else {

echo "<tr id='".$servidor_code."' title='Código: ".$dados_servidor["codigo"]." | Nome: ".$dados_servidor["nome"]." | IP: ".$dados_servidor["ip"]."' ".$cor_status.">
<td height='25' align='left' scope='col'>&nbsp;".$dados_servidor["nome"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_servidor["ip"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".dominio_servidor($conexao,$dados_servidor["nome"])."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_servidor["porta_ssh"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$total_stm." / ".$dados_servidor["limite_streamings"]."</td>
<td height='25' align='left' scope='col' style='background-color:".$cor_alerta_load.";'>&nbsp;".$dados_servidor["load"]."</td>
<td height='25' align='left' scope='col' style='background-color:".$cor_alerta_trafego_out.";'>&nbsp;".$dados_servidor["trafego_out"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_servidor["trafego"]."</td>
<td height='25' align='left' scope='col'><a href='/admin/admin-configurar-servidor/".$servidor_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_servidores_acoes_configuracoes."'><i class='fa fa-pencil f-16 text-blue'></i></a>&nbsp;
<a href='javascript:sincronizar_aacplus(\"".$servidor_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_servidores_acoes_sincronizar_aacplus."'><i class='fa fa-refresh f-16 text-pink'></i></a>&nbsp;
</td>
</tr>";

}

unset($alerta_load);
unset($alerta_trafego_out);
unset($status);
}
?>
                                                </tbody>
                                            </table>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>      

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  $('#busca_chave').keypress(function (e) {
    if (e.which == 13) {
       window.location = "/admin/admin-streamings/resultado/"+document.getElementById("busca_chave").value;
    }
  }); 
        $(document).ready(function() {

            var table = $('#data_table').DataTable({
                responsive: true,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                'aoColumnDefs': [{
                    'bSortable': false,
                    'aTargets': ['nosort']
                }]
            });
            $('#data_table tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

        });
  </script>
</body>
</html>