<?php
require_once("inc/protecao-revenda.php");

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Revenda <?php echo $dados_revenda["id"]; ?></title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">
  <link rel="stylesheet" href="/inc/theme.css">
  <link rel="shortcut icon" href="/img/favicon.ico">
  <script type="text/javascript" src="/admin/inc/ajax-revenda.js"></script>
  <script type="text/javascript" src="/admin/inc/javascript.js"></script>
</head>

<body>
  <div class="container-scroller">
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <?php if($dados_revenda["url_logo"]) { ?>
        <a class="navbar-brand brand-logo" href="/admin/revenda-configuracoes"><img id="logo" src="<?php echo $dados_revenda["url_logo"]; ?>" title="Painel" height="60" border="0"></a>
        <?php } else { ?>
        <a class="navbar-brand brand-logo" href="/admin/revenda-configuracoes"><span>Painel Revenda</span></a>
        <?php } ?>
        <a class="navbar-brand brand-logo-mini" href="/admin/revenda-configuracoes"><img src="/img/icones/img-icone-logo.png" title="Painel" width="32" height="32" border="0"></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <li class="nav-item nav-search d-none d-lg-block">
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text" id="search">
                  <i class="mdi mdi-magnify"></i>
                </span>
              </div>
              <input type="text" class="form-control" id="busca_chave" placeholder="Busca" aria-label="search" aria-describedby="search">
            </div>
          </li>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item dropdown">
            <a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown" aria-expanded="false">
              <i class="mdi mdi-bell f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?>"></i>
              <?php if($total_avisos_exibir > 0) { ?><span class="count bg-success"><?php echo $total_avisos_exibir; ?></span><?php } ?>           
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
              <a class="dropdown-item">
                <p class="mb-0 font-weight-normal float-left"><?php echo lang_info_pagina_informacoes_revenda_tab_avisos; ?></p>
              </a>
              <div class="dropdown-divider"></div>
              <?php carregar_avisos_revenda($conexao); ?>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>

    <!-- modal -->
      <div class="modal fade" id="avisos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" id="avisos-conteudo"><img src="/img/ajax-loader.gif" align="center" /></div>
            </div>
        </div>
      </div>
                
      <div class="modal fade" id="playlists-autodj" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">AutoDJ</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body text-center" id="playlists-autodj-conteudo" style="text-align: center;"><img src="/img/ajax-loader.gif" /></div>
            </div>
          </div>
      </div>
                
      <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
      
    <div class="container-fluid page-body-wrapper">      
    <?php require_once("menu-revenda.php"); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_info_pagina_api_tab_titulo; ?></header>
                  </div>
                <div class="card-body">
                    <?php echo lang_info_pagina_api_info; ?><br /><br />
<input type="text" value="<?php echo $dados_revenda["chave_api"]; ?>" style="width:99%; height:30px;"  onclick="this.select()" readonly="readonly" /><br />
<br /> 
<?php echo lang_info_pagina_api_info2; ?>
<br />
<br />
<span class="texto_padrao_destaque"><?php echo lang_info_pagina_api_acao_cadastrar; ?></span><br />
<br />
<textarea readonly="readonly" style="width:99%; height:630px;"  onclick="this.select()">
// Funcao para cadastrar um streaming
// Function to create a streaming
// Funcion para agregar uno streaming
function cadastrar_streaming($chave,$ouvintes,$bitrate,$espaco,$senha,$aacplus,$idioma_painel,$app_android,$encoder_mp3,$encoder_aacplus) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://<?php echo $_SERVER['HTTP_HOST']; ?>/admin/api/".$chave."/cadastrar/".$ouvintes."/".$bitrate."/".$espaco."/".$senha."/".$aacplus."/".$idioma_painel."/".$app_android."/".$encoder_mp3."/".$encoder_aacplus."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, "API 1.0 (<?php echo $_SERVER['HTTP_HOST']; ?>)");
$resultado = curl_exec($ch);
curl_close($ch);

if($resultado === false) {
return "<?php echo lang_info_pagina_api_acao_info_erro; ?>";
} else {

list($status,$porta,$msg) = explode("|",$resultado);

if($status == 1) {
//Sucesso
return $porta;
} else {
//Erro
return $msg;
}

}

}

// Formato: chave / ouvintes / bitrate(numero apenas) / espaço autodj(megabytes) / senha / AAC+ RTMP (sim ou nao) / Idioma (pt-br / en / es) / App Android (sim ou nao) / Encoder MP3 (sim ou nao) / Encoder AACPlus (sim ou nao)
echo cadastrar_streaming("<?php echo $dados_revenda["chave_api"]; ?>","100","64","1000","xxxxxx","nao","pt-br","sim","sim","sim");

</textarea>
<br />
<br />
<span class="texto_padrao_destaque"><?php echo lang_info_pagina_api_acao_bloquear; ?></span><br />
<br />
<textarea readonly="readonly" style="width:99%; height:570px"  onclick="this.select()">
// Funcao para bloquear o streaming
// Function to suspend the streaming
// Funcion para bloquear el streaming
function bloquear_streaming($chave,$porta) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://<?php echo $_SERVER['HTTP_HOST']; ?>/admin/api/".$chave."/bloquear/".$porta."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, "API 1.0 (<?php echo $_SERVER['HTTP_HOST']; ?>)");
$resultado = curl_exec($ch);
curl_close($ch);

if($resultado === false) {
return "<?php echo lang_info_pagina_api_acao_info_erro; ?>";
} else {

list($status,$porta,$msg) = explode("|",$resultado);

if($status == 1) {
//Sucesso
return $msg;
} else {
//Erro
return $msg;
}

}

}

// Formato: chave / porta
echo bloquear_streaming("<?php echo $dados_revenda["chave_api"]; ?>","8000");

</textarea>
<br />
<br />
<span class="texto_padrao_destaque"><?php echo lang_info_pagina_api_acao_debloquear; ?></span><br />
<br />
<textarea readonly="readonly" style="width:99%; height:570px"  onclick="this.select()">
// Funcao para desbloquear o streaming
// Function to unsuspend the streaming
// Funcion para desbloquear el streaming
function desbloquear_streaming($chave,$porta) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://<?php echo $_SERVER['HTTP_HOST']; ?>/admin/api/".$chave."/desbloquear/".$porta."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, "API 1.0 (<?php echo $_SERVER['HTTP_HOST']; ?>)");
$resultado = curl_exec($ch);
curl_close($ch);

if($resultado === false) {
return "<?php echo lang_info_pagina_api_acao_info_erro; ?>";
} else {

list($status,$porta,$msg) = explode("|",$resultado);

if($status == 1) {
//Sucesso
return $msg;
} else {
//Erro
return $msg;
}

}

}

// Formato: chave / porta
echo desbloquear_streaming("<?php echo $dados_revenda["chave_api"]; ?>","8000");

</textarea>
<br />
<br />
<span class="texto_padrao_destaque"><?php echo lang_info_pagina_api_acao_alterar_senha; ?></span><br />
<br />
<textarea readonly="readonly" style="width:99%; height:570px"  onclick="this.select()">
// Funcao para alterar senha do streaming
// Function to change password of streaming
// Funcion para cambiar la contraseña de streaming
function alterar_senha($chave,$porta,$senha) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://<?php echo $_SERVER['HTTP_HOST']; ?>/admin/api/".$chave."/alterar_senha/".$porta."/".$senha."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, "API 1.0 (<?php echo $_SERVER['HTTP_HOST']; ?>)");
$resultado = curl_exec($ch);
curl_close($ch);

if($resultado === false) {
return "<?php echo lang_info_pagina_api_acao_info_erro; ?>";
} else {

list($status,$porta,$msg) = explode("|",$resultado);

if($status == 1) {
//Sucesso
return $msg;
} else {
//Erro
return $msg;
}

}

}

// Formato: chave / porta / nova senha
echo alterar_senha("<?php echo $dados_revenda["chave_api"]; ?>","8000","xxxx");

</textarea>
<br />
<br />
<span class="texto_padrao_destaque"><?php echo lang_info_pagina_api_acao_remover; ?></span><br />
<br />
<textarea readonly="readonly" style="width:99%; height:550px"  onclick="this.select()">
// Funcao para remover o streaming
// Function to remove the streaming
// Funcion para eliminar el streaming
function remover_streaming($chave,$porta) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://<?php echo $_SERVER['HTTP_HOST']; ?>/admin/api/".$chave."/remover/".$porta."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, "API 1.0 (<?php echo $_SERVER['HTTP_HOST']; ?>)");
$resultado = curl_exec($ch);
curl_close($ch);

if($resultado === false) {
return "<?php echo lang_info_pagina_api_acao_info_erro; ?>";
} else {

list($status,$porta,$msg) = explode("|",$resultado);

if($status == 1) {
//Sucesso
return $msg;
} else {
//Erro
return $msg;
}

}

}

// Formato: chave / porta
echo remover_streaming("<?php echo $dados_revenda["chave_api"]; ?>","8000");

</textarea>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>      

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  $('#busca_chave').keypress(function (e) {
    if (e.which == 13) {
       window.location = "/admin/revenda-streamings/resultado/porta/"+document.getElementById("busca_chave").value;
    }
  }); 
  </script>
</body>
</html>