/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;

public class ModuleHotlinkDenial
extends ModuleBase {
    private boolean logConnections = false;
    private boolean logRejections = true;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.logConnections = iApplicationInstance.getProperties().getPropertyBoolean("hotlinkLogConnections", this.logConnections);
        this.logRejections = iApplicationInstance.getProperties().getPropertyBoolean("hotlinkLogRejections", this.logRejections);
    }

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        if (this.logConnections) {
            ModuleHotlinkDenial.getLogger().info("ModuleHotlinkDenial onConnect: " + iClient.getClientId());
        }
        String string = iClient.getFlashVer().toLowerCase();
        if (this.logConnections) {
            ModuleHotlinkDenial.getLogger().info("ModuleHotlinkDenial Client Flashver: " + string);
        }
        try {
            String[] stringArray = null;
            stringArray = iClient.getAppInstance().getProperties().getPropertyStr("AllowEncoder", "").toLowerCase().split(",");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.startsWith(stringArray[i].trim()) || stringArray[i].length() <= 0) continue;
                    if (this.logConnections) {
                        ModuleHotlinkDenial.getLogger().info("ModuleHotlinkDenial Encoder Allowed: " + string + " matches " + stringArray[i]);
                    }
                    return;
                }
            }
        }
        catch (Exception exception) {
            ModuleHotlinkDenial.getLogger().info("ModuleHotlinkDenial Exception: " + exception.getMessage());
        }
        boolean bl = true;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string2 = "";
        try {
            stringArray = iClient.getAppInstance().getProperties().getPropertyStr("domainLock").toLowerCase().split(",");
            string2 = iClient.getProperties().getPropertyStr("connectpageUrl").toLowerCase();
            stringArray2 = string2.split("/");
            if (this.logConnections) {
                ModuleHotlinkDenial.getLogger().info("domainLock: " + iClient.getAppInstance().getProperties().getPropertyStr("domainLock").toLowerCase());
            }
            if (this.logConnections) {
                ModuleHotlinkDenial.getLogger().info("pageUrl: " + string2);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].trim().startsWith("*")) {
                    String string3 = stringArray[i].trim().substring(1);
                    if (!stringArray2[2].endsWith(string3)) continue;
                    bl = false;
                    continue;
                }
                if (!stringArray2[2].equalsIgnoreCase(stringArray[i].trim())) continue;
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            if (this.logRejections) {
                ModuleHotlinkDenial.getLogger().info("Client Rejected. IP: " + iClient.getIp() + ": domainLock: " + iClient.getAppInstance().getProperties().getPropertyStr("domainLock").toLowerCase() + ": pageUrl: " + string2);
            }
            iClient.rejectConnection();
        }
    }

    public boolean isLogConnections() {
        return this.logConnections;
    }

    public void setLogConnections(boolean bl) {
        this.logConnections = bl;
    }

    public boolean isLogRejections() {
        return this.logRejections;
    }

    public void setLogRejections(boolean bl) {
        this.logRejections = bl;
    }
}

