/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.file;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.PlaylistCursor;

public class PlaylistSeeker
implements Runnable {
    private boolean isRunning = false;
    private boolean isActive = false;
    private long location;
    private boolean newLocation = false;
    private IMediaReader flvReader = null;
    private PlaylistCursor flvCursor = null;
    private int seekType = 0;
    private IMediaStream stream = null;

    public PlaylistSeeker(IMediaStream iMediaStream, IMediaReader iMediaReader, PlaylistCursor playlistCursor) {
        this.stream = iMediaStream;
        this.flvReader = iMediaReader;
        this.flvCursor = playlistCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long l = 0L;
        PlaylistSeeker playlistSeeker = this;
        synchronized (playlistSeeker) {
            this.isRunning = true;
            l = this.location;
            this.newLocation = false;
        }
        while (true) {
            long l2 = l;
            long l3 = 0L;
            PlaylistSeekResult playlistSeekResult = this.flvReader.seek(l, this.seekType == 2 ? 1 : 3);
            if (playlistSeekResult == null) {
                l2 = 0L;
                l3 = 0L;
                this.flvReader.rewind();
                WMSLoggerFactory.getLogger(PlaylistSeeker.class).info("final seek REWIND");
            } else {
                l2 = playlistSeekResult.getResultTimecode();
                WMSLoggerFactory.getLogger(PlaylistSeeker.class).info("final seek results: " + playlistSeekResult.getResultTimecode());
            }
            PlaylistSeeker playlistSeeker2 = this;
            synchronized (playlistSeeker2) {
                if (!this.newLocation) {
                    this.isRunning = false;
                    this.isActive = false;
                    IMediaStream iMediaStream = this.stream;
                    synchronized (iMediaStream) {
                        this.flvCursor.setSeeking(false);
                        this.flvCursor.setInterruptPlay();
                        this.flvCursor.setSeekType(this.seekType);
                        this.flvCursor.addSeekType(this.seekType);
                        this.flvCursor.setSeekReqLocation(l);
                        this.flvCursor.setSeekResLocation(l2);
                        this.flvCursor.setSendAbsVideoTC(true);
                        this.flvCursor.setSendAbsBroadcastTC(true);
                        this.flvCursor.setSendAbsAudioTC(true);
                        this.flvCursor.setStartPlaying(true);
                        this.flvCursor.setFillBuffer(true);
                        return;
                    }
                }
                l = this.location;
                this.newLocation = false;
            }
        }
    }

    public synchronized void seek(long l, int n) {
        this.flvCursor.setSeeking(true);
        this.location = l;
        this.seekType = n;
    }
}

