/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.net.SocketAddress;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;

public interface IoFilter {
    public void init() throws Exception;

    public void destroy() throws Exception;

    public void onPreAdd(IoFilterChain var1, String var2, NextFilter var3) throws Exception;

    public void onPostAdd(IoFilterChain var1, String var2, NextFilter var3) throws Exception;

    public void onPreRemove(IoFilterChain var1, String var2, NextFilter var3) throws Exception;

    public void onPostRemove(IoFilterChain var1, String var2, NextFilter var3) throws Exception;

    public void sessionCreated(NextFilter var1, IoSession var2) throws Exception;

    public void sessionOpened(NextFilter var1, IoSession var2) throws Exception;

    public void sessionClosed(NextFilter var1, IoSession var2) throws Exception;

    public void sessionIdle(NextFilter var1, IoSession var2, IdleStatus var3) throws Exception;

    public void exceptionCaught(NextFilter var1, IoSession var2, Throwable var3) throws Exception;

    public void messageReceived(NextFilter var1, IoSession var2, Object var3) throws Exception;

    public void messageSent(NextFilter var1, IoSession var2, Object var3) throws Exception;

    public void filterClose(NextFilter var1, IoSession var2) throws Exception;

    public void filterWrite(NextFilter var1, IoSession var2, WriteRequest var3) throws Exception;

    public static interface NextFilter {
        public void sessionCreated(IoSession var1);

        public void sessionOpened(IoSession var1);

        public void sessionClosed(IoSession var1);

        public void sessionIdle(IoSession var1, IdleStatus var2);

        public void exceptionCaught(IoSession var1, Throwable var2);

        public void messageReceived(IoSession var1, Object var2);

        public void messageSent(IoSession var1, Object var2);

        public void filterWrite(IoSession var1, WriteRequest var2);

        public void filterClose(IoSession var1);
    }

    public static class WriteRequest {
        private static final WriteFuture UNUSED_FUTURE = new WriteFuture(){

            public boolean isWritten() {
                return false;
            }

            public void setWritten(boolean bl) {
            }

            public IoSession getSession() {
                return null;
            }

            public Object getLock() {
                return this;
            }

            public void join() {
            }

            public boolean join(long l) {
                return true;
            }

            public boolean isReady() {
                return true;
            }

            public void addListener(IoFutureListener ioFutureListener) {
                throw new IllegalStateException("You can't add a listener to a dummy future.");
            }

            public void removeListener(IoFutureListener ioFutureListener) {
                throw new IllegalStateException("You can't add a listener to a dummy future.");
            }
        };
        private final Object message;
        private final WriteFuture future;
        private final SocketAddress destination;
        private final long writeId;
        private int clientId = -1;

        public WriteRequest(Object object) {
            this(object, null, null, -1L, -1);
        }

        public WriteRequest(Object object, WriteFuture writeFuture) {
            this(object, writeFuture, null, -1L, -1);
        }

        public WriteRequest(Object object, WriteFuture writeFuture, SocketAddress socketAddress, long l) {
            this(object, writeFuture, null, l, -1);
        }

        public WriteRequest(Object object, WriteFuture writeFuture, SocketAddress socketAddress, long l, int n) {
            if (object == null) {
                throw new NullPointerException("message");
            }
            if (writeFuture == null) {
                writeFuture = UNUSED_FUTURE;
            }
            this.message = object;
            this.future = writeFuture;
            this.destination = socketAddress;
            this.writeId = l;
            this.clientId = n;
        }

        public int getClientId() {
            return this.clientId;
        }

        public void setClientId(int n) {
            this.clientId = n;
        }

        public long getWriteId() {
            return this.writeId;
        }

        public WriteFuture getFuture() {
            return this.future;
        }

        public Object getMessage() {
            return this.message;
        }

        public SocketAddress getDestination() {
            return this.destination;
        }

        public String toString() {
            return this.message.toString();
        }
    }
}

