/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.nio.ByteOrder;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.support.BaseByteBuffer;

public class SimpleByteBufferAllocator
implements ByteBufferAllocator {
    private static final int MINIMUM_CAPACITY = 1;

    public ByteBuffer allocate(int n, boolean bl) {
        java.nio.ByteBuffer byteBuffer = bl ? java.nio.ByteBuffer.allocateDirect(n) : java.nio.ByteBuffer.allocate(n);
        return new SimpleByteBuffer(byteBuffer);
    }

    public ByteBuffer wrap(java.nio.ByteBuffer byteBuffer) {
        return new SimpleByteBuffer(byteBuffer);
    }

    public void dispose() {
    }

    private static class SimpleByteBuffer
    extends BaseByteBuffer {
        private java.nio.ByteBuffer buf;
        private int refCount = 1;
        private Object extra = null;

        protected SimpleByteBuffer(java.nio.ByteBuffer byteBuffer) {
            this.buf = byteBuffer;
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            this.refCount = 1;
        }

        public synchronized void acquire() {
            if (this.refCount <= 0) {
                throw new IllegalStateException("Already released buffer.");
            }
            ++this.refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            SimpleByteBuffer simpleByteBuffer = this;
            synchronized (simpleByteBuffer) {
                if (this.refCount <= 0) {
                    this.refCount = 0;
                    throw new IllegalStateException("Already released buffer.  You released the buffer too many times.");
                }
                --this.refCount;
                if (this.refCount > 0) {
                    return;
                }
            }
        }

        public java.nio.ByteBuffer buf() {
            return this.buf;
        }

        public boolean isPooled() {
            return false;
        }

        public void setPooled(boolean bl) {
        }

        public Object getExtra() {
            return this.extra;
        }

        public void setExtra(Object object) {
            this.extra = object;
        }

        protected void capacity0(int n) {
            int n2;
            for (n2 = 1; n2 < n; n2 <<= 1) {
            }
            java.nio.ByteBuffer byteBuffer = this.buf;
            java.nio.ByteBuffer byteBuffer2 = this.isDirect() ? java.nio.ByteBuffer.allocateDirect(n2) : java.nio.ByteBuffer.allocate(n2);
            byteBuffer2.clear();
            byteBuffer.clear();
            byteBuffer2.put(byteBuffer);
            this.buf = byteBuffer2;
        }

        public ByteBuffer duplicate() {
            return new SimpleByteBuffer(this.buf.duplicate());
        }

        public ByteBuffer slice() {
            return new SimpleByteBuffer(this.buf.slice());
        }

        public ByteBuffer asReadOnlyBuffer() {
            return new SimpleByteBuffer(this.buf.asReadOnlyBuffer());
        }

        public byte[] array() {
            return this.buf.array();
        }

        public int arrayOffset() {
            return this.buf.arrayOffset();
        }
    }
}

