/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.apache.mina.common.ByteBuffer;

public abstract class BaseByteBuffer
extends ByteBuffer {
    private boolean autoExpand;
    private int mark = -1;

    protected BaseByteBuffer() {
    }

    public boolean isDirect() {
        return this.buf().isDirect();
    }

    public boolean isReadOnly() {
        return this.buf().isReadOnly();
    }

    public int capacity() {
        return this.buf().capacity();
    }

    public ByteBuffer capacity(int n) {
        if (n > this.capacity()) {
            int n2 = this.position();
            int n3 = this.limit();
            ByteOrder byteOrder = this.order();
            this.capacity0(n);
            this.buf().limit(n3);
            if (this.mark >= 0) {
                this.buf().position(this.mark);
                this.buf().mark();
            }
            this.buf().position(n2);
            this.buf().order(byteOrder);
        }
        return this;
    }

    protected abstract void capacity0(int var1);

    public boolean isAutoExpand() {
        return this.autoExpand;
    }

    public ByteBuffer setAutoExpand(boolean bl) {
        this.autoExpand = bl;
        return this;
    }

    public ByteBuffer expand(int n, int n2) {
        int n3 = n + n2;
        if (n3 > this.capacity()) {
            this.capacity(n3);
        }
        if (n3 > this.limit()) {
            this.buf().limit(n3);
        }
        return this;
    }

    public int position() {
        return this.buf().position();
    }

    public ByteBuffer position(int n) {
        this.autoExpand(n, 0);
        this.buf().position(n);
        if (this.mark > n) {
            this.mark = -1;
        }
        return this;
    }

    public int limit() {
        return this.buf().limit();
    }

    public ByteBuffer limit(int n) {
        this.autoExpand(n, 0);
        this.buf().limit(n);
        if (this.mark > n) {
            this.mark = -1;
        }
        return this;
    }

    public ByteBuffer mark() {
        this.buf().mark();
        this.mark = this.position();
        return this;
    }

    public int markValue() {
        return this.mark;
    }

    public ByteBuffer reset() {
        this.buf().reset();
        return this;
    }

    public ByteBuffer clear() {
        this.buf().clear();
        this.mark = -1;
        return this;
    }

    public ByteBuffer flip() {
        this.buf().flip();
        this.mark = -1;
        return this;
    }

    public ByteBuffer rewind() {
        this.buf().rewind();
        this.mark = -1;
        return this;
    }

    public byte get() {
        return this.buf().get();
    }

    public ByteBuffer put(byte by) {
        this.autoExpand(1);
        this.buf().put(by);
        return this;
    }

    public byte get(int n) {
        return this.buf().get(n);
    }

    public ByteBuffer put(int n, byte by) {
        this.autoExpand(n, 1);
        this.buf().put(n, by);
        return this;
    }

    public ByteBuffer get(byte[] byArray, int n, int n2) {
        this.buf().get(byArray, n, n2);
        return this;
    }

    public ByteBuffer put(java.nio.ByteBuffer byteBuffer) {
        this.autoExpand(byteBuffer.remaining());
        this.buf().put(byteBuffer);
        return this;
    }

    public ByteBuffer put(byte[] byArray, int n, int n2) {
        this.autoExpand(n2);
        this.buf().put(byArray, n, n2);
        return this;
    }

    public ByteBuffer compact() {
        this.buf().compact();
        this.mark = -1;
        return this;
    }

    public ByteOrder order() {
        return this.buf().order();
    }

    public ByteBuffer order(ByteOrder byteOrder) {
        this.buf().order(byteOrder);
        return this;
    }

    public char getChar() {
        return this.buf().getChar();
    }

    public ByteBuffer putChar(char c) {
        this.autoExpand(2);
        this.buf().putChar(c);
        return this;
    }

    public char getChar(int n) {
        return this.buf().getChar(n);
    }

    public ByteBuffer putChar(int n, char c) {
        this.autoExpand(n, 2);
        this.buf().putChar(n, c);
        return this;
    }

    public CharBuffer asCharBuffer() {
        return this.buf().asCharBuffer();
    }

    public short getShort() {
        return this.buf().getShort();
    }

    public ByteBuffer putShort(short s) {
        this.autoExpand(2);
        this.buf().putShort(s);
        return this;
    }

    public short getShort(int n) {
        return this.buf().getShort(n);
    }

    public ByteBuffer putShort(int n, short s) {
        this.autoExpand(n, 2);
        this.buf().putShort(n, s);
        return this;
    }

    public ShortBuffer asShortBuffer() {
        return this.buf().asShortBuffer();
    }

    public int getInt() {
        return this.buf().getInt();
    }

    public ByteBuffer putInt(int n) {
        this.autoExpand(4);
        this.buf().putInt(n);
        return this;
    }

    public int getInt(int n) {
        return this.buf().getInt(n);
    }

    public ByteBuffer putInt(int n, int n2) {
        this.autoExpand(n, 4);
        this.buf().putInt(n, n2);
        return this;
    }

    public IntBuffer asIntBuffer() {
        return this.buf().asIntBuffer();
    }

    public long getLong() {
        return this.buf().getLong();
    }

    public ByteBuffer putLong(long l) {
        this.autoExpand(8);
        this.buf().putLong(l);
        return this;
    }

    public long getLong(int n) {
        return this.buf().getLong(n);
    }

    public ByteBuffer putLong(int n, long l) {
        this.autoExpand(n, 8);
        this.buf().putLong(n, l);
        return this;
    }

    public LongBuffer asLongBuffer() {
        return this.buf().asLongBuffer();
    }

    public float getFloat() {
        return this.buf().getFloat();
    }

    public ByteBuffer putFloat(float f) {
        this.autoExpand(4);
        this.buf().putFloat(f);
        return this;
    }

    public float getFloat(int n) {
        return this.buf().getFloat(n);
    }

    public ByteBuffer putFloat(int n, float f) {
        this.autoExpand(n, 4);
        this.buf().putFloat(n, f);
        return this;
    }

    public FloatBuffer asFloatBuffer() {
        return this.buf().asFloatBuffer();
    }

    public double getDouble() {
        return this.buf().getDouble();
    }

    public ByteBuffer putDouble(double d) {
        this.autoExpand(8);
        this.buf().putDouble(d);
        return this;
    }

    public double getDouble(int n) {
        return this.buf().getDouble(n);
    }

    public ByteBuffer putDouble(int n, double d) {
        this.autoExpand(n, 8);
        this.buf().putDouble(n, d);
        return this;
    }

    public DoubleBuffer asDoubleBuffer() {
        return this.buf().asDoubleBuffer();
    }
}

