/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IoAcceptorConfig;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.IdentityHashSet;

public class IoServiceListenerSupport {
    private final List listeners = new ArrayList();
    private final Set managedServiceAddresses = new HashSet();
    private final Map managedSessions = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IoServiceListener ioServiceListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(ioServiceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IoServiceListener ioServiceListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(ioServiceListener);
        }
    }

    public Set getManagedServiceAddresses() {
        return Collections.unmodifiableSet(this.managedServiceAddresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isManaged(SocketAddress socketAddress) {
        Set set = this.managedServiceAddresses;
        synchronized (set) {
            return this.managedServiceAddresses.contains(socketAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getManagedSessions(SocketAddress socketAddress) {
        Set set;
        Object object = this.managedSessions;
        synchronized (object) {
            set = (Set)this.managedSessions.get(socketAddress);
            if (set == null) {
                set = new IdentityHashSet();
            }
        }
        object = set;
        synchronized (object) {
            return new IdentityHashSet(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireServiceActivated(IoService ioService, SocketAddress socketAddress, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
        Collection collection = this.managedServiceAddresses;
        synchronized (collection) {
            if (!this.managedServiceAddresses.add(socketAddress)) {
                return;
            }
        }
        collection = this.listeners;
        synchronized (collection) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((IoServiceListener)iterator.next()).serviceActivated(ioService, socketAddress, ioHandler, ioServiceConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fireServiceDeactivated(IoService ioService, SocketAddress socketAddress, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
        Collection collection = this.managedServiceAddresses;
        synchronized (collection) {
            if (!this.managedServiceAddresses.remove(socketAddress)) {
                return;
            }
        }
        try {
            collection = this.listeners;
            synchronized (collection) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    ((IoServiceListener)iterator.next()).serviceDeactivated(ioService, socketAddress, ioHandler, ioServiceConfig);
                }
            }
        }
        finally {
            this.disconnectSessions(socketAddress, ioServiceConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionCreated(IoSession ioSession) {
        SocketAddress socketAddress = ioSession.getServiceAddress();
        boolean bl = false;
        Object object = this.managedSessions;
        synchronized (object) {
            Set set = (Set)this.managedSessions.get(socketAddress);
            if (set == null) {
                set = new IdentityHashSet();
                this.managedSessions.put(socketAddress, set);
                bl = true;
            }
            if (!set.add(ioSession)) {
                return;
            }
        }
        if (ioSession.getService() instanceof IoConnector && bl) {
            this.fireServiceActivated(ioSession.getService(), ioSession.getServiceAddress(), ioSession.getHandler(), ioSession.getServiceConfig());
        }
        ioSession.getFilterChain().fireSessionCreated(ioSession);
        ioSession.getFilterChain().fireSessionOpened(ioSession);
        object = this.listeners;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((IoServiceListener)iterator.next()).sessionCreated(ioSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionDestroyed(IoSession ioSession) {
        SocketAddress socketAddress = ioSession.getServiceAddress();
        boolean bl = false;
        Object object = this.managedSessions;
        synchronized (object) {
            Set set = (Set)this.managedSessions.get(socketAddress);
            if (set == null) {
                return;
            }
            set.remove(ioSession);
            if (set.isEmpty()) {
                this.managedSessions.remove(socketAddress);
                bl = true;
            }
        }
        ioSession.getFilterChain().fireSessionClosed(ioSession);
        try {
            object = this.listeners;
            synchronized (object) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    ((IoServiceListener)iterator.next()).sessionDestroyed(ioSession);
                }
            }
        }
        finally {
            if (ioSession.getService() instanceof IoConnector && bl) {
                this.fireServiceDeactivated(ioSession.getService(), ioSession.getServiceAddress(), ioSession.getHandler(), ioSession.getServiceConfig());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectSessions(SocketAddress socketAddress, IoServiceConfig ioServiceConfig) {
        IdentityHashSet identityHashSet;
        Set set;
        if (!(ioServiceConfig instanceof IoAcceptorConfig)) {
            return;
        }
        if (!((IoAcceptorConfig)ioServiceConfig).isDisconnectOnUnbind()) {
            return;
        }
        final Object object = this.managedSessions;
        synchronized (object) {
            set = (Set)this.managedSessions.get(socketAddress);
        }
        if (set == null) {
            return;
        }
        object = new Object();
        Object object2 = set;
        synchronized (object2) {
            identityHashSet = new IdentityHashSet(set);
        }
        object2 = identityHashSet.iterator();
        while (object2.hasNext()) {
            ((IoSession)object2.next()).close().addListener(new IoFutureListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(IoFuture ioFuture) {
                    Object object2 = object;
                    synchronized (object2) {
                        object.notifyAll();
                    }
                }
            });
        }
        try {
            object2 = object;
            synchronized (object2) {
                while (!this.managedSessions.isEmpty()) {
                    object.wait(500L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

