/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public abstract class CumulativeProtocolDecoder
extends ProtocolDecoderAdapter {
    private static final String BUFFER = CumulativeProtocolDecoder.class.getName() + ".Buffer";

    protected CumulativeProtocolDecoder() {
    }

    public void decode(IoSession ioSession, ByteBuffer byteBuffer, ProtocolDecoderOutput protocolDecoderOutput) throws Exception {
        ByteBuffer byteBuffer2 = (ByteBuffer)ioSession.getAttribute(BUFFER);
        if (byteBuffer2 != null) {
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
        } else {
            byteBuffer2 = byteBuffer;
        }
        do {
            int n = byteBuffer2.position();
            boolean bl = this.doDecode(ioSession, byteBuffer2, protocolDecoderOutput);
            if (!bl) break;
            if (byteBuffer2.position() != n) continue;
            throw new IllegalStateException("doDecode() can't return true when buffer is not consumed.");
        } while (byteBuffer2.hasRemaining());
        if (byteBuffer2.hasRemaining()) {
            this.storeRemainingInSession(byteBuffer2, ioSession);
        } else {
            this.removeSessionBuffer(ioSession);
        }
    }

    protected abstract boolean doDecode(IoSession var1, ByteBuffer var2, ProtocolDecoderOutput var3) throws Exception;

    public void dispose(IoSession ioSession) throws Exception {
        this.removeSessionBuffer(ioSession);
    }

    private void removeSessionBuffer(IoSession ioSession) {
        ByteBuffer byteBuffer = (ByteBuffer)ioSession.getAttribute(BUFFER);
        if (byteBuffer != null) {
            byteBuffer.release();
            ioSession.removeAttribute(BUFFER);
        }
    }

    private void storeRemainingInSession(ByteBuffer byteBuffer, IoSession ioSession) {
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining(), false);
        byteBuffer2.setAutoExpand(true);
        byteBuffer2.put(byteBuffer);
        ioSession.setAttribute(BUFFER, byteBuffer2);
    }
}

