/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class SynchronizedProtocolDecoder
implements ProtocolDecoder {
    private final ProtocolDecoder decoder;

    public SynchronizedProtocolDecoder(ProtocolDecoder protocolDecoder) {
        if (protocolDecoder == null) {
            throw new NullPointerException("decoder");
        }
        this.decoder = protocolDecoder;
    }

    public ProtocolDecoder getDecoder() {
        return this.decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(IoSession ioSession, ByteBuffer byteBuffer, ProtocolDecoderOutput protocolDecoderOutput) throws Exception {
        ProtocolDecoder protocolDecoder = this.decoder;
        synchronized (protocolDecoder) {
            this.decoder.decode(ioSession, byteBuffer, protocolDecoderOutput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishDecode(IoSession ioSession, ProtocolDecoderOutput protocolDecoderOutput) throws Exception {
        ProtocolDecoder protocolDecoder = this.decoder;
        synchronized (protocolDecoder) {
            this.decoder.finishDecode(ioSession, protocolDecoderOutput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(IoSession ioSession) throws Exception {
        ProtocolDecoder protocolDecoder = this.decoder;
        synchronized (protocolDecoder) {
            this.decoder.dispose(ioSession);
        }
    }
}

