/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.serialization;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public class ObjectSerializationEncoder
extends ProtocolEncoderAdapter {
    private int maxObjectSize = Integer.MAX_VALUE;

    public int getMaxObjectSize() {
        return this.maxObjectSize;
    }

    public void setMaxObjectSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxObjectSize: " + n);
        }
        this.maxObjectSize = n;
    }

    public void encode(IoSession ioSession, Object object, ProtocolEncoderOutput protocolEncoderOutput) throws Exception {
        if (!(object instanceof Serializable)) {
            throw new NotSerializableException();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(64);
        byteBuffer.setAutoExpand(true);
        byteBuffer.putObject(object);
        int n = byteBuffer.position() - 4;
        if (n > this.maxObjectSize) {
            byteBuffer.release();
            throw new IllegalArgumentException("The encoded object is too big: " + n + " (> " + this.maxObjectSize + ')');
        }
        byteBuffer.flip();
        protocolEncoderOutput.write(byteBuffer);
    }
}

