/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.handler.demux;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.demux.MessageHandler;
import org.apache.mina.handler.demux.UnknownMessageTypeException;
import org.apache.mina.util.IdentityHashSet;

public class DemuxingIoHandler
extends IoHandlerAdapter {
    private final Map findHandlerCache = new Hashtable();
    private final Map type2handler = new Hashtable();

    public MessageHandler addMessageHandler(Class clazz, MessageHandler messageHandler) {
        this.findHandlerCache.clear();
        return this.type2handler.put(clazz, messageHandler);
    }

    public MessageHandler removeMessageHandler(Class clazz) {
        this.findHandlerCache.clear();
        return (MessageHandler)this.type2handler.remove(clazz);
    }

    public MessageHandler getMessageHandler(Class clazz) {
        return (MessageHandler)this.type2handler.get(clazz);
    }

    public Map getMessageHandlerMap() {
        return Collections.unmodifiableMap(this.type2handler);
    }

    public void messageReceived(IoSession ioSession, Object object) throws Exception {
        MessageHandler messageHandler = this.findHandler(object.getClass());
        if (messageHandler == null) {
            throw new UnknownMessageTypeException("No message handler found for message: " + object);
        }
        messageHandler.messageReceived(ioSession, object);
    }

    private MessageHandler findHandler(Class clazz) {
        return this.findHandler(clazz, null);
    }

    private MessageHandler findHandler(Class clazz, Set set) {
        Class<?>[] classArray;
        MessageHandler messageHandler = null;
        if (set != null && set.contains(clazz)) {
            return null;
        }
        messageHandler = (MessageHandler)this.findHandlerCache.get(clazz);
        if (messageHandler != null) {
            return messageHandler;
        }
        messageHandler = (MessageHandler)this.type2handler.get(clazz);
        if (messageHandler == null) {
            if (set == null) {
                set = new IdentityHashSet();
            }
            set.add(clazz);
            classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length && (messageHandler = this.findHandler(classArray[i], set)) == null; ++i) {
            }
        }
        if (messageHandler == null && (classArray = clazz.getSuperclass()) != null) {
            messageHandler = this.findHandler((Class)classArray);
        }
        if (messageHandler != null) {
            this.findHandlerCache.put(clazz, messageHandler);
        }
        return messageHandler;
    }
}

