/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.handler.multiton;

import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.multiton.SingleSessionIoHandler;
import org.apache.mina.handler.multiton.SingleSessionIoHandlerFactory;

public class SingleSessionIoHandlerDelegate
implements IoHandler {
    public static final String HANDLER = SingleSessionIoHandlerDelegate.class.getName() + ".handler";
    private final SingleSessionIoHandlerFactory factory;

    public SingleSessionIoHandlerDelegate(SingleSessionIoHandlerFactory singleSessionIoHandlerFactory) {
        if (singleSessionIoHandlerFactory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = singleSessionIoHandlerFactory;
    }

    public void sessionCreated(IoSession ioSession) throws Exception {
        SingleSessionIoHandler singleSessionIoHandler = this.factory.getHandler(ioSession);
        ioSession.setAttribute(HANDLER, singleSessionIoHandler);
        singleSessionIoHandler.sessionCreated();
    }

    public void sessionOpened(IoSession ioSession) throws Exception {
        SingleSessionIoHandler singleSessionIoHandler = (SingleSessionIoHandler)ioSession.getAttribute(HANDLER);
        singleSessionIoHandler.sessionOpened();
    }

    public void sessionClosed(IoSession ioSession) throws Exception {
        SingleSessionIoHandler singleSessionIoHandler = (SingleSessionIoHandler)ioSession.getAttribute(HANDLER);
        singleSessionIoHandler.sessionClosed();
    }

    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) throws Exception {
        SingleSessionIoHandler singleSessionIoHandler = (SingleSessionIoHandler)ioSession.getAttribute(HANDLER);
        singleSessionIoHandler.sessionIdle(idleStatus);
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) throws Exception {
        SingleSessionIoHandler singleSessionIoHandler = (SingleSessionIoHandler)ioSession.getAttribute(HANDLER);
        singleSessionIoHandler.exceptionCaught(throwable);
    }

    public void messageReceived(IoSession ioSession, Object object) throws Exception {
        SingleSessionIoHandler singleSessionIoHandler = (SingleSessionIoHandler)ioSession.getAttribute(HANDLER);
        singleSessionIoHandler.messageReceived(object);
    }

    public void messageSent(IoSession ioSession, Object object) throws Exception {
        SingleSessionIoHandler singleSessionIoHandler = (SingleSessionIoHandler)ioSession.getAttribute(HANDLER);
        singleSessionIoHandler.messageSent(object);
    }
}

