/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.handler.support;

import java.io.IOException;
import java.io.InputStream;
import org.apache.mina.common.ByteBuffer;

public class IoSessionInputStream
extends InputStream {
    private final Object mutex = new Object();
    private final ByteBuffer buf = ByteBuffer.allocate(16);
    private volatile boolean closed;
    private volatile boolean released;
    private IOException exception;

    public IoSessionInputStream() {
        this.buf.setAutoExpand(true);
        this.buf.limit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        if (this.released) {
            return 0;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.buf.remaining();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.closed = true;
            this.releaseBuffer();
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.waitForData()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.waitForData()) {
                return -1;
            }
            int n3 = n2 > this.buf.remaining() ? this.buf.remaining() : n2;
            this.buf.get(byArray, n, n3);
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForData() throws IOException {
        if (this.released) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            while (!this.released && this.buf.remaining() == 0 && this.exception == null) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException interruptedException) {
                    IOException iOException = new IOException("Interrupted while waiting for more data");
                    iOException.initCause(interruptedException);
                    throw iOException;
                }
            }
        }
        if (this.exception != null) {
            this.releaseBuffer();
            throw this.exception;
        }
        if (this.closed && this.buf.remaining() == 0) {
            this.releaseBuffer();
            return false;
        }
        return true;
    }

    private void releaseBuffer() {
        if (this.released) {
            return;
        }
        this.released = true;
        this.buf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuffer byteBuffer) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (this.buf.hasRemaining()) {
                this.buf.compact();
                this.buf.put(byteBuffer);
                this.buf.flip();
            } else {
                this.buf.clear();
                this.buf.put(byteBuffer);
                this.buf.flip();
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwException(IOException iOException) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.exception == null) {
                this.exception = iOException;
                this.mutex.notifyAll();
            }
        }
    }
}

