/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.handler.support;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;

public class IoSessionOutputStream
extends OutputStream {
    private final IoSession session;
    private WriteFuture lastWriteFuture;

    public IoSessionOutputStream(IoSession ioSession) {
        this.session = ioSession;
    }

    public void close() {
        this.session.close().join();
    }

    private void checkClosed() throws IOException {
        if (!this.session.isConnected()) {
            throw new IOException("The session has been closed.");
        }
    }

    private synchronized void write(ByteBuffer byteBuffer) throws IOException {
        WriteFuture writeFuture;
        this.checkClosed();
        this.lastWriteFuture = writeFuture = this.session.write(byteBuffer);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.write(ByteBuffer.wrap(byArray, n, n2));
    }

    public void write(int n) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        byteBuffer.put((byte)n);
        byteBuffer.flip();
        this.write(byteBuffer);
    }

    public synchronized void flush() throws IOException {
        if (this.lastWriteFuture == null) {
            return;
        }
        this.lastWriteFuture.join();
        if (!this.lastWriteFuture.isWritten()) {
            throw new IOException("The bytes could not be written to the session");
        }
    }
}

