/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.integration.liverecord;

import com.wowza.io.WowzaRandomAccessFile;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.util.FileUtils;
import com.wowza.util.MediaUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediawriter.h264.MediaWriterH264;
import com.wowza.wms.mediawriter.h264.util.QTWriterContext;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrack;
import com.wowza.wms.mediawriter.h264.util.QTWriterUtils;
import com.wowza.wms.plugin.integration.liverecord.ILiveStreamRecord;
import com.wowza.wms.plugin.integration.liverecord.LiveStreamRecordActionNotifier;
import com.wowza.wms.plugin.integration.liverecord.LiveStreamRecorderBase;
import com.wowza.wms.plugin.integration.liverecord.LiveStreamRecorderWorker;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveStreamRecorderMP4
extends LiveStreamRecorderBase
implements ILiveStreamRecord {
    private RandomAccessFile outf = null;
    private RandomAccessFile tmpf = null;
    private File tmpFile = null;
    private long startTC = 0L;
    private long timecodeOffset = -1L;
    private boolean waitForKeyFrame = true;
    private long lastSeq = -1L;
    private long lastTC = -1L;
    private int startVideoFrames = 0;
    private int startTotalFrames = 0;
    private QTWriterContext qtContext = null;
    private QTWriterContextTrack audioTrack = null;
    private QTWriterContextTrack videoTrack = null;
    private boolean isFirstAudio = true;
    private boolean isFirstVideo = true;
    private boolean isFirstWriteAudio = true;
    private boolean isFirstWriteVideo = true;
    private boolean sendUnsupportedAudioCodecWarning = true;
    private boolean sendUnsupportedVideoCodecWarning = true;
    private int videoPacketDataOffset = 1;
    private int audioPacketDataOffset = 1;

    private boolean isOpen() {
        return this.outf != null && this.tmpf != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFile() {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.qtContext != null && this.outf != null && this.tmpf != null) {
                QTWriterUtils.flush((RandomAccessFile)this.outf, (RandomAccessFile)this.tmpf, (QTWriterContext)this.qtContext);
                QTWriterUtils.writeMOOVAtom((RandomAccessFile)this.outf, (QTWriterContext)this.qtContext);
            }
            if (this.outf != null) {
                try {
                    this.outf.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.outf = null;
            if (this.tmpf != null) {
                try {
                    this.tmpf.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.tmpf = null;
            if (this.tmpFile != null && this.tmpFile.exists()) {
                try {
                    this.tmpFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.tmpFile = null;
            if (this.stream != null) {
                this.stream.getStreams().getAppInstance().notifyMediaWriterOnWriteComplete(this.stream, new File(this.filePath));
            }
        }
    }

    private void openFile(File file, boolean append) {
        block10: {
            try {
                boolean result;
                if (append) {
                    append = file.exists();
                }
                this.qtContext = new QTWriterContext();
                this.qtContext.setOutPath(file.getAbsolutePath());
                this.tmpFile = new File(file.getAbsolutePath() + ".tmp");
                if (this.tmpFile.exists()) {
                    try {
                        this.tmpFile.delete();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.outf = new WowzaRandomAccessFile(file, "rw");
                this.tmpf = new WowzaRandomAccessFile(this.tmpFile, "rw");
                this.qtContext.setTmpOut(this.tmpf);
                if (this.outf == null || this.tmpf == null) break block10;
                if (append && !(result = QTWriterUtils.loadForAppend((RandomAccessFile)this.outf, (RandomAccessFile)this.tmpf, (QTWriterContext)this.qtContext))) {
                    append = false;
                    try {
                        this.outf.setLength(0L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!this.qtContext.isAppend()) {
                    QTWriterUtils.writeNewFileHeader((RandomAccessFile)this.outf, (QTWriterContext)this.qtContext);
                }
                this.outf.seek(this.outf.length());
                this.tmpf.seek(this.tmpf.length());
            }
            catch (Exception e) {
                WMSLoggerFactory.getLogger(LiveStreamRecorderMP4.class).error("LiveStreamRecorder.startRecording: open file (" + file + "): " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPublish() {
        WMSLoggerFactory.getLogger(LiveStreamRecorderMP4.class).info("LiveStreamRecorder.onPublish");
        Object object = this.writeLock;
        synchronized (object) {
            this.resetStream();
            File newFile = new File(this.filePath);
            this.openFile(newFile, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUnPublish() {
        WMSLoggerFactory.getLogger(LiveStreamRecorderMP4.class).info("LiveStreamRecorder.onUnPublish");
        Object object = this.writeLock;
        synchronized (object) {
            this.closeFile();
            this.resetStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWorker(boolean wait) {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.worker != null) {
                this.worker.quit();
            }
        }
        if (this.worker != null && wait) {
            while (this.worker.running()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (Exception e) {
                    WMSLoggerFactory.getLogger(LiveStreamRecorderMP4.class).error("LiveStreamRecorder.stopWorker: sleep: " + e.toString());
                }
            }
        }
    }

    @Override
    public void startRecording(IMediaStream stream, boolean append) {
        this.startRecording(stream, null, append, null);
    }

    @Override
    public void startRecording(IMediaStream stream, String filePath, boolean append) {
        this.startRecording(stream, filePath, append, null);
    }

    @Override
    public void startRecording(IMediaStream stream, String filePath, boolean append, Map extraMetadata) {
        try {
            this.stopWorker(false);
            this.worker = null;
            this.closeFile();
            this.stream = stream;
            if (filePath == null) {
                File tmp = stream.getStreamFileForWrite(stream.getName(), "flv", stream.getQueryStr());
                this.filePath = tmp.getAbsolutePath();
            } else {
                this.filePath = filePath;
            }
            this.streamNotifier = new LiveStreamRecordActionNotifier(this);
            this.stream.addClientListener((IMediaStreamActionNotify)this.streamNotifier);
            this.timecodeOffset = -1L;
            this.waitForKeyFrame = true;
            this.lastSeq = -1L;
            this.lastTC = -1L;
            this.startTC = 0L;
            this.startVideoFrames = 0;
            this.startTotalFrames = 0;
            boolean localAppend = false;
            File newFile = new File(this.filePath);
            if (append && newFile.exists()) {
                localAppend = true;
            }
            if (!localAppend && newFile.exists()) {
                if (this.versionFile) {
                    FileUtils.versionFile((File)newFile);
                } else {
                    try {
                        newFile.delete();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            this.openFile(newFile, localAppend);
            if (this.isOpen()) {
                this.worker = new LiveStreamRecorderWorker(this);
                this.worker.setDaemon(true);
                this.worker.start();
            }
        }
        catch (Exception e) {
            WMSLoggerFactory.getLogger(LiveStreamRecorderMP4.class).error("LiveStreamRecorder.startRecording: " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void stopRecording() {
        try {
            this.stopWorker(true);
            this.worker = null;
        }
        catch (Exception e) {
            WMSLoggerFactory.getLogger(LiveStreamRecorderMP4.class).error("LiveStreamRecorder.stopRecording: " + e.toString());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStream() {
        Object object = this.writeLock;
        synchronized (object) {
            this.timecodeOffset = -1L;
            this.waitForKeyFrame = true;
            this.lastSeq = -1L;
            this.lastTC = -1L;
            this.startVideoFrames = 0;
            this.startTotalFrames = 0;
            this.isFirstAudio = true;
            this.isFirstVideo = true;
            this.isFirstWriteAudio = true;
            this.isFirstWriteVideo = true;
            this.qtContext = null;
            this.audioTrack = null;
            this.videoTrack = null;
            this.sendUnsupportedAudioCodecWarning = true;
            this.sendUnsupportedVideoCodecWarning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workStop() {
        Object object = this.writeLock;
        synchronized (object) {
            this.closeFile();
            if (this.streamNotifier != null) {
                this.stream.removeClientListener((IMediaStreamActionNotify)this.streamNotifier);
                this.streamNotifier = null;
            }
        }
    }

    protected List<AMFPacket> getPlayPackets() {
        return this.stream.getPlayPackets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void work() {
        Object object = this.writeLock;
        synchronized (object) {
            int numPackets;
            List<AMFPacket> packets;
            if (this.stream != null && this.isOpen() && (packets = this.getPlayPackets()) != null && (numPackets = packets.size()) != 0) {
                int startIdx;
                AMFPacket packet = null;
                packet = packets.get(0);
                long startSeq = packet.getSeq();
                int n = startIdx = this.lastSeq == -1L ? 0 : (int)(this.lastSeq - startSeq + 1L);
                if (startIdx < 0) {
                    startIdx = 0;
                }
                if (startIdx < numPackets) {
                    int packetType;
                    int idx;
                    if (this.timecodeOffset == -1L) {
                        for (idx = numPackets - 1; idx >= 0; --idx) {
                            packet = packets.get(idx);
                            packetType = packet.getType();
                            if (packetType != 9 && packetType != 8) continue;
                            ++this.startTotalFrames;
                            if (this.isStartOnKeyFrame()) {
                                if (packetType == 9) {
                                    ++this.startVideoFrames;
                                    int firstByte = packet.getFirstByte();
                                    if (!FLVUtils.isVideoKeyFrame((AMFPacket)packet)) continue;
                                    startIdx = idx;
                                    this.timecodeOffset = packet.getAbsTimecode();
                                    break;
                                }
                                if (this.startVideoFrames != 0 || this.startTotalFrames <= 20) continue;
                                startIdx = idx;
                                this.timecodeOffset = packet.getAbsTimecode();
                                break;
                            }
                            startIdx = idx;
                            this.timecodeOffset = packet.getAbsTimecode();
                            break;
                        }
                    }
                    if (this.timecodeOffset >= 0L) {
                        for (idx = startIdx; idx < numPackets; ++idx) {
                            long cttsOffset;
                            int codec;
                            long adjTimecode;
                            int codec2;
                            int secondByte;
                            packet = packets.get(idx);
                            packetType = packet.getType();
                            this.lastSeq = packet.getSeq();
                            byte[] buffer = packet.getData();
                            int size = packet.getSize();
                            if (!this.isRecordData() && packetType != 9 && packetType != 8 || size <= 0) continue;
                            int firstByte = packet.getFirstByte();
                            boolean sendFrame = true;
                            if (this.waitForKeyFrame && packetType == 9) {
                                sendFrame = false;
                                if (FLVUtils.isVideoKeyFrame((AMFPacket)packet)) {
                                    sendFrame = true;
                                    this.waitForKeyFrame = false;
                                }
                            }
                            if (packetType == 9 && size >= 2) {
                                secondByte = packet.getSecondByte();
                                if (size == 2 && (firstByte & 0x50) == 80 && (secondByte == 0 || secondByte == 1)) {
                                    sendFrame = false;
                                }
                                if ((codec2 = FLVUtils.getVideoCodec((int)firstByte)) == 7 && secondByte != 1) {
                                    sendFrame = false;
                                }
                            }
                            if (packetType == 8 && size >= 2) {
                                secondByte = packet.getSecondByte();
                                codec2 = FLVUtils.getAudioCodec((int)firstByte);
                                if (codec2 == 10 && secondByte != 1) {
                                    sendFrame = false;
                                }
                            }
                            if (!sendFrame || (adjTimecode = packet.getAbsTimecode() - this.timecodeOffset) < 0L) continue;
                            this.lastTC = adjTimecode + this.startTC;
                            if (packetType == 8) {
                                codec = FLVUtils.getAudioCodec((int)firstByte);
                                if (codec != 10 && codec != 2) {
                                    if (!this.sendUnsupportedAudioCodecWarning) continue;
                                    String formatStr = MediaUtils.audioCodecTypeToString((int)codec);
                                    WMSLoggerFactory.getLogger(MediaWriterH264.class).warn("MediaWriterH264: Unsupported audio format for MP4 container: " + formatStr);
                                    this.sendUnsupportedAudioCodecWarning = false;
                                    continue;
                                }
                                if (this.isFirstAudio) {
                                    if (codec == 10) {
                                        this.audioPacketDataOffset = 2;
                                        if (this.audioTrack == null) {
                                            this.audioTrack = this.qtContext.getAudioTrack();
                                        }
                                        QTWriterUtils.extractAACCodecInfoFromStream((IMediaStream)this.stream, (QTWriterContextTrack)this.audioTrack, (long)packet.getAbsTimecode());
                                    } else if (codec == 2) {
                                        if (this.audioTrack == null) {
                                            this.audioTrack = this.qtContext.getAudioTrack();
                                        }
                                        QTWriterUtils.extractMP3CodecInfoFromPacket((byte[])buffer, (QTWriterContextTrack)this.audioTrack);
                                    }
                                    this.isFirstAudio = false;
                                }
                                if (this.isFirstWriteAudio) {
                                    adjTimecode = 0L;
                                    this.isFirstWriteAudio = false;
                                }
                                this.audioTrack.addPacket(this.outf, buffer, this.audioPacketDataOffset, size - this.audioPacketDataOffset, false, this.audioTrack.millisToTimecode(adjTimecode));
                                continue;
                            }
                            if (packetType != 9) continue;
                            codec = FLVUtils.getVideoCodec((int)firstByte);
                            if (codec != 7) {
                                if (!this.sendUnsupportedVideoCodecWarning) continue;
                                String formatStr = MediaUtils.videoCodecTypeToString((int)codec);
                                WMSLoggerFactory.getLogger(MediaWriterH264.class).warn("MediaWriterH264: Unsupported video format for MP4 container: " + formatStr);
                                this.sendUnsupportedVideoCodecWarning = false;
                                continue;
                            }
                            if (this.isFirstVideo) {
                                if (codec == 7) {
                                    this.videoPacketDataOffset = 5;
                                    if (this.videoTrack == null) {
                                        this.videoTrack = this.qtContext.getVideoTrack();
                                    }
                                    QTWriterUtils.extractH264CodecInfoFromStream((IMediaStream)this.stream, (QTWriterContextTrack)this.videoTrack, (long)packet.getAbsTimecode());
                                }
                                this.isFirstVideo = false;
                            }
                            if (this.isFirstWriteVideo) {
                                if (this.moveFirstVideoFrameToZero) {
                                    adjTimecode = 0L;
                                }
                                this.isFirstWriteVideo = false;
                            }
                            long ctts = 0L;
                            if (codec == 7 && size > 5 && (cttsOffset = (long)BufferUtils.byteArrayToInt((byte[])buffer, (int)2, (int)3)) != 0L) {
                                long cttsAdj = this.videoTrack.millisToTimecode(adjTimecode + cttsOffset);
                                long nonAdj = this.videoTrack.millisToTimecode(adjTimecode);
                                ctts = cttsAdj - nonAdj;
                            }
                            boolean isKey = FLVUtils.isVideoKeyFrame((AMFPacket)packet);
                            this.videoTrack.addPacket(this.outf, buffer, this.videoPacketDataOffset, size - this.videoPacketDataOffset, isKey, this.videoTrack.millisToTimecode(adjTimecode), ctts);
                        }
                    }
                }
            }
        }
    }
}

