/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class SocketNode
implements Runnable {
    Socket socket;
    LoggerRepository hierarchy;
    ObjectInputStream ois;
    static Logger logger = Logger.getLogger(class$org$apache$log4j$net$SocketNode == null ? (class$org$apache$log4j$net$SocketNode = SocketNode.class$("org.apache.log4j.net.SocketNode")) : class$org$apache$log4j$net$SocketNode);
    static /* synthetic */ Class class$org$apache$log4j$net$SocketNode;

    public SocketNode(Socket socket, LoggerRepository loggerRepository) {
        this.socket = socket;
        this.hierarchy = loggerRepository;
        try {
            this.ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            logger.error("Could not open ObjectInputStream to " + socket, interruptedIOException);
        }
        catch (IOException iOException) {
            logger.error("Could not open ObjectInputStream to " + socket, iOException);
        }
        catch (RuntimeException runtimeException) {
            logger.error("Could not open ObjectInputStream to " + socket, runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.ois != null) {
                while (true) {
                    LoggingEvent loggingEvent = (LoggingEvent)this.ois.readObject();
                    Logger logger = this.hierarchy.getLogger(loggingEvent.getLoggerName());
                    if (!loggingEvent.getLevel().isGreaterOrEqual(logger.getEffectiveLevel())) continue;
                    logger.callAppenders(loggingEvent);
                }
            }
        }
        catch (EOFException eOFException) {
            logger.info("Caught java.io.EOFException closing conneciton.");
        }
        catch (SocketException socketException) {
            logger.info("Caught java.net.SocketException closing conneciton.");
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            logger.info("Caught java.io.InterruptedIOException: " + interruptedIOException);
            logger.info("Closing connection.");
        }
        catch (IOException iOException) {
            logger.info("Caught java.io.IOException: " + iOException);
            logger.info("Closing connection.");
        }
        catch (Exception exception) {
            logger.error("Unexpected exception. Closing conneciton.", exception);
        }
        finally {
            if (this.ois != null) {
                try {
                    this.ois.close();
                }
                catch (Exception exception) {
                    logger.info("Could not close connection.", exception);
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (InterruptedIOException interruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

