/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

public final class FormattingInfo {
    private static final char[] SPACES = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private static final FormattingInfo DEFAULT = new FormattingInfo(false, 0, Integer.MAX_VALUE);
    private final int minLength;
    private final int maxLength;
    private final boolean leftAlign;

    public FormattingInfo(boolean bl, int n, int n2) {
        this.leftAlign = bl;
        this.minLength = n;
        this.maxLength = n2;
    }

    public static FormattingInfo getDefault() {
        return DEFAULT;
    }

    public boolean isLeftAligned() {
        return this.leftAlign;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void format(int n, StringBuffer stringBuffer) {
        int n2 = stringBuffer.length() - n;
        if (n2 > this.maxLength) {
            stringBuffer.delete(n, stringBuffer.length() - this.maxLength);
        } else if (n2 < this.minLength) {
            if (this.leftAlign) {
                int n3 = stringBuffer.length();
                stringBuffer.setLength(n + this.minLength);
                for (int i = n3; i < stringBuffer.length(); ++i) {
                    stringBuffer.setCharAt(i, ' ');
                }
            } else {
                int n4;
                for (n4 = this.minLength - n2; n4 > 8; n4 -= 8) {
                    stringBuffer.insert(n, SPACES);
                }
                stringBuffer.insert(n, SPACES, 0, n4);
            }
        }
    }
}

