/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.apache.commons.modeler.AttributeInfo;
import org.apache.commons.modeler.ConstructorInfo;
import org.apache.commons.modeler.FieldInfo;
import org.apache.commons.modeler.NotificationInfo;
import org.apache.commons.modeler.OperationInfo;

public class ManagedBean
implements Serializable {
    transient ModelMBeanInfo info = null;
    protected AttributeInfo[] attributes = new AttributeInfo[0];
    protected String className = "org.apache.commons.modeler.BaseModelMBean";
    protected ConstructorInfo[] constructors = new ConstructorInfo[0];
    protected String description = null;
    protected String domain = null;
    protected String group = null;
    protected String name = null;
    protected List fields = new ArrayList();
    protected NotificationInfo[] notifications = new NotificationInfo[0];
    protected OperationInfo[] operations = new OperationInfo[0];
    protected String type = null;

    public ManagedBean() {
        AttributeInfo attributeInfo = new AttributeInfo();
        attributeInfo.setName("modelerType");
        attributeInfo.setDescription("Type of the modeled resource. Can be set only once");
        attributeInfo.setType("java.lang.String");
        attributeInfo.setWriteable(false);
        this.addAttribute(attributeInfo);
    }

    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
        this.info = null;
    }

    public ConstructorInfo[] getConstructors() {
        return this.constructors;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
        this.info = null;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public List getFields() {
        return this.fields;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.info = null;
    }

    public NotificationInfo[] getNotifications() {
        return this.notifications;
    }

    public OperationInfo[] getOperations() {
        return this.operations;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
        this.info = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttribute(AttributeInfo attributeInfo) {
        AttributeInfo[] attributeInfoArray = this.attributes;
        synchronized (this.attributes) {
            AttributeInfo[] attributeInfoArray2 = new AttributeInfo[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, attributeInfoArray2, 0, this.attributes.length);
            attributeInfoArray2[this.attributes.length] = attributeInfo;
            this.attributes = attributeInfoArray2;
            this.info = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConstructor(ConstructorInfo constructorInfo) {
        ConstructorInfo[] constructorInfoArray = this.constructors;
        synchronized (this.constructors) {
            ConstructorInfo[] constructorInfoArray2 = new ConstructorInfo[this.constructors.length + 1];
            System.arraycopy(this.constructors, 0, constructorInfoArray2, 0, this.constructors.length);
            constructorInfoArray2[this.constructors.length] = constructorInfo;
            this.constructors = constructorInfoArray2;
            this.info = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void addField(FieldInfo fieldInfo) {
        this.fields.add(fieldInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotification(NotificationInfo notificationInfo) {
        NotificationInfo[] notificationInfoArray = this.notifications;
        synchronized (this.notifications) {
            NotificationInfo[] notificationInfoArray2 = new NotificationInfo[this.notifications.length + 1];
            System.arraycopy(this.notifications, 0, notificationInfoArray2, 0, this.notifications.length);
            notificationInfoArray2[this.notifications.length] = notificationInfo;
            this.notifications = notificationInfoArray2;
            this.info = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperation(OperationInfo operationInfo) {
        OperationInfo[] operationInfoArray = this.operations;
        synchronized (this.operations) {
            OperationInfo[] operationInfoArray2 = new OperationInfo[this.operations.length + 1];
            System.arraycopy(this.operations, 0, operationInfoArray2, 0, this.operations.length);
            operationInfoArray2[this.operations.length] = operationInfo;
            this.operations = operationInfoArray2;
            this.info = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ModelMBean createMBean() throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException, RuntimeOperationsException {
        return this.createMBean(null);
    }

    public ModelMBean createMBean(Object object) throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException, RuntimeOperationsException {
        Object object2;
        Class<?> clazz = null;
        Exception exception = null;
        try {
            clazz = Class.forName(this.getClassName());
        }
        catch (Exception exception2) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                object2 = Thread.currentThread().getContextClassLoader();
                if (object2 != null) {
                    clazz = ((ClassLoader)object2).loadClass(this.getClassName());
                }
            }
            catch (Exception exception3) {
                exception = exception3;
            }
        }
        if (clazz == null) {
            throw new MBeanException(exception, "Cannot load ModelMBean class " + this.getClassName());
        }
        object2 = null;
        try {
            object2 = (ModelMBean)clazz.newInstance();
            object2.setModelMBeanInfo(this.createMBeanInfo());
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw runtimeOperationsException;
        }
        catch (Exception exception4) {
            throw new MBeanException(exception4, "Cannot instantiate ModelMBean of class " + this.getClassName());
        }
        try {
            if (object != null) {
                object2.setManagedResource(object, "ObjectReference");
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (InvalidTargetObjectTypeException invalidTargetObjectTypeException) {
            throw invalidTargetObjectTypeException;
        }
        return object2;
    }

    public ModelMBeanInfo createMBeanInfo() {
        if (this.info != null) {
            return this.info;
        }
        AttributeInfo[] attributeInfoArray = this.getAttributes();
        ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray = new ModelMBeanAttributeInfo[attributeInfoArray.length];
        for (int i = 0; i < attributeInfoArray.length; ++i) {
            modelMBeanAttributeInfoArray[i] = attributeInfoArray[i].createAttributeInfo();
        }
        ConstructorInfo[] constructorInfoArray = this.getConstructors();
        ModelMBeanConstructorInfo[] modelMBeanConstructorInfoArray = new ModelMBeanConstructorInfo[constructorInfoArray.length];
        for (int i = 0; i < constructorInfoArray.length; ++i) {
            modelMBeanConstructorInfoArray[i] = constructorInfoArray[i].createConstructorInfo();
        }
        NotificationInfo[] notificationInfoArray = this.getNotifications();
        ModelMBeanNotificationInfo[] modelMBeanNotificationInfoArray = new ModelMBeanNotificationInfo[notificationInfoArray.length];
        for (int i = 0; i < notificationInfoArray.length; ++i) {
            modelMBeanNotificationInfoArray[i] = notificationInfoArray[i].createNotificationInfo();
        }
        OperationInfo[] operationInfoArray = this.getOperations();
        ModelMBeanOperationInfo[] modelMBeanOperationInfoArray = new ModelMBeanOperationInfo[operationInfoArray.length];
        for (int i = 0; i < operationInfoArray.length; ++i) {
            modelMBeanOperationInfoArray[i] = operationInfoArray[i].createOperationInfo();
        }
        this.info = new ModelMBeanInfoSupport(this.getClassName(), this.getDescription(), modelMBeanAttributeInfoArray, modelMBeanConstructorInfoArray, modelMBeanOperationInfoArray, modelMBeanNotificationInfoArray);
        try {
            Descriptor descriptor = this.info.getMBeanDescriptor();
            for (FieldInfo fieldInfo : this.getFields()) {
                descriptor.setField(fieldInfo.getName(), fieldInfo.getValue());
            }
            this.info.setMBeanDescriptor(descriptor);
        }
        catch (MBeanException mBeanException) {
            // empty catch block
        }
        return this.info;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ManagedBean[");
        stringBuffer.append("name=");
        stringBuffer.append(this.name);
        stringBuffer.append(", className=");
        stringBuffer.append(this.className);
        stringBuffer.append(", description=");
        stringBuffer.append(this.description);
        if (this.group != null) {
            stringBuffer.append(", group=");
            stringBuffer.append(this.group);
        }
        stringBuffer.append(", type=");
        stringBuffer.append(this.type);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

