/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.streamnamealias;

import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.streamnamealias.StreamNameAliasFile;
import com.wowza.wms.plugin.streamnamealias.StreamNameAliasFiles;
import com.wowza.wms.plugin.streamnamealias.StreamNameAliasMatch;
import com.wowza.wms.stream.IMediaStreamNameAliasProvider;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ModuleStreamNameAlias
extends ModuleBase
implements IMediaStreamNameAliasProvider {
    public static final String STREAMALIASFILE_PROPERTY = "aliasMapFileStream";
    public static final String PLAYALIASFILE_PROPERTY = "aliasMapFilePlay";
    public static final String STREAMALIASDEBUG_PROPERTY = "aliasMapDebug";
    public static final String STREAMALIASPATHDELIMITER_PROPERTY = "aliasMapPathDelimiter";
    public static final String STREAMALIASNAMEDELIMITER_PROPERTY = "aliasMapNameDelimiter";
    private Map<String, String> envMap = new HashMap<String, String>();
    private File streamFilePtr = null;
    private File playFilePtr = null;
    private boolean debug = false;
    private String pathDelimiter = "/";
    private String nameDelimiter = "=";

    public void onAppStart(IApplicationInstance appInstance) {
        WMSProperties props = appInstance.getProperties();
        this.debug = props.getPropertyBoolean(STREAMALIASDEBUG_PROPERTY, this.debug);
        this.pathDelimiter = props.getPropertyStr(STREAMALIASPATHDELIMITER_PROPERTY, this.pathDelimiter);
        this.nameDelimiter = props.getPropertyStr(STREAMALIASNAMEDELIMITER_PROPERTY, this.nameDelimiter);
        StreamNameAliasFiles.setNameDelimeter(this.nameDelimiter);
        HashMap<String, String> pathMap = new HashMap<String, String>();
        pathMap.put("com.wowza.wms.context.VHost", appInstance.getVHost().getName());
        pathMap.put("com.wowza.wms.context.VHostConfigHome", appInstance.getVHost().getHomePath());
        pathMap.put("com.wowza.wms.context.Application", appInstance.getApplication().getName());
        pathMap.put("com.wowza.wms.context.ApplicationInstance", appInstance.getName());
        String aliasPath = props.getPropertyStr(STREAMALIASFILE_PROPERTY);
        if (aliasPath == null) {
            ModuleStreamNameAlias.getLogger().warn("ModuleStreamNameAlias.onAppStart: Property aliasMapFileStream is missing. Can't find alias file.");
        } else {
            aliasPath = SystemUtils.expandEnvironmentVariables((String)aliasPath, pathMap);
            this.streamFilePtr = new File(aliasPath);
            if (this.debug) {
                ModuleStreamNameAlias.getLogger().info("ModuleStreamNameAlias.onAppStart: aliasMapFileStream: " + this.streamFilePtr.getAbsolutePath());
            }
        }
        aliasPath = props.getPropertyStr(PLAYALIASFILE_PROPERTY);
        if (aliasPath == null) {
            ModuleStreamNameAlias.getLogger().warn("ModuleStreamNameAlias.onAppStart: Property aliasMapFilePlay is missing. Can't find alias file.");
        } else {
            aliasPath = SystemUtils.expandEnvironmentVariables((String)aliasPath, pathMap);
            this.playFilePtr = new File(aliasPath);
            if (this.debug) {
                ModuleStreamNameAlias.getLogger().info("ModuleStreamNameAlias.onAppStart: aliasMapFilePlay: " + this.playFilePtr.getAbsolutePath());
            }
        }
        this.envMap.put("VHost.Name", appInstance.getVHost().getName());
        this.envMap.put("Application.Name", appInstance.getApplication().getName());
        this.envMap.put("ApplicationInstance.Name", appInstance.getName());
        this.envMap.put("AppInstance.Name", appInstance.getName());
        appInstance.setStreamNameAliasProvider((IMediaStreamNameAliasProvider)this);
    }

    public void onAppStop(IApplicationInstance appInstance) {
        ModuleStreamNameAlias.getLogger().info("ModuleStreamNameAlias.onAppStop: " + appInstance.getApplication().getName() + "/" + appInstance.getName());
    }

    private String nameToAlias(String aliasType, File filePtr, String streamName) {
        String ret = null;
        if (filePtr == null) {
            if (this.debug) {
                ModuleStreamNameAlias.getLogger().info("ModuleStreamNameAlias.nameToAlias[" + aliasType + "]: filePtr is null");
            }
        } else {
            StreamNameAliasFiles aliasFiles = StreamNameAliasFiles.getInstance();
            if (aliasFiles == null) {
                if (this.debug) {
                    ModuleStreamNameAlias.getLogger().info("ModuleStreamNameAlias.nameToAlias[" + aliasType + "]: aliasFiles is null");
                }
            } else {
                StreamNameAliasFile aliasFile = aliasFiles.getMapFile(filePtr);
                if (aliasFile == null) {
                    if (this.debug) {
                        ModuleStreamNameAlias.getLogger().info("ModuleStreamNameAlias.nameToAlias[" + aliasType + "]: aliasFile missing: " + filePtr.getAbsolutePath());
                    }
                } else {
                    StreamNameAliasMatch aliasMatch = aliasFile.findMap(streamName);
                    if (aliasMatch == null) {
                        if (this.debug) {
                            ModuleStreamNameAlias.getLogger().info("ModuleStreamNameAlias.nameToAlias[" + aliasType + "]: Can't find alias entry for: " + streamName);
                        }
                    } else {
                        HashMap<String, String> sendMap = new HashMap<String, String>();
                        sendMap.putAll(this.envMap);
                        sendMap.put("Stream.Name", streamName);
                        if (streamName.indexOf(this.pathDelimiter) >= 0) {
                            String[] parts = streamName.split("[" + this.pathDelimiter + "]");
                            int i = 0;
                            while (i < parts.length) {
                                sendMap.put("Stream.Name.Part" + (i + 1), parts[i]);
                                ++i;
                            }
                        } else {
                            sendMap.put("Stream.Name.Part1", streamName);
                        }
                        if (aliasMatch.wildcardMatches != null) {
                            int gindex = 0;
                            for (String value : aliasMatch.wildcardMatches) {
                                sendMap.put("Wildcard.Match" + (gindex + 1), value);
                                ++gindex;
                            }
                        }
                        ret = SystemUtils.expandEnvironmentVariables((String)aliasMatch.alias, sendMap);
                        if (this.debug) {
                            ModuleStreamNameAlias.getLogger().info("ModuleStreamNameAlias.nameToAlias[" + aliasType + "]: streamName:" + streamName + " alias:" + aliasMatch + " result:" + ret);
                        }
                    }
                }
            }
        }
        return ret;
    }

    public String resolvePlayAlias(IApplicationInstance appInstance, String name) {
        return this.nameToAlias("play", this.playFilePtr, name);
    }

    public String resolveStreamAlias(IApplicationInstance appInstance, String name) {
        return this.nameToAlias("stream", this.streamFilePtr, name);
    }
}

