/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.security;

import com.wowza.util.XMLUtils;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.security.HTTPSecureTokens;
import com.wowza.wms.plugin.security.SecureToken;
import com.wowza.wms.plugin.security.SecureTokenDef;
import com.wowza.wms.vhost.IVHost;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecureTokenManager {
    private static Map instances = new HashMap();
    private Map tokenLists = new HashMap();
    private Map secureTokenDefs = new HashMap();
    private Map clientMap = new HashMap();

    public static SecureTokenManager getInstance(IVHost iVHost) {
        SecureTokenManager secureTokenManager = (SecureTokenManager)instances.get(iVHost);
        if (secureTokenManager == null) {
            secureTokenManager = new SecureTokenManager();
            secureTokenManager.loadConfig(iVHost);
            instances.put(iVHost, secureTokenManager);
        }
        return secureTokenManager;
    }

    public void loadConfig(IVHost iVHost) {
        String string = iVHost.getHomePath() + "/conf/SecureTokens.xml";
        File file = new File(string);
        if (file.exists()) {
            WMSLoggerFactory.getLogger(HTTPSecureTokens.class).info("HTTPSecureTokens: loading config: " + string);
            this.loadConfigFile(iVHost, new File(string));
        }
    }

    private void loadConfigFile(IVHost iVHost, File file) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                String string = "/Root/SecureTokens/SecureToken";
                XPathExpression xPathExpression = xPath.compile(string);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                if (nodeList != null) {
                    SecureTokenManager secureTokenManager = this;
                    Map map = secureTokenManager.getSecureTokenDefs();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        Element element2 = (Element)node;
                        String string2 = XMLUtils.getXMLPropertyStr((XPath)xPath, (String)"Name", (Element)element2, null);
                        String string3 = XMLUtils.getXMLPropertyStr((XPath)xPath, (String)"SharedSecret", (Element)element2, null);
                        if (string2 != null && string3 != null) {
                            SecureTokenDef secureTokenDef = new SecureTokenDef(string2, string3);
                            String string4 = XMLUtils.getXMLPropertyStr((XPath)xPath, (String)"ClientAction", (Element)element2, null);
                            if (string4 != null) {
                                if (string4.equalsIgnoreCase("kill")) {
                                    secureTokenDef.setDoKill(true);
                                }
                                if (string4.equalsIgnoreCase("notify")) {
                                    secureTokenDef.setDoNotify(true);
                                }
                            }
                            map.put(string2, secureTokenDef);
                            WMSLoggerFactory.getLogger(HTTPSecureTokens.class).info("HTTPSecureTokens: SecureToken: " + string2);
                            continue;
                        }
                        WMSLoggerFactory.getLogger(HTTPSecureTokens.class).error("HTTPSecureTokens: loadConfigFile: error parsing secure token file: Name and SharedSecret elements required.");
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPSecureTokens.class).error("HTTPSecureTokens: loadConfigFile: error parsing secure token file: (" + file + ") error: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public Map getTokenList() {
        return this.tokenLists;
    }

    public String newGUID() {
        return UUID.randomUUID().toString();
    }

    public Map getSecureTokenDefs() {
        return this.secureTokenDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClient(IClient iClient, SecureToken secureToken) {
        Map map = this.clientMap;
        synchronized (map) {
            this.clientMap.put(iClient, secureToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecureToken unregisterClient(IClient iClient) {
        SecureToken secureToken = null;
        Map map = this.clientMap;
        synchronized (map) {
            secureToken = (SecureToken)this.clientMap.remove(iClient);
        }
        return secureToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecureToken getSecureTokenByClient(IClient iClient) {
        SecureToken secureToken = null;
        Map map = this.clientMap;
        synchronized (map) {
            secureToken = (SecureToken)this.clientMap.get(iClient);
        }
        return secureToken;
    }
}

