/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.nio.ByteBuffer;
import java.util.Date;

public class AMFUtils {
    public static AMFData[] convertParams(Object[] objectArray) {
        AMFData[] aMFDataArray = null;
        if (objectArray != null && objectArray.length > 0) {
            aMFDataArray = new AMFData[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                try {
                    if (object == null) {
                        aMFDataArray[i] = new AMFDataItem();
                        continue;
                    }
                    if (object instanceof Double) {
                        aMFDataArray[i] = new AMFDataItem((Double)object);
                        continue;
                    }
                    if (object instanceof Float) {
                        aMFDataArray[i] = new AMFDataItem(((Float)object).doubleValue());
                        continue;
                    }
                    if (object instanceof Long) {
                        aMFDataArray[i] = new AMFDataItem((Long)object);
                        continue;
                    }
                    if (object instanceof Integer) {
                        aMFDataArray[i] = new AMFDataItem((Integer)object);
                        continue;
                    }
                    if (object instanceof Short) {
                        aMFDataArray[i] = new AMFDataItem(((Short)object).intValue());
                        continue;
                    }
                    if (object instanceof Byte) {
                        aMFDataArray[i] = new AMFDataItem(((Byte)object).intValue());
                        continue;
                    }
                    if (object instanceof Number) {
                        aMFDataArray[i] = new AMFDataItem(((Number)object).doubleValue());
                        continue;
                    }
                    if (object instanceof Date) {
                        aMFDataArray[i] = new AMFDataItem((Date)object);
                        continue;
                    }
                    if (object instanceof Boolean) {
                        aMFDataArray[i] = new AMFDataItem((Boolean)object);
                        continue;
                    }
                    if (object instanceof String) {
                        aMFDataArray[i] = new AMFDataItem((String)object);
                        continue;
                    }
                    if (object instanceof StringBuffer) {
                        aMFDataArray[i] = new AMFDataItem(((StringBuffer)object).toString());
                        continue;
                    }
                    if (object instanceof byte[]) {
                        aMFDataArray[i] = new AMFDataItem((byte[])object);
                        continue;
                    }
                    if (object instanceof ByteBuffer) {
                        aMFDataArray[i] = new AMFDataItem(((ByteBuffer)object).array());
                        continue;
                    }
                    if (object instanceof AMFData || object instanceof AMFDataMixedArray || object instanceof AMFDataArray || object instanceof AMFDataItem || object instanceof AMFDataList || object instanceof AMFDataObj) {
                        aMFDataArray[i] = (AMFData)object;
                        continue;
                    }
                    aMFDataArray[i] = new AMFDataItem(object.toString());
                    continue;
                }
                catch (Exception exception) {
                    aMFDataArray[i] = new AMFDataItem("error");
                    WMSLoggerFactory.getLogger(AMFUtils.class).error("convertParams: " + object.getClass().getName() + " :" + exception.toString());
                }
            }
        }
        return aMFDataArray;
    }
}

