/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.admin;

import com.wowza.wms.admin.AdminAgent;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.client.IClientNotify;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHost;
import org.apache.commons.modeler.Registry;
import org.apache.mina.common.IoSession;

public class AdminClientListener
implements IClientNotify {
    public static final String CLIENT_OBJECTNAME = "clients=Clients,clientId=";
    public static final String CLIENT_FILTERNAME = "Client";
    private AdminAgent adminAgent = null;
    private IVHost vhost = null;
    private IApplication application = null;
    private IApplicationInstance applicationInstance = null;
    private boolean isActive = true;

    public AdminClientListener(AdminAgent adminAgent, IVHost iVHost, IApplication iApplication, IApplicationInstance iApplicationInstance) {
        this.adminAgent = adminAgent;
        this.vhost = iVHost;
        this.application = iApplication;
        this.applicationInstance = iApplicationInstance;
        this.isActive = Server.getInstance().getAdminInterfaceObjectList().contains(CLIENT_FILTERNAME.toLowerCase());
    }

    private String getObjectName(IClient iClient) {
        return "WowzaMediaServerPro:vHosts=VHosts,vHostName=" + this.vhost.getName() + "," + "applications=Applications,applicationName=" + this.application.getName() + "," + "applicationInstances=ApplicationInstances,applicationInstanceName=" + this.applicationInstance.getName() + "," + CLIENT_OBJECTNAME + iClient.getClientId();
    }

    public void onClientConnect(IClient iClient) {
        try {
            if (this.isActive) {
                Registry.getRegistry(null, null).registerComponent((Object)iClient, this.getObjectName(iClient) + ",name=Client", iClient.getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iClient.getTotalIOPerformanceCounter(), this.getObjectName(iClient) + ",name=TotalIOPerformance", iClient.getTotalIOPerformanceCounter().getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iClient.getMediaIOPerformanceCounter(), this.getObjectName(iClient) + ",name=MediaIOPerformance", iClient.getMediaIOPerformanceCounter().getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iClient.getProperties(), this.getObjectName(iClient) + ",name=Properties", iClient.getProperties().getClass().getName());
                IoSession ioSession = ((Client)iClient).getIoSession();
                if (ioSession != null) {
                    Registry.getRegistry(null, null).registerComponent((Object)ioSession, this.getObjectName(iClient) + ",name=IoSession", ioSession.getClass().getName());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminClientListener.class).error("onClientConnect: " + exception.toString());
        }
    }

    public void onClientDisconnect(IClient iClient) {
        try {
            if (this.isActive) {
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iClient) + ",name=Client");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iClient) + ",name=TotalIOPerformance");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iClient) + ",name=MediaIOPerformance");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iClient) + ",name=Properties");
                IoSession ioSession = ((Client)iClient).getIoSession();
                if (ioSession != null) {
                    Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iClient) + ",name=IoSession");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminClientListener.class).error("onClientDisconnect: " + exception.toString());
        }
    }

    public void onClientAccept(IClient iClient) {
    }

    public void onClientReject(IClient iClient) {
    }
}

