/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.admin;

import com.wowza.wms.admin.AdminAgent;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Server;
import com.wowza.wms.sharedobject.ISharedObject;
import com.wowza.wms.sharedobject.ISharedObjectNotify;
import com.wowza.wms.vhost.IVHost;
import org.apache.commons.modeler.Registry;

public class AdminSharedObjectListener
implements ISharedObjectNotify {
    public static final String SHAREDOBJECTSTORED_OBJECTNAME = "sharedObjects=SharedObjects,sharedObjectType=Stored,sharedObjectName=";
    public static final String SHAREDOBJECTTEMP_OBJECTNAME = "sharedObjects=SharedObjects,sharedObjectType=Temp,sharedObjectName=";
    public static final String SHAREDOBJECT_FILTERNAME = "SharedObject";
    private AdminAgent adminAgent = null;
    private IVHost vhost = null;
    private IApplication application = null;
    private IApplicationInstance applicationInstance = null;
    private boolean isActive = true;

    public AdminSharedObjectListener(AdminAgent adminAgent, IVHost iVHost, IApplication iApplication, IApplicationInstance iApplicationInstance) {
        this.adminAgent = adminAgent;
        this.vhost = iVHost;
        this.application = iApplication;
        this.applicationInstance = iApplicationInstance;
        this.isActive = Server.getInstance().getAdminInterfaceObjectList().contains(SHAREDOBJECT_FILTERNAME.toLowerCase());
    }

    private String getObjectName(ISharedObject iSharedObject) {
        return "WowzaMediaServerPro:vHosts=VHosts,vHostName=" + this.vhost.getName() + "," + "applications=Applications,applicationName=" + this.application.getName() + "," + "applicationInstances=ApplicationInstances,applicationInstanceName=" + this.applicationInstance.getName() + "," + (iSharedObject.isPersistent() ? SHAREDOBJECTSTORED_OBJECTNAME : SHAREDOBJECTTEMP_OBJECTNAME) + iSharedObject.getName();
    }

    public void onSharedObjectCreate(ISharedObject iSharedObject) {
        try {
            if (this.isActive) {
                Registry.getRegistry(null, null).registerComponent((Object)iSharedObject, this.getObjectName(iSharedObject) + ",name=SharedObject", iSharedObject.getClass().getName());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminSharedObjectListener.class).error("onSharedObjectCreate: " + exception.toString());
        }
    }

    public void onSharedObjectDestroy(ISharedObject iSharedObject) {
        try {
            if (this.isActive) {
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iSharedObject) + ",name=SharedObject");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminSharedObjectListener.class).error("onSharedObjectDestroy: " + exception.toString());
        }
    }

    public void onSharedObjectConnect(ISharedObject iSharedObject, IClient iClient) {
    }

    public void onSharedObjectDisconnect(ISharedObject iSharedObject, IClient iClient) {
    }
}

