/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.admin;

import com.wowza.wms.admin.AdminAgent;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHostItemNotify;
import com.wowza.wms.vhost.VHostItem;
import org.apache.commons.modeler.Registry;

public class AdminVHostItemListener
implements IVHostItemNotify {
    public static final String VHOSTITEM_OBJECTNAME = "vhostItems=VHostConfigs,vhostItem=";
    public static final String VHOSTITEM_FILTERNAME = "VHostItem";
    private AdminAgent adminAgent = null;
    private boolean isActive = true;

    public AdminVHostItemListener(AdminAgent adminAgent) {
        this.adminAgent = adminAgent;
        this.isActive = Server.getInstance().getAdminInterfaceObjectList().contains(VHOSTITEM_FILTERNAME.toLowerCase());
    }

    private String getObjectName(VHostItem vHostItem) {
        return "WowzaMediaServerPro:vhostItems=VHostConfigs,vhostItem=" + vHostItem.getName();
    }

    public void onVHostItemCreate(VHostItem vHostItem) {
        try {
            if (this.isActive) {
                Registry.getRegistry(null, null).registerComponent((Object)vHostItem, this.getObjectName(vHostItem) + ",name=VHostItem", vHostItem.getClass().getName());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminVHostItemListener.class).error("onVHostItemCreate: " + exception.toString());
        }
    }

    public void onVHostItemUpdate(VHostItem vHostItem) {
    }

    public void onVHostItemDestroy(VHostItem vHostItem) {
        try {
            if (this.isActive) {
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(vHostItem) + ",name=VHostItem");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminVHostItemListener.class).error("onVHostItemDestroy: " + exception.toString());
        }
    }
}

