/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.drm.playready;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.wms.drm.playready.PlayReadyUtils;
import com.wowza.wms.logging.WMSLoggerFactory;

public class PlayReadyKeyInfo {
    public static final String KEYPARAMPREFIX_SMOOTHSTREAMING = "smoothstreaming-playready-";
    public static final int ALGORITHMID_NONE = 0;
    public static final int ALGORITHMID_CTR = 1;
    public static final int ALGORITHMID_CBC = 2;
    int algorithmId = 1;
    byte[] keyId = null;
    byte[] seed = null;
    byte[] contentKey = null;
    byte[] checksum = null;
    String licenseURL = null;
    private int ivLen = 16;

    public boolean isComplete() {
        return this.contentKey != null && this.algorithmId != 0 && this.checksum != null && this.licenseURL != null;
    }

    public String getKeyIdAsString() {
        String string;
        String string2 = string = this.keyId == null ? "" : BufferUtils.encodeHexString(this.keyId).toUpperCase();
        if (string.length() == 32) {
            string = string.substring(0, 8) + "-" + string.substring(8, 12) + "-" + string.substring(12, 16) + "-" + string.substring(16, 20) + "-" + string.substring(20);
        }
        return string;
    }

    public byte[] getKeyId() {
        return this.keyId;
    }

    public void setKeyId(byte[] byArray) {
        this.keyId = byArray;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public void setSeed(byte[] byArray) {
        this.seed = byArray;
    }

    public byte[] getContentKey() {
        return this.contentKey;
    }

    public void setContentKey(byte[] byArray) {
        this.contentKey = byArray;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public void setChecksum(byte[] byArray) {
        this.checksum = byArray;
    }

    public String getLicenseURL() {
        return this.licenseURL;
    }

    public void setLicenseURL(String string) {
        this.licenseURL = string;
    }

    public String getWRMHeaderStr() {
        Object object;
        String string = this.checksum == null ? "" : Base64.encodeBytes(this.checksum);
        String string2 = this.licenseURL == null ? "" : this.licenseURL;
        int n = this.keyId == null ? 16 : this.keyId.length;
        String string3 = "";
        if (this.keyId != null) {
            object = new byte[this.keyId.length];
            System.arraycopy(this.keyId, 0, object, 0, this.keyId.length);
            if (this.keyId.length == 16) {
                object[0] = this.keyId[3];
                object[1] = this.keyId[2];
                object[2] = this.keyId[1];
                object[3] = this.keyId[0];
                object[4] = this.keyId[5];
                object[5] = this.keyId[4];
                object[6] = this.keyId[7];
                object[7] = this.keyId[6];
            }
            string3 = Base64.encodeBytes(object);
        }
        object = "<WRMHEADER xmlns=\"http://schemas.microsoft.com/DRM/2007/03/PlayReadyHeader\" version=\"4.0.0.0\"><DATA><PROTECTINFO><KEYLEN>" + n + "</KEYLEN><ALGID>" + PlayReadyUtils.algorithmIdToString(this.algorithmId) + "</ALGID></PROTECTINFO><KID>" + string3 + "</KID><CHECKSUM>" + string + "</CHECKSUM><LA_URL>" + string2 + "</LA_URL></DATA></WRMHEADER>";
        return object;
    }

    public byte[] getProtectionHeaderBytes() {
        byte[] byArray = null;
        try {
            String string = this.getWRMHeaderStr();
            byte[] byArray2 = string.getBytes("UTF-16");
            int n = byArray2.length - 2;
            int n2 = 10254 + n;
            byArray = new byte[n2];
            int n3 = 0;
            BufferUtils.intToByteArray(n2, byArray, n3, 4, true);
            byArray[n3 += 4] = 2;
            byArray[++n3] = 0;
            byArray[++n3] = 1;
            byArray[++n3] = 0;
            BufferUtils.intToByteArray(n, byArray, ++n3, 2, true);
            n3 += 2;
            for (int i = 0; i < n / 2; ++i) {
                byArray[n3 + i * 2 + 0] = byArray2[2 + i * 2 + 1];
                byArray[n3 + i * 2 + 1] = byArray2[2 + i * 2 + 0];
            }
            byArray[n3 += n] = 3;
            byArray[++n3] = 0;
            byArray[++n3] = 0;
            byArray[++n3] = 40;
            ++n3;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(PlayReadyKeyInfo.class).error("PlayReadyKeyInfo.getWRMHeaderBytes: " + exception.toString());
        }
        return byArray;
    }

    public int getIvLen() {
        return this.ivLen;
    }

    public void setIvLen(int n) {
        this.ivLen = n;
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    public void setAlgorithmId(int n) {
        this.algorithmId = n;
    }
}

