/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.http;

import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.ConnectionCounter;
import com.wowza.wms.client.IClient;
import com.wowza.wms.http.HTTPServerVersion;
import com.wowza.wms.http.HTTProvider2Base;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.OutputStream;
import java.util.List;

public class HTTPServerInfoXML
extends HTTProvider2Base {
    private void outputConnectionInfo(StringBuffer stringBuffer, ConnectionCounter connectionCounter) {
        stringBuffer.append("<ConnectionsCurrent>" + connectionCounter.getCurrent() + "</ConnectionsCurrent>");
        stringBuffer.append("<ConnectionsTotal>" + connectionCounter.getTotal() + "</ConnectionsTotal>");
        stringBuffer.append("<ConnectionsTotalAccepted>" + connectionCounter.getTotalAccepted() + "</ConnectionsTotalAccepted>");
        stringBuffer.append("<ConnectionsTotalRejected>" + connectionCounter.getTotalRejected() + "</ConnectionsTotalRejected>");
    }

    public void onHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        Object object;
        Object object2;
        if (!this.doHTTPAuthentication(iVHost, iHTTPRequest, iHTTPResponse)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            object2 = VHostSingleton.getVHostNames();
            stringBuffer.append("<?xml version=\"1.0\"?>\n<WowzaMediaServerPro>");
            object = object2.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                IVHost iVHost2 = VHostSingleton.getInstance(string);
                if (iVHost2 == null) continue;
                stringBuffer.append("<VHost>");
                stringBuffer.append("<Name>" + string + "</Name>");
                stringBuffer.append("<TimeRunning>" + iVHost2.getTimeRunningSeconds() + "</TimeRunning>");
                stringBuffer.append("<ConnectionsLimit>" + iVHost2.getConnectionLimit() + "</ConnectionsLimit>");
                this.outputConnectionInfo(stringBuffer, iVHost2.getConnectionCounter());
                List list = iVHost2.getApplicationNames();
                List list2 = iVHost2.getApplicationFolderNames();
                for (String string2 : list2) {
                    stringBuffer.append("<Application>");
                    stringBuffer.append("<Name><![CDATA[" + string2 + "]]></Name>");
                    boolean bl = list.contains(string2);
                    stringBuffer.append("<Status>" + (bl ? "loaded" : "unloaded") + "</Status>");
                    if (bl) {
                        IApplication iApplication = iVHost2.getApplication(string2);
                        if (iApplication == null) continue;
                        stringBuffer.append("<TimeRunning>" + iApplication.getTimeRunningSeconds() + "</TimeRunning>");
                        this.outputConnectionInfo(stringBuffer, iApplication.getConnectionCounter());
                        List<String> list3 = iApplication.getAppInstanceNames();
                        for (String string3 : list3) {
                            IApplicationInstance iApplicationInstance = iApplication.getAppInstance(string3);
                            if (iApplicationInstance == null) continue;
                            stringBuffer.append("<ApplicationInstance>");
                            stringBuffer.append("<Name><![CDATA[" + iApplicationInstance.getName() + "]]></Name>");
                            stringBuffer.append("<TimeRunning>" + iApplicationInstance.getTimeRunningSeconds() + "</TimeRunning>");
                            this.outputConnectionInfo(stringBuffer, iApplicationInstance.getConnectionCounter());
                            List<IClient> list4 = iApplicationInstance.getClients();
                            for (IClient iClient : list4) {
                                if (iClient == null) continue;
                                stringBuffer.append("<Client>");
                                stringBuffer.append("<ClientId>" + iClient.getClientId() + "</ClientId>");
                                stringBuffer.append("<FlashVersion>" + iClient.getFlashVer() + "</FlashVersion>");
                                stringBuffer.append("<IpAddress>" + iClient.getIp() + "</IpAddress>");
                                stringBuffer.append("<Referrer><![CDATA[" + iClient.getReferrer() + "]]></Referrer>");
                                stringBuffer.append("<TimeRunning>" + iClient.getTimeRunningSeconds() + "</TimeRunning>");
                                stringBuffer.append("<DateStarted>" + iClient.getDateStarted() + "</DateStarted>");
                                stringBuffer.append("<URI><![CDATA[" + iClient.getUri() + "]]></URI>");
                                String string4 = "unknown";
                                switch (iClient.getProtocol()) {
                                    case 1: {
                                        string4 = iClient.isEncrypted() ? "RTMPE" : "RTMP";
                                        break;
                                    }
                                    case 3: {
                                        string4 = iClient.isSSL() ? "RTMPS" : (iClient.isEncrypted() ? "RTMPTE" : "RTMPT");
                                    }
                                }
                                stringBuffer.append("<Protocol>" + string4 + "</Protocol>");
                                stringBuffer.append("<IsSSL>" + iClient.isSSL() + "</IsSSL>");
                                stringBuffer.append("<IsEncrypted>" + iClient.isEncrypted() + "</IsEncrypted>");
                                stringBuffer.append("<Port>" + iClient.getServerHostPort().getPort() + "</Port>");
                                stringBuffer.append("</Client>");
                            }
                            stringBuffer.append("</ApplicationInstance>");
                        }
                    }
                    stringBuffer.append("</Application>");
                }
                stringBuffer.append("</VHost>");
            }
            stringBuffer.append("</WowzaMediaServerPro>");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPServerVersion.class).error("HTTPServerInfoXML.onHTTPRequest: " + exception.toString());
            exception.printStackTrace();
        }
        try {
            iHTTPResponse.setHeader("Content-Type", "text/xml");
            object2 = iHTTPResponse.getOutputStream();
            object = stringBuffer.toString().getBytes();
            ((OutputStream)object2).write((byte[])object);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPServerVersion.class).error("HTTPServerInfoXML.onHTTPRequest: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

