/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.logging;

import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostWorkerThread;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSLoggerFactory
implements LoggerFactory {
    public static final String LOGGERNAME_SERVER = "_Server_";
    private static WMSLoggerFactory logFactory = null;
    private Map loggers = new HashMap();

    public WMSLogger getLoggerObj(String string) {
        WMSLogger wMSLogger = (WMSLogger)((Object)this.loggers.get(string));
        if (wMSLogger == null) {
            wMSLogger = WMSLogger.getLogger(string);
            this.loggers.put(string, wMSLogger);
        }
        return wMSLogger;
    }

    public WMSLogger forceNewLoggerInstance(String string, Logger logger) {
        WMSLogger wMSLogger = (WMSLogger)((Object)this.loggers.get(string));
        if (wMSLogger == null) {
            wMSLogger = new WMSLogger(string, logger);
            this.loggers.put(string, wMSLogger);
        }
        return wMSLogger;
    }

    public static WMSLoggerFactory getInstance() {
        if (logFactory == null) {
            logFactory = new WMSLoggerFactory();
        }
        return logFactory;
    }

    private static void initEnvMap(Map<String, String> map, IVHost iVHost, IApplication iApplication, IApplicationInstance iApplicationInstance) {
        map.put("com.wowza.wms.AppHome", Bootstrap.getServerHome((int)1));
        map.put("com.wowza.wms.ConfigHome", Bootstrap.getServerHome((int)2));
        if (iVHost != null) {
            map.put("com.wowza.wms.context.VHost", iVHost.getName());
            map.put("com.wowza.wms.context.VHostConfigHome", iVHost.getHomePath());
        }
        if (iApplication != null) {
            map.put("com.wowza.wms.context.Application", iApplication.getName());
        }
        if (iApplicationInstance != null) {
            map.put("com.wowza.wms.context.ApplicationInstance", iApplicationInstance.getName());
        }
    }

    private static void initLoggingProps(Properties properties) {
        String string = "log4j.loggerFactory";
        String string2 = "com.wowza.wms.logging.WMSLoggerFactory";
        properties.setProperty(string, string2);
    }

    private static void mergeContextProperties(Properties properties, Properties properties2, Map<String, String> map, String string, String[] stringArray) {
        for (String string2 : properties2.keySet()) {
            String string3 = properties2.getProperty(string2);
            if (stringArray.length > 0) {
                int n;
                for (n = 0; n < stringArray.length && string2.indexOf(stringArray[n]) < 0; ++n) {
                }
                if (n < stringArray.length) continue;
            }
            if (string2.indexOf(string) < 0) continue;
            String string4 = SystemUtils.expandEnvironmentVariables(string2, map);
            string3 = SystemUtils.expandEnvironmentVariables(string3, map);
            properties.put(string4, string3);
        }
    }

    public static void initContextLogging(IVHost iVHost) {
        block3: {
            String string;
            Server server = Server.getInstance();
            if (server == null || iVHost == null) break block3;
            Properties properties = iVHost.getDynamicLogProperties();
            if (properties == null) {
                properties = server.getDynamicLogProperties();
            }
            if (properties != null && properties.size() > 0 && !server.isDynamicLogContextLoaded(string = iVHost.getName())) {
                Properties properties2 = new Properties();
                WMSLoggerFactory.initLoggingProps(properties2);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                WMSLoggerFactory.initEnvMap(hashMap, iVHost, null, null);
                String[] stringArray = new String[]{"${com.wowza.wms.context.Application}", "${com.wowza.wms.context.ApplicationInstance}"};
                WMSLoggerFactory.mergeContextProperties(properties2, properties, hashMap, "${com.wowza.wms.context.VHost}", stringArray);
                if (properties2.size() > 0) {
                    PropertyConfigurator.configure((Properties)properties2);
                }
            }
        }
    }

    public static void initContextLogging(IApplication iApplication) {
        block3: {
            String string;
            IVHost iVHost;
            Server server = Server.getInstance();
            if (server == null || (iVHost = iApplication.getVHost()) == null) break block3;
            Properties properties = iVHost.getDynamicLogProperties();
            if (properties == null) {
                properties = server.getDynamicLogProperties();
            }
            if (properties != null && !server.isDynamicLogContextLoaded(string = iVHost.getName() + "." + iApplication.getName())) {
                Properties properties2 = new Properties();
                WMSLoggerFactory.initLoggingProps(properties2);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                WMSLoggerFactory.initEnvMap(hashMap, iVHost, iApplication, null);
                String[] stringArray = new String[]{"${com.wowza.wms.context.ApplicationInstance}"};
                WMSLoggerFactory.mergeContextProperties(properties2, properties, hashMap, "${com.wowza.wms.context.Application}", stringArray);
                if (properties2.size() > 0) {
                    PropertyConfigurator.configure((Properties)properties2);
                }
            }
        }
    }

    public static void initContextLogging(IApplicationInstance iApplicationInstance) {
        block3: {
            String string;
            IVHost iVHost;
            IApplication iApplication;
            Server server = Server.getInstance();
            if (server == null || (iApplication = iApplicationInstance.getApplication()) == null || (iVHost = iApplication.getVHost()) == null) break block3;
            Properties properties = iVHost.getDynamicLogProperties();
            if (properties == null) {
                properties = server.getDynamicLogProperties();
            }
            if (properties != null && !server.isDynamicLogContextLoaded(string = iVHost.getName() + "." + iApplication.getName() + "." + iApplicationInstance.getName())) {
                Properties properties2 = new Properties();
                WMSLoggerFactory.initLoggingProps(properties2);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                WMSLoggerFactory.initEnvMap(hashMap, iVHost, iApplication, iApplicationInstance);
                String[] stringArray = new String[]{};
                WMSLoggerFactory.mergeContextProperties(properties2, properties, hashMap, "${com.wowza.wms.context.ApplicationInstance}", stringArray);
                if (properties2.size() > 0) {
                    PropertyConfigurator.configure((Properties)properties2);
                }
            }
        }
    }

    public static WMSLogger initializeLogging(String string) {
        return WMSLoggerFactory.initializeLogging(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WMSLogger initializeLogging(String string, IVHost iVHost) {
        WMSLogger wMSLogger = null;
        try {
            Object object;
            Object object2;
            Serializable serializable;
            System.out.println("Configure logging: " + string);
            String string2 = "log4j.loggerFactory";
            String string3 = "com.wowza.wms.logging.WMSLoggerFactory";
            Properties properties = new Properties();
            properties.setProperty(string2, string3);
            try {
                serializable = new URL(string);
                object2 = ((URL)serializable).openConnection();
                object = new BufferedInputStream(((URLConnection)object2).getInputStream());
                properties.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (Exception exception) {
                System.out.println("Error: log4j.properties not found: " + string);
            }
            serializable = new HashSet();
            serializable.addAll(properties.keySet());
            object2 = new Properties();
            object = serializable.iterator();
            while (object.hasNext()) {
                String string4 = (String)object.next();
                boolean bl = true;
                if (string4.indexOf("${com.wowza.wms.context.VHost}") >= 0 || string4.indexOf("${com.wowza.wms.context.Application}") >= 0 || string4.indexOf("${com.wowza.wms.context.ApplicationInstance}") >= 0) {
                    ((Properties)object2).put(string4, properties.get(string4));
                } else {
                    bl = false;
                }
                if (!bl) continue;
                properties.remove(string4);
            }
            if (((Properties)object2).size() > 0) {
                if (iVHost != null) {
                    iVHost.setDynamicLogProperties((Properties)object2);
                } else {
                    Server.getInstance().setDynamicLogProperties((Properties)object2);
                }
            }
            PropertyConfigurator.configure((Properties)properties);
        }
        catch (Exception exception) {
            System.out.println("Error: Server: problem configuring logging (" + string + "): " + exception.toString());
        }
        finally {
            wMSLogger = WMSLoggerFactory.getLogger(Server.class);
        }
        return wMSLogger;
    }

    public Logger makeNewLoggerInstance(String string) {
        return new WMSLogger(string);
    }

    public static void resetMDC() {
        if (MDC.getContext() != null) {
            MDC.getContext().clear();
        }
    }

    public static void removeGlobalLogValues() {
        WMSLoggerFactory.resetMDC();
    }

    public static void removeGlobalLogValue(String string) {
        MDC.remove((String)string);
    }

    public static boolean isGlobalLogValueSet(String string) {
        return MDC.get((String)string) != null;
    }

    public static void putGlobalLogValue(String string, Object object) {
        if (object != null) {
            MDC.put((String)string, (Object)object);
        } else {
            MDC.remove((String)string);
        }
    }

    public static Object getGlobalLogValue(String string) {
        return MDC.get((String)string);
    }

    public static WMSLogger getLoggerObj(IVHost iVHost) {
        String string = LOGGERNAME_SERVER;
        if (iVHost != null) {
            string = iVHost.getName();
        }
        WMSLogger wMSLogger = logFactory.getLoggerObj(string);
        return wMSLogger;
    }

    public static WMSLogger getLoggerObj(IApplication iApplication) {
        Object object;
        String string = LOGGERNAME_SERVER;
        if (iApplication != null && (object = iApplication.getVHost()) != null) {
            string = object.getName() + "." + iApplication.getName();
        }
        object = logFactory.getLoggerObj(string);
        return object;
    }

    public static WMSLogger getLoggerObj(IApplicationInstance iApplicationInstance) {
        IVHost iVHost;
        Object object;
        String string = LOGGERNAME_SERVER;
        if (iApplicationInstance != null && (object = iApplicationInstance.getApplication()) != null && (iVHost = object.getVHost()) != null) {
            string = iVHost.getName() + "." + object.getName() + "." + iApplicationInstance.getName();
        }
        object = logFactory.getLoggerObj(string);
        return object;
    }

    public static WMSLogger getLogger(Class clazz) {
        WMSLoggerFactory wMSLoggerFactory = WMSLoggerFactory.getInstance();
        String string = LOGGERNAME_SERVER;
        try {
            boolean bl = Thread.currentThread() instanceof VHostWorkerThread;
            if (bl) {
                string = ((VHostWorkerThread)Thread.currentThread()).getLogContext();
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: getLogger: " + exception.toString());
        }
        WMSLogger wMSLogger = wMSLoggerFactory.getLoggerObj(string);
        return wMSLogger;
    }
}

