/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.mediacaster.IMediaCasterDataReceiver;
import com.wowza.wms.vhost.VHost;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;

public class MediaCasterSessionHandler
extends IoHandlerAdapter {
    protected IMediaCaster mediaCaster = null;
    private int inHandler = 0;
    private IMediaCasterDataReceiver dataReceiver = null;

    public MediaCasterSessionHandler(IMediaCaster iMediaCaster, IMediaCasterDataReceiver iMediaCasterDataReceiver) {
        this.mediaCaster = iMediaCaster;
        this.dataReceiver = iMediaCasterDataReceiver;
    }

    public void sessionCreated(IoSession ioSession) {
        ioSession.setAttribute("messageQueue", new ArrayList());
        ioSession.setAttribute("mediaCaster", (Object)this.mediaCaster);
        ioSession.setAttribute("isIdleRunning", (Object)new Boolean(false));
    }

    public void sessionOpened(IoSession ioSession) {
        Object object;
        String string = "127.0.0.1";
        SocketAddress socketAddress = ioSession.getRemoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            object = (InetSocketAddress)socketAddress;
            string = ((InetSocketAddress)object).getAddress().toString().replace("/", "");
        }
        ioSession.setAttribute("remoteIp", (Object)string);
        object = (VHost)this.mediaCaster.getVHost();
        ((VHost)object).addSession(ioSession);
        this.mediaCaster.sessionOpened(ioSession);
        ((VHost)object).notifySessionOpen(ioSession, 16, null);
    }

    public void sessionClosed(IoSession ioSession) {
        VHost vHost = (VHost)this.mediaCaster.getVHost();
        this.mediaCaster.sessionClosed(ioSession);
        vHost.removeSession(ioSession);
    }

    private void handleMessageReceived(IoSession ioSession, Object object) {
        this.serviceRequest(ioSession, object);
    }

    private void handleSessionIdle(IoSession ioSession) {
        WMSLoggerFactory.getLogger(MediaCasterSessionHandler.class).debug("MediaCasterSessionHandler: handleSessionIdle");
        ioSession.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoSession ioSession, Object object) {
        MediaCasterSessionHandler mediaCasterSessionHandler;
        List list = (List)ioSession.getAttribute("messageQueue");
        Object object2 = this;
        synchronized (object2) {
            if (this.inHandler > 0) {
                list.add(object);
                return;
            }
            ++this.inHandler;
        }
        object2 = object;
        while (true) {
            if (object2 == null) {
                this.handleSessionIdle(ioSession);
            } else {
                this.handleMessageReceived(ioSession, object2);
            }
            mediaCasterSessionHandler = this;
            synchronized (mediaCasterSessionHandler) {
                if (list.size() <= 0) {
                    break;
                }
                object2 = list.remove(0);
            }
        }
        mediaCasterSessionHandler = this;
        synchronized (mediaCasterSessionHandler) {
            --this.inHandler;
        }
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        WMSLoggerFactory.getLogger(MediaCasterSessionHandler.class).debug("MediaCasterSessionHandler: exceptionCaught: " + throwable.toString());
        ioSession.close();
    }

    private void serviceRequest(IoSession ioSession, Object object) {
        if (this.dataReceiver != null) {
            this.dataReceiver.onData((ByteBuffer)object);
        }
    }
}

