/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster;

import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.module.IModuleOnApp;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleMediaCaster
extends ModuleBase
implements IModuleOnApp {
    Map<String, MediaCasterHolder> lockMap = new HashMap<String, MediaCasterHolder>();

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        ModuleMediaCaster.getLogger().info("ModuleMediaCaster.onAppStart: " + iApplicationInstance.getApplication().getName() + "/" + iApplicationInstance.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAppStop(IApplicationInstance iApplicationInstance) {
        ModuleMediaCaster.getLogger().info("ModuleMediaCaster.onAppStop: " + iApplicationInstance.getApplication().getName() + "/" + iApplicationInstance.getName());
        Map<String, MediaCasterHolder> map = this.lockMap;
        synchronized (map) {
            for (MediaCasterHolder mediaCasterHolder : this.lockMap.values()) {
                while (mediaCasterHolder.lockCount > 0) {
                    ModuleMediaCaster.getLogger().info("  release: " + mediaCasterHolder.streamName);
                    mediaCasterHolder.mediaCasterItem.release();
                    --mediaCasterHolder.lockCount;
                }
            }
            this.lockMap.clear();
        }
    }

    public void getLockCount(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        int n = 0;
        String string = aMFDataList.getString(3);
        IApplicationInstance iApplicationInstance = iClient.getAppInstance();
        MediaCasterStreamMap mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams();
        MediaCasterStreamItem mediaCasterStreamItem = mediaCasterStreamMap.getMediaCaster(string);
        if (mediaCasterStreamItem != null) {
            n = mediaCasterStreamItem.getLockCount();
        } else {
            ModuleMediaCaster.getLogger().info("ModuleMediaCaster.getLockCount: MediaCaster not found: " + string);
        }
        ModuleMediaCaster.sendResult(iClient, aMFDataList, n);
    }

    public void getPlayerCount(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        int n = 0;
        String string = aMFDataList.getString(3);
        IApplicationInstance iApplicationInstance = iClient.getAppInstance();
        MediaCasterStreamMap mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams();
        MediaCasterStreamItem mediaCasterStreamItem = mediaCasterStreamMap.getMediaCaster(string);
        if (mediaCasterStreamItem != null) {
            n = mediaCasterStreamItem.getPlayerCount();
        } else {
            ModuleMediaCaster.getLogger().info("ModuleMediaCaster.getPlayerCount: MediaCaster not found: " + string);
        }
        ModuleMediaCaster.sendResult(iClient, aMFDataList, n);
    }

    public void getStreamNames(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        AMFDataArray aMFDataArray = new AMFDataArray();
        IApplicationInstance iApplicationInstance = iClient.getAppInstance();
        MediaCasterStreamMap mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams();
        List<String> list = mediaCasterStreamMap.getMediaCasterNames();
        for (String string : list) {
            aMFDataArray.add(new AMFDataItem(string));
        }
        ModuleMediaCaster.sendResult(iClient, aMFDataList, aMFDataArray);
    }

    private void resetStream(IApplicationInstance iApplicationInstance, String string) {
        MediaCasterStreamMap mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams();
        MediaCasterStreamItem mediaCasterStreamItem = mediaCasterStreamMap.getMediaCaster(string);
        if (mediaCasterStreamItem != null) {
            mediaCasterStreamItem.reset();
        } else {
            ModuleMediaCaster.getLogger().info("ModuleMediaCaster.resetStream: MediaCaster not found: " + string);
        }
    }

    public void resetStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        IApplicationInstance iApplicationInstance = iClient.getAppInstance();
        MediaCasterStreamMap mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams();
        MediaCasterStreamItem mediaCasterStreamItem = mediaCasterStreamMap.getMediaCaster(string);
        if (mediaCasterStreamItem != null) {
            mediaCasterStreamItem.reset();
        } else {
            ModuleMediaCaster.getLogger().info("ModuleMediaCaster.resetStream: MediaCaster not found: " + string);
        }
    }

    public void shutdownStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        IApplicationInstance iApplicationInstance = iClient.getAppInstance();
        MediaCasterStreamMap mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams();
        MediaCasterStreamItem mediaCasterStreamItem = mediaCasterStreamMap.getMediaCaster(string);
        if (mediaCasterStreamItem != null) {
            mediaCasterStreamItem.shutdown(false);
        } else {
            ModuleMediaCaster.getLogger().info("ModuleMediaCaster.shutdownStream: MediaCaster not found: " + string);
        }
    }

    private MediaCasterStreamItem acquireMediaCaster(IApplicationInstance iApplicationInstance, String string, String string2) {
        if (string2 == null) {
            string2 = iApplicationInstance.getStreamType();
        }
        MediaCasterStreamMap mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams();
        MediaCasterStreamItem mediaCasterStreamItem = mediaCasterStreamMap.acquire(string, string2);
        return mediaCasterStreamItem;
    }

    private void releaseMediaCaster(MediaCasterStreamItem mediaCasterStreamItem) {
        mediaCasterStreamItem.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireMediaCaster(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        String string2 = 4 < aMFDataList.size() ? aMFDataList.getString(4) : null;
        Map<String, MediaCasterHolder> map = this.lockMap;
        synchronized (map) {
            MediaCasterHolder mediaCasterHolder = this.lockMap.get(string);
            if (mediaCasterHolder == null) {
                MediaCasterStreamMap mediaCasterStreamMap;
                MediaCasterStreamItem mediaCasterStreamItem;
                IApplicationInstance iApplicationInstance = iClient.getAppInstance();
                if (string2 == null) {
                    string2 = iApplicationInstance.getStreamType();
                }
                if ((mediaCasterStreamItem = (mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams()).acquire(string, string2)) != null) {
                    mediaCasterHolder = new MediaCasterHolder(string, string2, mediaCasterStreamItem);
                    ++mediaCasterHolder.lockCount;
                    this.lockMap.put(string, mediaCasterHolder);
                } else {
                    ModuleMediaCaster.getLogger().error("ModuleMediaCaster.acquireMediaCaster(streamName:" + string + " streamType:" + string2 + "): Failure");
                }
            } else {
                mediaCasterHolder.mediaCasterItem.acquire();
                ++mediaCasterHolder.lockCount;
            }
            if (mediaCasterHolder != null) {
                ModuleMediaCaster.getLogger().info("ModuleMediaCaster.acquireMediaCaster(streamName:" + string + " streamType:" + string2 + "): Success");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMediaCaster(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        Map<String, MediaCasterHolder> map = this.lockMap;
        synchronized (map) {
            MediaCasterHolder mediaCasterHolder = this.lockMap.get(string);
            if (mediaCasterHolder != null) {
                mediaCasterHolder.mediaCasterItem.release();
                --mediaCasterHolder.lockCount;
                if (mediaCasterHolder.lockCount == 0) {
                    this.lockMap.remove(string);
                }
                ModuleMediaCaster.getLogger().info("ModuleMediaCaster.releaseMediaCaster(streamName:" + string + "): Success");
            } else {
                ModuleMediaCaster.getLogger().error("ModuleMediaCaster.releaseMediaCaster(streamName:" + string + "): Failure");
            }
        }
    }

    class MediaCasterHolder {
        int lockCount = 0;
        String streamName = null;
        String streamType = null;
        MediaCasterStreamItem mediaCasterItem = null;

        public MediaCasterHolder(String string, String string2, MediaCasterStreamItem mediaCasterStreamItem) {
            this.streamName = string;
            this.streamType = string2;
            this.mediaCasterItem = mediaCasterStreamItem;
        }
    }
}

