/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.module;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleFunctions;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.vhost.IVHost;
import java.util.Date;

public abstract class ModuleBase {
    public static final int PARAMMETHODNAME = 0;
    public static final int PARAM1 = 3;
    public static final int PARAM2 = 4;
    public static final int PARAM3 = 5;
    public static final int PARAM4 = 6;
    public static final int PARAM5 = 7;
    public static final int PARAM6 = 8;
    public static final int PARAM7 = 9;
    public static final int PARAM8 = 10;
    public static final int PARAM9 = 11;
    public static final int PARAM10 = 12;
    public static final int CALLBACK_PARAM1 = 1;
    public static final int CALLBACK_PARAM2 = 2;
    public static final int CALLBACK_PARAM3 = 3;
    public static final int CALLBACK_PARAM4 = 4;
    public static final int CALLBACK_PARAM5 = 5;
    public static final int CALLBACK_PARAM6 = 6;
    public static final int CALLBACK_PARAM7 = 7;
    public static final int CALLBACK_PARAM8 = 8;
    public static final int CALLBACK_PARAM9 = 9;
    public static final int CALLBACK_PARAM10 = 10;
    public static final String PLAYTRANSITIONSTR_APPEND = "append";
    public static final String PLAYTRANSITIONSTR_RESET = "reset";
    public static final String PLAYTRANSITIONSTR_STOP = "stop";
    public static final String PLAYTRANSITIONSTR_SWAP = "swap";
    public static final String PLAYTRANSITIONSTR_SWITCH = "switch";
    public static final String PLAYTRANSITIONSTR_UNKNOWN = "unknown";
    public static final int PLAYTRANSITION_APPEND = 0;
    public static final int PLAYTRANSITION_RESET = 1;
    public static final int PLAYTRANSITION_APPEND_IMMEDIATE = 2;
    public static final int PLAYTRANSITION_RESET_IMMEDIATE = 3;
    public static final int PLAYTRANSITION_STOP = 10;
    public static final int PLAYTRANSITION_SWAP = 12;
    public static final int PLAYTRANSITION_SWITCH = 13;
    public static final int PLAYTRANSITION_UNKNOWN = 14;

    protected static int getParamCount(AMFDataList aMFDataList) {
        return aMFDataList.size() - 3;
    }

    protected static int getCallbackParamCount(AMFDataList aMFDataList) {
        return aMFDataList.size() - 1;
    }

    protected static int getParamType(AMFDataList aMFDataList, int n) {
        AMFData aMFData;
        int n2 = 5;
        if (aMFDataList.size() > n && (aMFData = aMFDataList.get(n)) != null) {
            n2 = aMFData.getType();
        }
        return n2;
    }

    protected static AMFData getParam(AMFDataList aMFDataList, int n) {
        AMFData aMFData = null;
        if (aMFDataList.size() > n) {
            aMFData = aMFDataList.get(n);
        }
        return aMFData;
    }

    protected static AMFDataMixedArray getParamMixedArray(AMFDataList aMFDataList, int n) {
        AMFDataMixedArray aMFDataMixedArray = null;
        if (aMFDataList.size() > n) {
            aMFDataMixedArray = (AMFDataMixedArray)aMFDataList.get(n);
        }
        return aMFDataMixedArray;
    }

    protected static AMFDataObj getParamObj(AMFDataList aMFDataList, int n) {
        AMFDataObj aMFDataObj = null;
        if (aMFDataList.size() > n) {
            aMFDataObj = (AMFDataObj)aMFDataList.get(n);
        }
        return aMFDataObj;
    }

    protected static String getParamString(AMFDataList aMFDataList, int n) {
        return ModuleBase.getParamString(aMFDataList, n, null);
    }

    protected static String getParamString(AMFDataList aMFDataList, int n, String string) {
        String string2 = string;
        if (aMFDataList.size() > n) {
            AMFData aMFData = aMFDataList.get(n);
            if (aMFData.getType() == 2) {
                string2 = (String)aMFData.getValue();
            } else if (aMFData.getType() == 5) {
                string2 = null;
            }
        }
        return string2;
    }

    protected static Date getParamDate(AMFDataList aMFDataList, int n) {
        AMFData aMFData;
        Date date = null;
        if (aMFDataList.size() > n && (aMFData = aMFDataList.get(n)).getType() == 11) {
            date = (Date)aMFData.getValue();
        }
        return date;
    }

    protected static int getParamInt(AMFDataList aMFDataList, int n) {
        return ModuleBase.getParamInt(aMFDataList, n, 0);
    }

    protected static int getParamInt(AMFDataList aMFDataList, int n, int n2) {
        AMFData aMFData;
        int n3 = n2;
        if (aMFDataList.size() > n && (aMFData = aMFDataList.get(n)).getType() == 0) {
            n3 = ((Double)aMFData.getValue()).intValue();
        }
        return n3;
    }

    protected static double getParamDouble(AMFDataList aMFDataList, int n) {
        return ModuleBase.getParamDouble(aMFDataList, n, 0.0);
    }

    protected static double getParamDouble(AMFDataList aMFDataList, int n, double d) {
        AMFData aMFData;
        double d2 = d;
        if (aMFDataList.size() > n && (aMFData = aMFDataList.get(n)).getType() == 0) {
            d2 = (Double)aMFData.getValue();
        }
        return d2;
    }

    protected static long getParamLong(AMFDataList aMFDataList, int n) {
        return ModuleBase.getParamLong(aMFDataList, n, 0L);
    }

    protected static long getParamLong(AMFDataList aMFDataList, int n, long l) {
        AMFData aMFData;
        long l2 = l;
        if (aMFDataList.size() > n && (aMFData = aMFDataList.get(n)).getType() == 0) {
            l2 = ((Double)aMFData.getValue()).longValue();
        }
        return l2;
    }

    protected static boolean getParamBoolean(AMFDataList aMFDataList, int n) {
        return ModuleBase.getParamBoolean(aMFDataList, n, false);
    }

    protected static boolean getParamBoolean(AMFDataList aMFDataList, int n, boolean bl) {
        boolean bl2 = bl;
        if (aMFDataList.size() > n) {
            AMFData aMFData = aMFDataList.get(n);
            if (aMFData.getType() == 1) {
                bl2 = (Boolean)aMFData.getValue();
            } else if (aMFData.getType() == 2) {
                String string = (String)aMFData.getValue();
                bl2 = string.compareToIgnoreCase("true") == 0 || string.compareToIgnoreCase("yes") == 0;
            }
        }
        return bl2;
    }

    protected static IApplicationInstance getAppInstance(IClient iClient) {
        return iClient.getAppInstance();
    }

    protected static IApplication getApplication(IClient iClient) {
        return iClient.getAppInstance().getApplication();
    }

    protected static boolean isSendResult(AMFDataList aMFDataList) {
        double d = (Double)aMFDataList.get(1).getValue();
        return d > 0.0;
    }

    protected static IVHost getVHost(IClient iClient) {
        return iClient.getAppInstance().getApplication().getVHost();
    }

    protected static boolean sendResult(IClient iClient, AMFDataList aMFDataList, String string) {
        double d = (Double)aMFDataList.get(1).getValue();
        if (d > 0.0) {
            ResponseFunction responseFunction = new ResponseFunction(iClient);
            responseFunction.createDefaultMessage("_result", d);
            responseFunction.addBody(new AMFDataItem(string));
            iClient.getRespFunctions().add(responseFunction);
            return true;
        }
        return false;
    }

    protected static boolean sendResult(IClient iClient, AMFDataList aMFDataList, boolean bl) {
        double d = (Double)aMFDataList.get(1).getValue();
        if (d > 0.0) {
            ResponseFunction responseFunction = new ResponseFunction(iClient);
            responseFunction.createDefaultMessage("_result", d);
            responseFunction.addBody(new AMFDataItem(bl));
            iClient.getRespFunctions().add(responseFunction);
            return true;
        }
        return false;
    }

    protected static boolean sendResult(IClient iClient, AMFDataList aMFDataList, int n) {
        return ModuleBase.sendResult(iClient, aMFDataList, (double)n);
    }

    protected static boolean sendResult(IClient iClient, AMFDataList aMFDataList, double d) {
        double d2 = (Double)aMFDataList.get(1).getValue();
        if (d2 > 0.0) {
            ResponseFunction responseFunction = new ResponseFunction(iClient);
            responseFunction.createDefaultMessage("_result", d2);
            responseFunction.addBody(new AMFDataItem(d));
            iClient.getRespFunctions().add(responseFunction);
            return true;
        }
        return false;
    }

    protected static boolean sendResult(IClient iClient, AMFDataList aMFDataList, AMFData aMFData) {
        double d = (Double)aMFDataList.get(1).getValue();
        if (d > 0.0) {
            ResponseFunction responseFunction = new ResponseFunction(iClient);
            responseFunction.createDefaultMessage("_result", d);
            responseFunction.addBody(aMFData);
            iClient.getRespFunctions().add(responseFunction);
            return true;
        }
        return false;
    }

    protected static WMSLogger getLogger() {
        return WMSLoggerFactory.getLogger(null);
    }

    protected static IMediaStream getStream(IClient iClient, RequestFunction requestFunction) {
        int n = requestFunction.getSrc();
        if (n > 0) {
            return ModuleBase.getAppInstance(iClient).getStreams().getStream(iClient, n);
        }
        return null;
    }

    protected static void invokePrevious(Object object, IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        block0: {
            ModuleFunctions moduleFunctions;
            IApplicationInstance iApplicationInstance;
            if (iClient == null || (iApplicationInstance = iClient.getAppInstance()) == null || (moduleFunctions = iApplicationInstance.getModFunctions()) == null) break block0;
            String string = aMFDataList.getString(0);
            moduleFunctions.invokePrevious(string, object, iClient, requestFunction, aMFDataList);
        }
    }

    protected void invokePrevious(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        ModuleBase.invokePrevious(this, iClient, requestFunction, aMFDataList);
    }

    protected static void sendClientOnStatusError(IClient iClient, String string, String string2) {
        try {
            ResponseFunction responseFunction = null;
            responseFunction = new ResponseFunction(iClient);
            responseFunction.createDefaultMessage("onStatus", 0.0);
            AMFDataObj aMFDataObj = null;
            aMFDataObj = new AMFDataObj();
            aMFDataObj.put("level", new AMFDataItem("error"));
            aMFDataObj.put("code", new AMFDataItem(string));
            aMFDataObj.put("description", new AMFDataItem(string2));
            aMFDataObj.put("clientid", new AMFDataItem((double)iClient.getClientId()));
            responseFunction.addBody(aMFDataObj);
            iClient.getRespFunctions().add(responseFunction);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("ModuleBase.sendStreamOnStatusError: " + exception.toString());
        }
    }

    protected static void sendStreamOnStatusError(IMediaStream iMediaStream, String string, String string2) {
        String string3 = iMediaStream.getName();
        IClient iClient = iMediaStream.getClient();
        try {
            ResponseFunction responseFunction = null;
            responseFunction = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
            responseFunction.createDefaultMessage("onStatus", 0.0);
            responseFunction.setSrc(iMediaStream.getSrc());
            AMFDataObj aMFDataObj = null;
            aMFDataObj = new AMFDataObj();
            aMFDataObj.put("level", new AMFDataItem("error"));
            aMFDataObj.put("code", new AMFDataItem(string));
            aMFDataObj.put("description", new AMFDataItem(string2));
            aMFDataObj.put("clientid", new AMFDataItem((double)iClient.getClientId()));
            responseFunction.addBody(aMFDataObj);
            iClient.getRespFunctions().add(responseFunction);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("ModuleBase.sendStreamOnStatusError: " + exception.toString());
        }
    }
}

