/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.request;

import com.wowza.util.DebugUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.nio.ByteBuffer;

public class RequestFunction {
    private int src;
    private long timecode;
    private ByteBuffer data = null;
    private ByteBuffer extraData = null;
    private int size = 0;
    private int type = 0;
    private int headerSize = 0;
    private int wmsNumber;

    public byte[] getData() {
        if (this.data != null) {
            return this.data.array();
        }
        return null;
    }

    public ByteBuffer getDataByteBuffer() {
        if (this.data != null) {
            return this.data;
        }
        return null;
    }

    public int getSize() {
        return this.size;
    }

    public int getMissing() {
        try {
            return this.size - this.data.position();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestFunction.class).error("getMissing: " + exception.toString());
            exception.printStackTrace();
            return 0;
        }
    }

    public void setSize(int n) {
        try {
            this.size = n;
            this.data = ByteBuffer.allocate(this.size);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestFunction.class).error("setSize: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public int getSrc() {
        return this.src;
    }

    public void setSrc(int n) {
        this.src = n;
    }

    public void addData(byte[] byArray, int n, int n2) {
        try {
            this.data.put(byArray, n, n2);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestFunction.class).error("addData: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public boolean isPartial() {
        return this.size - this.data.position() > 0;
    }

    public AMFDataList getMessage() {
        boolean bl;
        this.data.rewind();
        if (this.type == 17 || this.type == 15) {
            this.data.get();
        }
        if (bl = false) {
            int n = this.data.position();
            int n2 = this.data.remaining();
            byte[] byArray = new byte[n2];
            this.data.get(byArray);
            System.out.println("getMessage\n" + DebugUtils.formatBytes(byArray));
            this.data.position(n);
        }
        AMFDataList aMFDataList = new AMFDataList(this.data, AMFData.createContextDeserialize(0));
        if (bl) {
            System.out.println("getMessage\n" + aMFDataList.toString());
        }
        return aMFDataList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("**** function ****\n");
        stringBuffer.append("size: " + this.size + "\n");
        stringBuffer.append("src: " + this.src + "\n");
        stringBuffer.append("type: " + this.type + "\n");
        stringBuffer.append("timecode: " + this.timecode + "\n");
        if (this.size > 0 && this.data != null) {
            stringBuffer.append("dump:\n" + DebugUtils.formatBytes(this.data.array()) + "\n\n");
            AMFDataList aMFDataList = this.getMessage();
            if (aMFDataList != null) {
                stringBuffer.append("RequestFunction:\n" + aMFDataList.toString() + "\n\n");
            }
        }
        return stringBuffer.toString();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public long getTimecode() {
        return this.timecode;
    }

    public void setTimecode(long l) {
        this.timecode = l;
    }

    public int getWmsNumber() {
        return this.wmsNumber;
    }

    public void setWmsNumber(int n) {
        this.wmsNumber = n;
    }

    public ByteBuffer getExtraData() {
        return this.extraData;
    }

    public void setExtraData(ByteBuffer byteBuffer) {
        this.extraData = byteBuffer;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(int n) {
        this.headerSize = n;
    }
}

