/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerBase;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerQuicktimeH264;
import com.wowza.wms.rtp.depacketizer.RTPPacket;
import com.wowza.wms.rtp.depacketizer.RTPPacketCodecConfigInfo;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.util.RTPUtils;

public abstract class RTPDePacketizerVideoBase
extends RTPDePacketizerBase {
    protected boolean isFirstPacket = true;

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        super.init(rTPContext, rTPDePacketizerItem);
    }

    protected boolean isCodecConfig(RTPTrack rTPTrack) {
        return false;
    }

    protected byte[] getCodecConfig(RTPTrack rTPTrack) {
        return null;
    }

    protected void sendPacket(RTPTrack rTPTrack, RTPPacket rTPPacket, boolean bl) {
        try {
            Object object;
            RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo;
            int n = rTPTrack.getTimescale();
            boolean bl2 = this.isCodecConfig(rTPTrack);
            boolean bl3 = this.rtcpHandler.isTimeSyncReady(rTPTrack, rTPPacket.getTimecode());
            if (rTPPacket.getCodec() == 7 && !bl2 && (rTPPacketCodecConfigInfo = rTPPacket.getH264CodecConfigInfo(rTPTrack)) != null) {
                byte[] byArray = null;
                object = rTPTrack.getTrackInfo("profile-level-id");
                if (object != null) {
                    byArray = BufferUtils.decodeHexString((String)object);
                }
                byte[] byArray2 = RTPUtils.formatH264CodecConfig(rTPPacketCodecConfigInfo.sps, rTPPacketCodecConfigInfo.ppss, byArray);
                rTPTrack.setCodecConfig(byArray2);
                bl2 = true;
            }
            if (!bl3 && !bl3) {
                this.checkRTCPMissingWarning();
            }
            if (bl3 && (rTPPacket.getCodec() != 7 || bl2)) {
                long l = this.rtcpHandler.convertTimeSyncTimecode(rTPPacket.getTimecode(), n);
                if (this.isFirstPacket) {
                    if (rTPPacket.getCodec() == 7) {
                        object = this.getCodecConfig(rTPTrack);
                        if (this.debugLog) {
                            WMSLoggerFactory.getLogger(RTPDePacketizerQuicktimeH264.class).debug("RTPDePacketizerVideoBase.sendPacket: writeCodecConfig\n" + (object == null ? "null" : DebugUtils.formatBytes((byte[])object)));
                        }
                        if (object != null) {
                            RTPUtils.writeCodecConfig(rTPTrack, l, (byte[])object);
                        }
                    }
                    this.isFirstPacket = false;
                }
                if (this.debugLog) {
                    rTPPacket.setDebugLog(true);
                }
                rTPPacket.write(rTPTrack, l, bl);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPDePacketizerQuicktimeH264.class).error("RTPDePacketizerVideoBase.sendPacket: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

