/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.RTPResponseTracker;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.server.IResponseListener;
import com.wowza.wms.server.RtmpResponseMessage;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.support.IWriteListener;

public class RTPWriteListener
implements IWriteListener,
IResponseListener {
    private RTPSession rtpSession = null;
    private RTPResponseTracker pendingTracker = null;
    private RTPResponseTracker lastTracker = null;
    private Map<Long, RTPResponseTracker> pendingRequests = new HashMap<Long, RTPResponseTracker>();
    private boolean multiSessionDetected = false;

    public RTPWriteListener(RTPSession rTPSession) {
        this.rtpSession = rTPSession;
    }

    public synchronized void unhook() {
        this.rtpSession = null;
        this.pendingTracker = null;
        this.lastTracker = null;
        this.pendingRequests.clear();
    }

    public synchronized void onQueWriteRequest(IoFilter.WriteRequest writeRequest) {
        if (this.pendingTracker != null) {
            boolean bl = true;
            int n = 0;
            Object object = writeRequest.getMessage();
            if (object instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)object;
                n = byteBuffer.limit();
            } else {
                WMSLoggerFactory.getLogger(null).warn("RTPWriteListener.onQueWriteRequest: cannot calculate packetSize");
            }
            if (bl) {
                long l = this.pendingTracker.incTotalSize(n);
                this.pendingTracker.incPacketCount();
                if (l == (long)n) {
                    this.pendingTracker.setSendTime(System.currentTimeMillis());
                }
                this.pendingRequests.put(new Long(writeRequest.getWriteId()), this.pendingTracker);
            }
        }
    }

    public synchronized void onWriteWriteRequest(IoFilter.WriteRequest writeRequest, long l) {
        long l2 = writeRequest.getWriteId();
        if (l2 < 0L) {
            return;
        }
        RTPResponseTracker rTPResponseTracker = this.pendingRequests.get(new Long(l2));
        if (rTPResponseTracker != null) {
            long l3 = rTPResponseTracker.decRemaingSize(l);
            this.lastTracker = rTPResponseTracker;
        }
    }

    public synchronized void onCompleteWriteRequest(IoFilter.WriteRequest writeRequest) {
        long l = writeRequest.getWriteId();
        if (l < 0L) {
            return;
        }
        RTPResponseTracker rTPResponseTracker = this.pendingRequests.get(new Long(l));
        if (rTPResponseTracker != null) {
            rTPResponseTracker.decPacketCount();
            if (rTPResponseTracker.getPacketCount() == 0) {
                long l2 = rTPResponseTracker.getRemaining();
                if (l2 != 0L) {
                    rTPResponseTracker.decRemaingSize(l2);
                }
                rTPResponseTracker.setCompleteTime(System.currentTimeMillis());
            }
        }
    }

    public synchronized void onResponseWriteStart(RtmpResponseMessage rtmpResponseMessage) {
    }

    public synchronized void onResponseWriteStop(RtmpResponseMessage rtmpResponseMessage) {
        this.pendingTracker = null;
    }

    public synchronized RTPResponseTracker getLastTracker() {
        return this.lastTracker;
    }

    public synchronized RTPResponseTracker getPendingTracker() {
        if (this.pendingTracker == null) {
            this.pendingTracker = new RTPResponseTracker();
        }
        return this.pendingTracker;
    }
}

