/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.IUDPTransport;
import com.wowza.wms.rtp.transport.RTPMulticastListener;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.UDPTransportBase;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class RTPMulticastTransport
extends UDPTransportBase
implements IUDPTransport {
    private Map<InetSocketAddress, MulticastListener> listeners = new HashMap<InetSocketAddress, MulticastListener>();

    public InetSocketAddress bind(RTPUDPDatagramConfig rTPUDPDatagramConfig, IUDPMessageHandler iUDPMessageHandler, String string, int n, String string2, int n2, int n3) {
        InetSocketAddress inetSocketAddress = null;
        try {
            String string3 = null;
            int n4 = 0;
            if (n3 == 1) {
                string3 = string;
                n4 = n;
                inetSocketAddress = string == null ? new InetSocketAddress(n) : new InetSocketAddress(string, n);
            } else {
                string3 = string2;
                n4 = n2;
                inetSocketAddress = string2 == null ? new InetSocketAddress(n2) : new InetSocketAddress(string2, n2);
            }
            RTPMulticastListener rTPMulticastListener = new RTPMulticastListener();
            Executor executor = this.getExecutor();
            rTPMulticastListener.bind(rTPUDPDatagramConfig, executor, iUDPMessageHandler, string3, n4, n3);
            this.listeners.put(inetSocketAddress, new MulticastListener(inetSocketAddress, rTPMulticastListener));
            rTPMulticastListener.setTimeToLive(this.timeToLive);
            rTPMulticastListener.setInterfaceAddress(this.multicastInterfaceAddress);
            rTPMulticastListener.setDaemon(true);
            rTPMulticastListener.setPriority(10);
            rTPMulticastListener.start();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastTransport.class).error("RTPMulticastTransport.bind: " + exception.toString());
            exception.printStackTrace();
        }
        return inetSocketAddress;
    }

    public void unbindAll() {
        try {
            for (InetSocketAddress inetSocketAddress : this.listeners.keySet()) {
                MulticastListener multicastListener = this.listeners.get(inetSocketAddress);
                if (multicastListener == null) continue;
                multicastListener.listener.unbind();
            }
            this.listeners.clear();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastTransport.class).error("RTPMulticastTransport.unbindAll: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void unbind(InetSocketAddress inetSocketAddress) {
        try {
            MulticastListener multicastListener = this.listeners.remove(inetSocketAddress);
            if (multicastListener != null) {
                multicastListener.listener.unbind();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastTransport.class).error("RTPMulticastTransport.unbind: " + exception.toString());
            exception.printStackTrace();
        }
    }

    class MulticastListener {
        public InetSocketAddress socketAddress = null;
        public RTPMulticastListener listener = null;

        public MulticastListener(InetSocketAddress inetSocketAddress, RTPMulticastListener rTPMulticastListener) {
            this.socketAddress = inetSocketAddress;
            this.listener = rTPMulticastListener;
        }
    }
}

