/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.IUDPTransport;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.RTPUDPListener;
import com.wowza.wms.rtp.transport.RTPUDPTransportMina;
import com.wowza.wms.rtp.transport.UDPRunner;
import com.wowza.wms.rtp.transport.UDPTransportBase;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class RTPUDPTransport
extends UDPTransportBase
implements IUDPTransport {
    private Map<SocketAddress, RTPUDPListener> listeners = new HashMap<SocketAddress, RTPUDPListener>();
    private UDPRunner runner = null;

    public InetSocketAddress bind(RTPUDPDatagramConfig rTPUDPDatagramConfig, IUDPMessageHandler iUDPMessageHandler, String string, int n, String string2, int n2, int n3) {
        InetSocketAddress inetSocketAddress = null;
        try {
            Executor executor = this.getExecutor();
            if (this.runner == null) {
                this.runner = new UDPRunner();
                this.runner.setExecutor(executor);
            }
            inetSocketAddress = string != null ? (string.equals("0.0.0.0") || string.equals("0.0.0.0.0") || string.equals("@") ? new InetSocketAddress(n) : new InetSocketAddress(string, n)) : new InetSocketAddress(n);
            RTPUDPListener rTPUDPListener = this.listeners.remove(inetSocketAddress);
            if (rTPUDPListener != null) {
                rTPUDPListener.unbind();
                rTPUDPListener.quit();
            }
            rTPUDPListener = new RTPUDPListener(rTPUDPDatagramConfig, inetSocketAddress, iUDPMessageHandler, this.runner);
            this.listeners.put(inetSocketAddress, rTPUDPListener);
            rTPUDPListener.setDaemon(true);
            rTPUDPListener.setName("RTPUDPTransport-" + inetSocketAddress.toString());
            rTPUDPListener.setPriority(10);
            rTPUDPListener.start();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).error("RTPUDPTransport.bind[" + inetSocketAddress + "]: " + exception.toString());
        }
        return inetSocketAddress;
    }

    public void unbind(InetSocketAddress inetSocketAddress) {
        try {
            RTPUDPListener rTPUDPListener = this.listeners.remove(inetSocketAddress);
            if (rTPUDPListener != null) {
                rTPUDPListener.unbind();
                rTPUDPListener.quit();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).error("RTPUDPTransport.unbind[" + inetSocketAddress + "]: " + exception.toString());
        }
    }

    public void unbindAll() {
        ArrayList<SocketAddress> arrayList = new ArrayList<SocketAddress>(this.listeners.keySet());
        for (InetSocketAddress inetSocketAddress : arrayList) {
            this.unbind(inetSocketAddress);
        }
    }
}

